/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.recipe.bargain;

import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.network.PacketDistributor;
import tictim.paraglider.capabilities.ServerPlayerMovement;
import tictim.paraglider.contents.Contents;
import tictim.paraglider.network.ModNet;
import tictim.paraglider.network.StatueDialogMsg;
import tictim.paraglider.network.SyncLookAtMsg;
import tictim.paraglider.network.UpdateBargainPreviewMsg;
import tictim.paraglider.recipe.bargain.BargainResult;
import tictim.paraglider.recipe.bargain.StatueBargain;
import tictim.paraglider.utils.StatueDialog;

public class StatueBargainContainer
extends Container {
    private final PlayerInventory playerInventory;
    private final List<StatueBargain> bargains;
    @Nullable
    private final StatueDialog dialog;
    @Nullable
    private ResourceLocation advancement;
    private int heartContainerCache;
    private int staminaVesselCache;
    private int essenceCache;
    private final Preview[] previousBargainTest;
    private final NonNullList<ItemStack> inventoryCache;
    @Nullable
    private Vector3d lookAt;
    @Nullable
    private Vector3d prevLookAt;
    private boolean redoBargainTest = true;
    private boolean sendInitMessage = true;

    public StatueBargainContainer(@Nullable ContainerType<?> type, int id, PlayerInventory playerInventory) {
        this(type, id, playerInventory, null, null);
    }

    public StatueBargainContainer(@Nullable ContainerType<?> type, int id, PlayerInventory playerInventory, @Nullable StatueDialog dialog, @Nullable ResourceLocation advancement) {
        super(type, id);
        int i;
        this.playerInventory = playerInventory;
        this.dialog = dialog;
        this.advancement = advancement;
        this.bargains = playerInventory.field_70458_d.field_70170_p.func_199532_z().func_241447_a_(Contents.STATUE_BARGAIN_RECIPE_TYPE).stream().filter(b -> type == null || b.getBargainOwner().equals((Object)type.getRegistryName())).sorted(Comparator.comparing(IRecipe::func_199560_c)).collect(Collectors.toList());
        this.previousBargainTest = new Preview[this.bargains.size()];
        for (i = 0; i < this.previousBargainTest.length; ++i) {
            this.previousBargainTest[i] = new Preview();
        }
        this.inventoryCache = NonNullList.func_191197_a((int)playerInventory.func_70302_i_(), (Object)ItemStack.field_190927_a);
        for (i = 0; i < playerInventory.func_70302_i_(); ++i) {
            ItemStack stack = playerInventory.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            this.inventoryCache.set(i, (Object)stack.func_77946_l());
        }
    }

    public List<StatueBargain> getBargains() {
        return this.bargains;
    }

    @Nullable
    public StatueBargain getBargain(int bargainIndex) {
        if (bargainIndex < 0) {
            return null;
        }
        return this.bargains.size() > bargainIndex ? this.bargains.get(bargainIndex) : null;
    }

    public boolean canBargain(int bargainIndex) {
        if (bargainIndex < 0) {
            return false;
        }
        return this.previousBargainTest.length > bargainIndex && this.previousBargainTest[bargainIndex].canBargain;
    }

    public ItemDemand[] getDemandPreview(int bargainIndex) {
        if (bargainIndex < 0) {
            return new ItemDemand[0];
        }
        return this.previousBargainTest.length > bargainIndex ? this.previousBargainTest[bargainIndex].demands : new ItemDemand[]{};
    }

    @Nullable
    public Vector3d getLookAt() {
        return this.lookAt;
    }

    public void setLookAt(@Nullable Vector3d lookAt) {
        this.lookAt = lookAt;
    }

    @Nullable
    public ResourceLocation getAdvancement() {
        return this.advancement;
    }

    public void setAdvancement(@Nullable ResourceLocation advancement) {
        this.advancement = advancement;
    }

    public boolean func_75145_c(PlayerEntity playerIn) {
        return true;
    }

    public void func_75142_b() {
        ServerPlayerMovement m = ServerPlayerMovement.of((ICapabilityProvider)this.playerInventory.field_70458_d);
        if (m != null) {
            if (this.heartContainerCache != m.getHeartContainers()) {
                this.redoBargainTest = true;
                this.heartContainerCache = m.getHeartContainers();
            }
            if (this.staminaVesselCache != m.getStaminaVessels()) {
                this.redoBargainTest = true;
                this.staminaVesselCache = m.getStaminaVessels();
            }
            if (this.essenceCache != m.getEssence()) {
                this.redoBargainTest = true;
                this.essenceCache = m.getEssence();
            }
        }
        if (this.inventoryChanged()) {
            this.redoBargainTest = true;
        }
        if (this.redoBargainTest) {
            this.updateBargainTest();
        }
        if (this.sendInitMessage) {
            this.sendInitMessage = false;
            this.sendDialog(StatueDialog.Case.INITIAL, null, null);
        }
        if (this.prevLookAt != this.lookAt) {
            this.prevLookAt = this.lookAt;
            this.sendToPlayer(new SyncLookAtMsg(this.lookAt));
        }
        super.func_75142_b();
    }

    private boolean inventoryChanged() {
        boolean changed = false;
        for (int i = 0; i < this.playerInventory.func_70302_i_(); ++i) {
            ItemStack s1 = this.playerInventory.func_70301_a(i);
            ItemStack s2 = (ItemStack)this.inventoryCache.get(i);
            if (ItemStack.func_77989_b((ItemStack)s2, (ItemStack)s1)) continue;
            ItemStack copy = s1.func_77946_l();
            this.inventoryCache.set(i, (Object)copy);
            changed = true;
        }
        return changed;
    }

    private void updateBargainTest() {
        UpdateBargainPreviewMsg msg = null;
        for (int i = 0; i < this.bargains.size(); ++i) {
            Preview preview = this.previousBargainTest[i];
            StatueBargain bargain = this.bargains.get(i);
            boolean canBargainUpdated = preview.updateCanBargain(bargain, this.playerInventory.field_70458_d);
            boolean demandPreviewUpdated = preview.updateDemandPreview(bargain, this.playerInventory.field_70458_d);
            if (!canBargainUpdated && !demandPreviewUpdated) continue;
            if (msg == null) {
                msg = new UpdateBargainPreviewMsg();
            }
            msg.add(bargain.func_199560_c(), preview, demandPreviewUpdated);
        }
        if (msg != null) {
            this.sendToPlayer(msg);
        }
        this.redoBargainTest = false;
    }

    public void sendDialog(StatueBargain bargain, BargainResult result) {
        this.sendDialog(result.isSuccess() ? StatueDialog.Case.BARGAIN_SUCCESS : StatueDialog.Case.BARGAIN_FAILURE, bargain, result);
    }

    private void sendDialog(StatueDialog.Case dialogCase, @Nullable StatueBargain bargain, @Nullable BargainResult result) {
        if (this.dialog == null) {
            return;
        }
        ITextComponent dialog = this.dialog.getDialog(this.playerInventory.field_70458_d.func_70681_au(), dialogCase, bargain, result);
        if (dialog != null) {
            this.sendToPlayer(new StatueDialogMsg(dialog));
        }
    }

    private void sendToPlayer(Object message) {
        PlayerEntity player = this.playerInventory.field_70458_d;
        if (player instanceof ServerPlayerEntity) {
            ModNet.NET.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player), message);
        }
    }

    public void setCanBargain(ResourceLocation key, boolean booleanValue) {
        List<StatueBargain> bargains = this.getBargains();
        int bargainsSize = bargains.size();
        for (int i = 0; i < bargainsSize; ++i) {
            StatueBargain bargain = bargains.get(i);
            if (!key.equals((Object)bargain.func_199560_c())) continue;
            this.previousBargainTest[i].setCanBargain(booleanValue);
            return;
        }
    }

    public void setDemandPreview(ResourceLocation key, ItemDemand[] demands) {
        List<StatueBargain> bargains = this.getBargains();
        int bargainsSize = bargains.size();
        for (int i = 0; i < bargainsSize; ++i) {
            StatueBargain bargain = bargains.get(i);
            if (!key.equals((Object)bargain.func_199560_c())) continue;
            this.previousBargainTest[i].setDemands(demands);
            return;
        }
    }

    public static final class ItemDemand {
        private final ItemStack[] previewItems;
        private final int quantity;
        private final int count;

        public ItemDemand(ItemStack[] previewItems, int quantity, int count) {
            this.previewItems = previewItems;
            this.quantity = quantity;
            this.count = count;
        }

        public ItemStack[] getPreviewItems() {
            return this.previewItems;
        }

        public int getQuantity() {
            return this.quantity;
        }

        public int getCount() {
            return this.count;
        }
    }

    public static final class Preview {
        private boolean canBargain;
        private ItemDemand[] demands = new ItemDemand[0];

        public boolean canBargain() {
            return this.canBargain;
        }

        public void setCanBargain(boolean canBargain) {
            this.canBargain = canBargain;
        }

        public ItemDemand[] getDemands() {
            return this.demands;
        }

        public void setDemands(ItemDemand[] demands) {
            this.demands = demands;
        }

        public boolean updateCanBargain(StatueBargain bargain, PlayerEntity player) {
            boolean canBargain = bargain.bargain(player, true).isSuccess();
            if (this.canBargain == canBargain) {
                return false;
            }
            this.canBargain = canBargain;
            return true;
        }

        public boolean updateDemandPreview(StatueBargain bargain, PlayerEntity player) {
            ItemDemand[] demands = (ItemDemand[])bargain.getPreview().getDemands().stream().map(demand -> new ItemDemand(demand.getPreviewItems(), demand.getQuantity(), demand.getCounter().count(player))).toArray(ItemDemand[]::new);
            if (Preview.isSame(this.demands, demands)) {
                return false;
            }
            this.demands = demands;
            return true;
        }

        private static boolean isSame(ItemDemand[] a1, ItemDemand[] a2) {
            if (a1.length != a2.length) {
                return false;
            }
            for (int i = 0; i < a1.length; ++i) {
                if (a1[i].count == a2[i].count) continue;
                return false;
            }
            return true;
        }
    }
}

