/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.utils;

import java.util.Objects;
import net.minecraft.util.math.MathHelper;

public final class Color {
    public final float red;
    public final float green;
    public final float blue;
    public final float alpha;

    public static Color of(int red, int green, int blue) {
        return new Color((float)MathHelper.func_76125_a((int)red, (int)0, (int)255) / 255.0f, (float)MathHelper.func_76125_a((int)green, (int)0, (int)255) / 255.0f, (float)MathHelper.func_76125_a((int)blue, (int)0, (int)255) / 255.0f);
    }

    public static Color of(int red, int green, int blue, int alpha) {
        return new Color((float)MathHelper.func_76125_a((int)red, (int)0, (int)255) / 255.0f, (float)MathHelper.func_76125_a((int)green, (int)0, (int)255) / 255.0f, (float)MathHelper.func_76125_a((int)blue, (int)0, (int)255) / 255.0f, (float)MathHelper.func_76125_a((int)alpha, (int)0, (int)255) / 255.0f);
    }

    public Color(float red, float green, float blue) {
        this(red, green, blue, 1.0f);
    }

    public Color(float red, float green, float blue, float alpha) {
        this.red = red;
        this.green = green;
        this.blue = blue;
        this.alpha = alpha;
    }

    public Color blend(Color color2, float blend) {
        return new Color(this.red + (color2.red - this.red) * blend, this.green + (color2.green - this.green) * blend, this.blue + (color2.blue - this.blue) * blend, this.alpha + (color2.alpha - this.alpha) * blend);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Color color = (Color)o;
        return Double.compare(color.red, this.red) == 0 && Double.compare(color.green, this.green) == 0 && Double.compare(color.blue, this.blue) == 0 && Double.compare(color.alpha, this.alpha) == 0;
    }

    public int hashCode() {
        return Objects.hash(Float.valueOf(this.red), Float.valueOf(this.green), Float.valueOf(this.blue), Float.valueOf(this.alpha));
    }

    public String toString() {
        return String.format("[R: %f, G: %f, B: %f, A: %f]", Float.valueOf(this.red), Float.valueOf(this.green), Float.valueOf(this.blue), Float.valueOf(this.alpha));
    }
}

