/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.utils;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.function.BiPredicate;
import javax.annotation.Nullable;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import tictim.paraglider.recipe.bargain.BargainResult;
import tictim.paraglider.recipe.bargain.StatueBargain;

public final class StatueDialog {
    private final Map<Case, Dialogs> map = new EnumMap<Case, Dialogs>(Case.class);

    public StatueDialog() {
        for (Case c : Case.values()) {
            this.map.put(c, new Dialogs());
        }
    }

    public StatueDialog atInitial(String translationKey) {
        return this.add(Case.INITIAL, (ITextComponent)new TranslationTextComponent(translationKey));
    }

    public StatueDialog atSuccess(String translationKey) {
        return this.add(Case.BARGAIN_SUCCESS, (ITextComponent)new TranslationTextComponent(translationKey));
    }

    public StatueDialog atSuccess(String translationKey, @Nullable BiPredicate<StatueBargain, BargainResult> predicate) {
        return this.add(Case.BARGAIN_SUCCESS, (ITextComponent)new TranslationTextComponent(translationKey), predicate);
    }

    public StatueDialog atSuccessFallback(String translationKey) {
        return this.setFallback(Case.BARGAIN_SUCCESS, (ITextComponent)new TranslationTextComponent(translationKey));
    }

    public StatueDialog atFailure(String translationKey) {
        return this.add(Case.BARGAIN_FAILURE, (ITextComponent)new TranslationTextComponent(translationKey));
    }

    public StatueDialog atFailure(String translationKey, @Nullable BiPredicate<StatueBargain, BargainResult> predicate) {
        return this.add(Case.BARGAIN_FAILURE, (ITextComponent)new TranslationTextComponent(translationKey), predicate);
    }

    public StatueDialog atFailureFallback(String translationKey) {
        return this.setFallback(Case.BARGAIN_FAILURE, (ITextComponent)new TranslationTextComponent(translationKey));
    }

    public StatueDialog add(Case dialogCase, ITextComponent text) {
        return this.add(dialogCase, text, null);
    }

    public StatueDialog add(Case dialogCase, ITextComponent text, @Nullable BiPredicate<StatueBargain, BargainResult> predicate) {
        this.map.get((Object)dialogCase).dialog.add(new Dialog(predicate, text));
        return this;
    }

    public StatueDialog setFallback(Case dialogCase, ITextComponent text) {
        return this.setFallback(dialogCase, text, null);
    }

    public StatueDialog setFallback(Case dialogCase, ITextComponent text, @Nullable BiPredicate<StatueBargain, BargainResult> predicate) {
        this.map.get((Object)dialogCase).fallback = new Dialog(predicate, text);
        return this;
    }

    @Nullable
    public ITextComponent getDialog(Random random, Case dialogCase, @Nullable StatueBargain bargain, @Nullable BargainResult result) {
        return this.map.get((Object)dialogCase).getDialog(random, bargain, result);
    }

    public static enum Case {
        INITIAL,
        BARGAIN_SUCCESS,
        BARGAIN_FAILURE;

    }

    private static final class Dialog {
        @Nullable
        private final BiPredicate<StatueBargain, BargainResult> predicate;
        private final ITextComponent text;

        public Dialog(@Nullable BiPredicate<StatueBargain, BargainResult> predicate, ITextComponent text) {
            this.predicate = predicate;
            this.text = Objects.requireNonNull(text);
        }
    }

    private static final class Dialogs {
        private final List<Dialog> dialog = new ArrayList<Dialog>();
        @Nullable
        private Dialog fallback;

        private Dialogs() {
        }

        @Nullable
        public ITextComponent getDialog(Random random, @Nullable StatueBargain bargain, @Nullable BargainResult bargainResult) {
            ArrayList<Dialog> dialogs = new ArrayList<Dialog>();
            for (Dialog f : this.dialog) {
                if (bargain != null && bargainResult != null && f.predicate != null && !f.predicate.test(bargain, bargainResult)) continue;
                dialogs.add(f);
            }
            Dialog chosenDialog = dialogs.isEmpty() ? this.fallback : (Dialog)dialogs.get(random.nextInt(dialogs.size()));
            return chosenDialog != null ? chosenDialog.text : null;
        }
    }
}

