/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.utils;

import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import tictim.paraglider.capabilities.wind.Wind;
import tictim.paraglider.capabilities.wind.WindChunk;

public final class WindUtils {
    private WindUtils() {
    }

    public static boolean isInsideWind(World world, AxisAlignedBB boundingBox) {
        return WindUtils.isInsideWind(world, MathHelper.func_76128_c((double)boundingBox.field_72340_a), MathHelper.func_76128_c((double)boundingBox.field_72338_b), MathHelper.func_76128_c((double)boundingBox.field_72339_c), MathHelper.func_76143_f((double)boundingBox.field_72336_d), MathHelper.func_76143_f((double)boundingBox.field_72337_e), MathHelper.func_76143_f((double)boundingBox.field_72334_f));
    }

    public static boolean isInsideWind(World world, int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        Wind wind = Wind.of((ICapabilityProvider)world);
        if (wind == null) {
            return false;
        }
        int chunkXStart = minX >> 4;
        int chunkXEnd = maxX >> 4;
        int chunkZStart = minZ >> 4;
        int chunkZEnd = maxZ >> 4;
        for (int x = chunkXStart; x <= chunkXEnd; ++x) {
            for (int z = chunkZStart; z <= chunkZEnd; ++z) {
                WindChunk windChunk = wind.get(x, z);
                if (windChunk == null || !windChunk.isInsideWind(minX, minY, minZ, maxX, maxY, maxZ)) continue;
                return true;
            }
        }
        return false;
    }
}

