/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.utils;

import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import tictim.paraglider.capabilities.wind.Wind;
import tictim.paraglider.capabilities.wind.WindChunk;

public class WindWriter {
    private final Wind wind;
    private final long gameTime;
    private final Set<WindChunk> modifiedChunks = new HashSet<WindChunk>();
    private int x = Integer.MAX_VALUE;
    private int z = Integer.MAX_VALUE;
    @Nullable
    private WindChunk windChunk;
    private boolean posSet;

    public WindWriter(Wind wind, long gameTime) {
        this.wind = wind;
        this.gameTime = gameTime;
    }

    public Set<WindChunk> getModifiedChunks() {
        return this.modifiedChunks;
    }

    public void setXZ(int x, int z) {
        if (this.posSet) {
            this.end();
        }
        this.posSet = true;
        if (this.x >> 4 != x >> 4 || this.z >> 4 != z >> 4) {
            this.windChunk = null;
        }
        this.x = x;
        this.z = z;
    }

    public void wind(int y, int height) {
        this.expectPosSet();
        if (this.windChunk == null) {
            this.windChunk = this.wind.getOrCreate(this.x >> 4, this.z >> 4);
        }
        if (this.windChunk.add(this.x, y, this.z, height, this.gameTime)) {
            this.markModified();
        }
    }

    public void end() {
        this.expectPosSet();
        this.posSet = false;
    }

    private void expectPosSet() {
        if (!this.posSet) {
            throw new IllegalStateException("XZ position not set");
        }
    }

    private void markModified() {
        this.modifiedChunks.add(this.windChunk);
    }
}

