/*
 * Decompiled with CFR 0.152.
 */
package com.tictim.paraglider;

import com.google.common.collect.Lists;
import com.tictim.paraglider.item.ItemParaglider;
import com.tictim.paraglider.recipe.RecipeParagliderDye;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="paraglider")
public final class Contents {
    public static final Item paraglider = new ItemParaglider();
    private static final IRecipe recipeParaglider;
    private static final IRecipe recipeParagliderDye;
    private static IRecipe[] paragliderSkinRecipes;
    public static final Potion ascending;

    private Contents() {
    }

    private static IRecipe[] getParagliderSkinRecipes() {
        if (paragliderSkinRecipes == null) {
            Ingredient ing = Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack(paraglider, 1, 0), new ItemStack(paraglider, 1, 1)});
            for (IRecipe e2 : paragliderSkinRecipes = (IRecipe[])Lists.newArrayList((Object[])ItemParaglider.ParagliderSkin.values()).stream().map(e -> {
                ItemStack result = new ItemStack(paraglider);
                ItemParaglider.setType(result, e);
                return (IRecipe)new ShapelessOreRecipe(null, result, new Object[]{ing, e.getKeyOre()}).setRegistryName("paraglider_skin_" + e.name().toLowerCase());
            }).toArray(IRecipe[]::new)) {
                System.out.println(e2);
            }
        }
        return paragliderSkinRecipes;
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        event.getRegistry().register((IForgeRegistryEntry)paraglider);
    }

    @SubscribeEvent
    public static void registerRecipes(RegistryEvent.Register<IRecipe> event) {
        event.getRegistry().register((IForgeRegistryEntry)recipeParaglider);
        event.getRegistry().register((IForgeRegistryEntry)recipeParagliderDye);
        event.getRegistry().registerAll((IForgeRegistryEntry[])Contents.getParagliderSkinRecipes());
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void registerModels(ModelRegistryEvent event) {
        ModelLoader.setCustomModelResourceLocation((Item)paraglider, (int)1, (ModelResourceLocation)new ModelResourceLocation(new ResourceLocation(paraglider.getRegistryName() + "_off"), "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)paraglider, (int)0, (ModelResourceLocation)new ModelResourceLocation(paraglider.getRegistryName(), "inventory"));
    }

    @SubscribeEvent
    public static void registerPotions(RegistryEvent.Register<Potion> event) {
        event.getRegistry().register((IForgeRegistryEntry)ascending);
    }

    @SubscribeEvent
    public static void playerJoin(PlayerEvent.PlayerLoggedInEvent e) {
        if (e.player instanceof EntityPlayerMP) {
            ArrayList<IRecipe> list = new ArrayList<IRecipe>();
            if (Contents.hasID(recipeParaglider)) {
                list.add(recipeParaglider);
            }
            if (Contents.hasID(recipeParagliderDye)) {
                list.add(recipeParagliderDye);
            }
            for (IRecipe r : Contents.getParagliderSkinRecipes()) {
                if (!Contents.hasID(r) || !Contents.hasID(r)) continue;
                list.add(r);
            }
            if (!list.isEmpty()) {
                e.player.func_192021_a(list);
            }
        }
    }

    private static boolean hasID(@Nullable IRecipe recipe) {
        return CraftingManager.field_193380_a.func_148757_b((Object)recipe) != -1 || ((ForgeRegistry)ForgeRegistries.RECIPES).getID(recipe.getRegistryName()) != -1;
    }

    @SubscribeEvent
    public static void playerUsedItem(PlayerInteractEvent e) {
        if (e.isCancelable() && e.getHand() == EnumHand.OFF_HAND && e.getEntityPlayer().func_184614_ca().func_77973_b() == paraglider) {
            e.setCanceled(true);
        }
    }

    static {
        recipeParagliderDye = new RecipeParagliderDye();
        ascending = ((Potion)new Potion(false, 0xFFFFFF){

            public void func_76394_a(EntityLivingBase entity, int amp) {
                if (!entity.field_70122_E && entity.func_184614_ca().func_77973_b() == paraglider) {
                    entity.field_70181_x = Math.max(entity.field_70181_x + 0.05, 0.25);
                    entity.field_70143_R = 1.5f;
                }
            }

            public boolean func_76397_a(int duration, int amp) {
                return true;
            }

            public boolean shouldRender(PotionEffect effect) {
                return false;
            }

            public boolean shouldRenderInvText(PotionEffect effect) {
                return false;
            }

            public boolean shouldRenderHUD(PotionEffect effect) {
                return false;
            }
        }.setRegistryName("ascending")).func_76390_b("ascending");
        ItemStack result = new ItemStack(paraglider);
        result.func_77982_d(new NBTTagCompound());
        recipeParaglider = new ShapedOreRecipe(null, result, new Object[]{"121", "212", "1 1", Character.valueOf('1'), "stickWood", Character.valueOf('2'), Items.field_151116_aA});
        recipeParaglider.setRegistryName(new ResourceLocation("paraglider", "paraglider"));
    }
}

