/*
 * Decompiled with CFR 0.152.
 */
package com.tictim.paraglider.item;

import com.tictim.paraglider.Contents;
import com.tictim.paraglider.config.Configs;
import com.tictim.paraglider.entity.EntityWind;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemParaglider
extends Item {
    private static final BlockPos.MutableBlockPos mpos = new BlockPos.MutableBlockPos();

    public ItemParaglider() {
        ((Item)this.setRegistryName("paraglider")).func_77655_b("paraglider").func_77625_d(1);
        this.func_77637_a(CreativeTabs.field_78040_i).func_77627_a(true);
        this.func_185043_a(new ResourceLocation("skin"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World world, @Nullable EntityLivingBase entity) {
                return ItemParaglider.getType(stack).ordinal();
            }
        });
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean isSelected) {
        if (!world.field_72995_K) {
            int n;
            EntityPlayer player = entity instanceof EntityPlayer ? (EntityPlayer)entity : null;
            int n2 = n = player != null && ItemParaglider.isParagliderOn((EntityPlayer)entity, stack) ? 0 : 1;
            if (stack.func_77952_i() != n) {
                stack.func_77964_b(n);
            }
            if (Configs.ascendingWinds && player != null && !entity.field_70122_E && !player.func_70644_a(Contents.ascending) && ItemStack.func_77989_b((ItemStack)stack, (ItemStack)player.func_184614_ca())) {
                int _x = MathHelper.func_76143_f((double)player.field_70165_t) - 1;
                int _y = MathHelper.func_76143_f((double)player.field_70163_u);
                int _z = MathHelper.func_76143_f((double)player.field_70161_v) - 1;
                for (int i = 0; i < 2; ++i) {
                    int x = _x - i;
                    block1: for (int i2 = 0; i2 < 2; ++i2) {
                        int z = _z - i2;
                        for (int i3 = 0; i3 < 8; ++i3) {
                            int y = _y - i3;
                            mpos.func_181079_c(x, y, z);
                            IBlockState state = world.func_180495_p((BlockPos)mpos);
                            if (state.func_177230_c() == Blocks.field_150480_ab) {
                                world.func_72838_d((Entity)new EntityWind(world).setBlockPos(mpos.func_185334_h()));
                                continue block1;
                            }
                            if (state.func_185913_b()) continue block1;
                        }
                    }
                }
            }
        } else {
            ItemParaglider.setRenderKey(stack, false);
        }
        if (entity instanceof EntityPlayer && ItemParaglider.isParagliderOnClient((EntityPlayer)entity, stack)) {
            entity.field_70143_R = 1.5f;
            if (entity.field_70181_x < -0.05) {
                entity.field_70181_x = -0.05;
            }
        }
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            ItemStack stack = new ItemStack((Item)this);
            stack.func_77982_d(new NBTTagCompound());
            items.add((Object)stack);
        }
    }

    public static boolean isParagliderOn(EntityPlayer player, ItemStack stack) {
        return ItemStack.func_77989_b((ItemStack)stack, (ItemStack)player.func_184614_ca()) && ItemParaglider.isParagliderOn(player);
    }

    public static boolean isParagliderOn(EntityPlayer player) {
        return !player.field_70122_E && player.field_70143_R >= 1.45f;
    }

    public static boolean isParagliderOnClient(EntityPlayer player, ItemStack stack) {
        return ItemStack.func_77989_b((ItemStack)stack, (ItemStack)player.func_184614_ca()) && stack.func_77952_i() == 0;
    }

    public static void setRenderKey(ItemStack stack, boolean remove) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (remove) {
            if (nbt != null && nbt.func_74764_b("renderKey")) {
                nbt.func_82580_o("renderKey");
            }
        } else {
            if (nbt == null) {
                nbt = new NBTTagCompound();
                stack.func_77982_d(nbt);
            }
            if (!nbt.func_74764_b("renderKey")) {
                nbt.func_74772_a("renderKey", field_77697_d.nextLong());
            }
        }
    }

    public static void setColor(ItemStack stack, int rgb) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt == null) {
            nbt = new NBTTagCompound();
            stack.func_77982_d(nbt);
        }
        nbt.func_74768_a("color", rgb);
    }

    public static void setType(ItemStack stack, ParagliderSkin skin) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt == null) {
            nbt = new NBTTagCompound();
            stack.func_77982_d(nbt);
        }
        nbt.func_74774_a("skin", (byte)skin.ordinal());
    }

    public static int getColor(ItemStack stack, boolean defaultColor) {
        if (!ItemParaglider.hasColor(stack)) {
            return defaultColor ? ItemParaglider.getType(stack).getDefaultColor() : 0xFFFFFF;
        }
        return stack.func_77978_p().func_74762_e("color");
    }

    public static boolean hasColor(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_150297_b("color", 3);
    }

    public static ParagliderSkin getType(ItemStack stack) {
        NBTTagCompound nbt = stack.func_77978_p();
        return nbt == null ? ParagliderSkin.BOTW_PARAGLIDER : ParagliderSkin.values()[nbt.func_74771_c("skin") % ParagliderSkin.values().length];
    }

    public static enum ParagliderSkin {
        BOTW_PARAGLIDER,
        TWW_DEKU_LEAF;


        @Nullable
        public String getKeyOre() {
            switch (this) {
                case BOTW_PARAGLIDER: {
                    return "stickWood";
                }
                case TWW_DEKU_LEAF: {
                    return "treeLeaves";
                }
            }
            System.err.println("Invalid access in ParagliderSkin#getKeyOre()");
            return "";
        }

        public int getDefaultColor() {
            switch (this) {
                case BOTW_PARAGLIDER: {
                    return 10901845;
                }
                case TWW_DEKU_LEAF: {
                    return 4175167;
                }
            }
            System.err.println("Invalid access in ParagliderSkin#getDefaultColor()");
            return -1;
        }
    }
}

