/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider;

import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.IDyeableArmorItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.event.RenderSpecificHandEvent;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import tictim.paraglider.Contents;
import tictim.paraglider.ParagliderItem;
import tictim.paraglider.WindEntity;

@Mod(value="paraglider")
@Mod.EventBusSubscriber(modid="paraglider")
public class Paraglider {
    public static final String MODID = "paraglider";
    private static ForgeConfigSpec.BooleanValue ascendingWinds;

    public static boolean ascendingWinds() {
        return (Boolean)ascendingWinds.get();
    }

    public Paraglider() {
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> {
            IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
            eventBus.addListener(this::clientSetup);
            eventBus.addListener(this::itemColorSetup);
        });
        ForgeConfigSpec.Builder b = new ForgeConfigSpec.Builder();
        ascendingWinds = b.comment("If enabled, fires will float you upward.").define("ascendingWinds", false);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, b.build(), "paraglider.toml");
    }

    @OnlyIn(value=Dist.CLIENT)
    private void clientSetup(FMLClientSetupEvent event) {
        RenderingRegistry.registerEntityRenderingHandler(WindEntity.class, m -> new EntityRenderer<WindEntity>(m){

            @Nullable
            protected ResourceLocation getEntityTexture(WindEntity entity) {
                return null;
            }
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    private void itemColorSetup(ColorHandlerEvent.Item event) {
        event.getItemColors().func_199877_a((stack, tint) -> tint > 0 ? -1 : ((IDyeableArmorItem)stack.func_77973_b()).func_200886_f(stack), new IItemProvider[]{Contents.PARAGLIDER, Contents.DEKU_LEAF});
    }

    @SubscribeEvent
    public static void onPlayerInteract(PlayerInteractEvent event) {
        ItemStack s;
        if (event.isCancelable() && event.getHand() == Hand.OFF_HAND && (s = event.getPlayer().func_184614_ca()).func_77973_b() instanceof ParagliderItem && ParagliderItem.hasParaglidingFlag(s)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onPlayerUseItem(LivingEntityUseItemEvent.Tick event) {
        ItemStack main;
        if (event.getEntityLiving().func_184600_cs() == Hand.OFF_HAND && event.getEntityLiving() instanceof PlayerEntity && (main = event.getEntityLiving().func_184614_ca()).func_77973_b() instanceof ParagliderItem && ParagliderItem.hasParaglidingFlag(main)) {
            event.getEntityLiving().func_184602_cy();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void renderOffHand(RenderSpecificHandEvent event) {
        ItemStack s;
        if (event.getHand() == Hand.MAIN_HAND && (s = event.getItemStack()).func_77973_b() instanceof ParagliderItem && ParagliderItem.hasParaglidingFlag(s)) {
            Minecraft.func_71410_x().field_71460_t.field_78516_c.func_187460_a(Hand.OFF_HAND);
        }
    }
}

