/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider;

import it.unimi.dsi.fastutil.longs.LongArraySet;
import it.unimi.dsi.fastutil.longs.LongSets;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.IDyeableArmorItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import tictim.paraglider.Contents;
import tictim.paraglider.Paraglider;
import tictim.paraglider.WindEntity;

public class ParagliderItem
extends Item
implements IDyeableArmorItem {
    @OnlyIn(value=Dist.CLIENT)
    private static ResourceLocation PARAGLIDING_PROPERTY_KEY;
    private final int defaultColor;
    private static final int XZ_RAD = 9;
    private static final int XZ_RAD_HALF = 4;
    private static final int GROUND_Y_MIN = -2;
    private static final int GROUND_Y_MAX = 4;
    private static final int PARAGLIDING_Y_MIN = -10;
    private static final int PARAGLIDING_Y_MAX = 0;

    @OnlyIn(value=Dist.CLIENT)
    public static void setParagliderRotationAngles(BipedModel<?> biped, PlayerEntity player) {
        ItemStack stack = player.func_184614_ca();
        if (stack.func_77973_b() instanceof ParagliderItem && ParagliderItem.isParagliding(stack, (LivingEntity)player)) {
            biped.field_178724_i.field_78795_f = biped.field_178724_i.field_78795_f / 20.0f + 16.0f;
            biped.field_178723_h.field_78795_f = biped.field_178723_h.field_78795_f / 20.0f + 16.0f;
            biped.field_178722_k.field_78795_f /= 20.0f;
            biped.field_178721_j.field_78795_f /= 20.0f;
        }
    }

    public ParagliderItem(int defaultColor) {
        super(new Item.Properties().func_200917_a(1).func_200916_a(ItemGroup.field_78040_i));
        this.defaultColor = defaultColor;
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> {
            if (PARAGLIDING_PROPERTY_KEY == null) {
                PARAGLIDING_PROPERTY_KEY = new ResourceLocation("paragliding");
            }
            this.func_185043_a(PARAGLIDING_PROPERTY_KEY, (stack, world, entity) -> ParagliderItem.isParagliding(stack, entity) ? 1.0f : 0.0f);
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    private static boolean isParagliding(ItemStack stack, @Nullable LivingEntity entity) {
        return entity instanceof PlayerEntity && ParagliderItem.hasParaglidingFlag(stack);
    }

    public static boolean hasParaglidingFlag(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_74767_n("paragliding");
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        if (isSelected) {
            if (!(entity instanceof PlayerEntity)) {
                return;
            }
            PlayerEntity player = (PlayerEntity)entity;
            if (!world.field_72995_K) {
                boolean isAscending;
                boolean isParagliding;
                if (!entity.field_70122_E) {
                    if (player.func_70644_a(Contents.ASCENDING)) {
                        isParagliding = true;
                        isAscending = true;
                    } else {
                        isParagliding = player.field_70143_R >= 1.45f;
                        isAscending = false;
                    }
                } else {
                    isParagliding = false;
                    isAscending = false;
                }
                if (isParagliding) {
                    stack.func_196082_o().func_74757_a("paragliding", true);
                    entity.field_70143_R = 1.5f;
                    Vec3d m = entity.func_213322_ci();
                    if (isAscending) {
                        entity.func_213317_d(new Vec3d(m.field_72450_a, Math.max(m.field_72448_b + 0.05, 0.25), m.field_72449_c));
                    } else if (m.field_72448_b < -0.05) {
                        entity.func_213317_d(new Vec3d(m.field_72450_a, -0.05, m.field_72449_c));
                    }
                } else if (stack.func_77942_o()) {
                    stack.func_77978_p().func_82580_o("paragliding");
                }
                if (Paraglider.ascendingWinds() && world.func_82737_E() % 4L == 0L) {
                    ParagliderItem.generateWind(world, player.func_180425_c(), isParagliding);
                }
            } else if (ParagliderItem.hasParaglidingFlag(stack)) {
                entity.field_70143_R = 1.5f;
                Vec3d m = entity.func_213322_ci();
                if (player.func_70644_a(Contents.ASCENDING)) {
                    entity.func_213317_d(new Vec3d(m.field_72450_a, Math.max(m.field_72448_b + 0.05, 0.25), m.field_72449_c));
                } else if (m.field_72448_b < -0.05) {
                    entity.func_213317_d(new Vec3d(m.field_72450_a, -0.05, m.field_72449_c));
                }
            }
        } else if (!world.field_72995_K && ParagliderItem.hasParaglidingFlag(stack)) {
            stack.func_77978_p().func_82580_o("paragliding");
        }
    }

    public int func_200886_f(ItemStack stack) {
        CompoundNBT compoundnbt = stack.func_179543_a("display");
        return compoundnbt != null && compoundnbt.func_150297_b("color", 99) ? compoundnbt.func_74762_e("color") : this.defaultColor;
    }

    private static void generateWind(World world, BlockPos origin, boolean isParagliding) {
        LongSets.EmptySet ls;
        int yMax = isParagliding ? 0 : 4;
        int yMin = isParagliding ? -10 : -2;
        List entities = world.func_217357_a(WindEntity.class, new AxisAlignedBB((double)(origin.func_177958_n() - 4), (double)(origin.func_177956_o() + yMin), (double)(origin.func_177952_p() - 4), (double)(origin.func_177958_n() + 4 + 1), (double)(origin.func_177956_o() + yMax + 1), (double)(origin.func_177952_p() + 4 + 1)));
        if (!entities.isEmpty()) {
            ls = new LongArraySet();
            for (WindEntity e : entities) {
                BlockPos p = e.getBlockPos();
                if (p == null) continue;
                ls.add((long)p.func_177958_n() << 32 | (long)p.func_177952_p());
            }
        } else {
            ls = LongSets.EMPTY_SET;
        }
        BlockPos.MutableBlockPos mpos = new BlockPos.MutableBlockPos();
        int _x = origin.func_177958_n() + 4;
        for (int x = origin.func_177958_n() - 4; x <= _x; ++x) {
            int _z = origin.func_177952_p() + 4;
            block2: for (int z = origin.func_177952_p() - 4; z <= _z; ++z) {
                if (ls.contains((long)x << 32 | (long)z)) continue;
                int _y = origin.func_177956_o() + yMin;
                for (int y = origin.func_177956_o() + yMax; y >= _y; --y) {
                    mpos.func_181079_c(x, y, z);
                    if (WindEntity.canBePlaced(world, (BlockPos)mpos)) {
                        world.func_217376_c((Entity)new WindEntity(world).setBlockPos(mpos.func_185334_h()));
                        continue block2;
                    }
                    if (!world.func_180495_p((BlockPos)mpos).isAir((IBlockReader)world, (BlockPos)mpos)) continue block2;
                }
            }
        }
    }
}

