/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider;

import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.IPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;
import tictim.paraglider.Contents;
import tictim.paraglider.ParagliderItem;

public class WindEntity
extends Entity {
    private BlockPos blockPos = null;
    private int lastUsedTickCount = 0;

    public WindEntity(World world) {
        this(Contents.WIND, world);
    }

    public WindEntity(EntityType<?> type, World world) {
        super(type, world);
        this.field_70145_X = true;
    }

    protected void func_70088_a() {
    }

    public WindEntity setBlockPos(BlockPos pos) {
        this.func_70107_b((double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
        this.blockPos = pos;
        return this;
    }

    @Nullable
    public BlockPos getBlockPos() {
        return this.blockPos;
    }

    public PushReaction func_184192_z() {
        return PushReaction.IGNORE;
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            if (this.field_70146_Z.nextInt(6) == 0) {
                this.field_70170_p.func_195589_b((IParticleData)ParticleTypes.field_197629_v, this.field_70165_t + this.field_70146_Z.nextDouble() - 0.5, this.field_70163_u + 0.5, this.field_70161_v + this.field_70146_Z.nextDouble() - 0.5, 0.0, 1.0, 0.0);
            }
        } else if (this.field_70173_aa - this.lastUsedTickCount >= 200 || this.blockPos != null && !WindEntity.canBePlaced(this.field_70170_p, this.blockPos)) {
            this.func_70106_y();
        } else if (this.field_70170_p.func_82737_E() % 4L == 0L) {
            for (PlayerEntity p : this.field_70170_p.func_217357_a(PlayerEntity.class, this.func_174813_aQ())) {
                if (!p.func_70089_S() || p.field_70122_E || !(p.func_184614_ca().func_77973_b() instanceof ParagliderItem)) continue;
                p.func_195064_c(new EffectInstance(Contents.ASCENDING, 4, 0, false, false));
                if (this.blockPos == null) continue;
                this.lastUsedTickCount = this.field_70173_aa;
            }
        }
    }

    protected void func_70037_a(CompoundNBT nbt) {
        if (nbt.func_150297_b("pos", 10)) {
            this.blockPos = NBTUtil.func_186861_c((CompoundNBT)nbt.func_74775_l("pos"));
            this.lastUsedTickCount = nbt.func_74762_e("lastUsed");
        }
    }

    protected void func_213281_b(CompoundNBT nbt) {
        if (this.blockPos != null) {
            nbt.func_218657_a("pos", (INBT)NBTUtil.func_186859_a((BlockPos)this.blockPos));
            nbt.func_74768_a("lastUsed", this.lastUsedTickCount);
        }
    }

    public static boolean canBePlaced(World world, BlockPos pos) {
        BlockState state = world.func_180495_p(pos);
        return state.func_177230_c() == Blocks.field_150480_ab || state.func_196959_b((IProperty)BlockStateProperties.field_208190_q) && (Boolean)state.func_177229_b((IProperty)BlockStateProperties.field_208190_q) != false;
    }
}

