/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.ModConfig;

public final class ModCfg {
    private static ForgeConfigSpec.BooleanValue ascendingWinds;
    private static ForgeConfigSpec.BooleanValue paraglidingConsumesStamina;
    private static ForgeConfigSpec.BooleanValue runningConsumesStamina;
    private static ForgeConfigSpec.BooleanValue debugPlayerMovement;
    private static ForgeConfigSpec.BooleanValue traceMovementPacket;
    private static ForgeConfigSpec.BooleanValue traceParaglidingPacket;
    private static ForgeConfigSpec.BooleanValue traceVesselPacket;
    private static ForgeConfigSpec.BooleanValue forceFlightDisabled;

    private ModCfg() {
    }

    public static boolean ascendingWinds() {
        return (Boolean)ascendingWinds.get();
    }

    public static boolean paraglidingConsumesStamina() {
        return (Boolean)paraglidingConsumesStamina.get();
    }

    public static boolean runningConsumesStamina() {
        return (Boolean)runningConsumesStamina.get();
    }

    public static boolean debugPlayerMovement() {
        return (Boolean)debugPlayerMovement.get();
    }

    public static boolean traceMovementPacket() {
        return (Boolean)traceMovementPacket.get();
    }

    public static boolean traceParaglidingPacket() {
        return (Boolean)traceParaglidingPacket.get();
    }

    public static boolean traceVesselPacket() {
        return (Boolean)traceVesselPacket.get();
    }

    public static boolean forceFlightDisabled() {
        return (Boolean)forceFlightDisabled.get();
    }

    public static void init() {
        ForgeConfigSpec.Builder server = new ForgeConfigSpec.Builder();
        ascendingWinds = server.comment("Fire will float you upward.").define("ascendingWinds", true);
        paraglidingConsumesStamina = server.comment("Paragliding will consume stamina.").define("paraglidingConsumesStamina", true);
        runningConsumesStamina = server.comment("Actions other than paragliding will consume stamina.").define("runningAndSwimmingConsumesStamina", false);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, server.build());
        ForgeConfigSpec.Builder common = new ForgeConfigSpec.Builder();
        common.push("debug");
        debugPlayerMovement = common.define("debugPlayerMovement", false);
        traceMovementPacket = common.define("traceMovementPacket", false);
        traceParaglidingPacket = common.define("traceParaglidingPacket", false);
        traceVesselPacket = common.define("traceVesselPacket", false);
        common.pop();
        forceFlightDisabled = common.worldRestart().comment("Forces the server to not kick the shit out of 'cheaters' who also happened to be using paraglider.\nFeel free to disable it if you hate 'cheaters'. Or paraglider. If disabled, 'allow-flight' inside server.properties will be used.").define("forceFlightDisabled", true);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, common.build());
    }
}

