/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.capabilities;

import java.util.UUID;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fml.network.PacketDistributor;
import tictim.paraglider.ModCfg;
import tictim.paraglider.ParagliderMod;
import tictim.paraglider.capabilities.Paraglider;
import tictim.paraglider.capabilities.PlayerMovement;
import tictim.paraglider.capabilities.PlayerState;
import tictim.paraglider.contents.Contents;
import tictim.paraglider.contents.WindEntity;
import tictim.paraglider.network.ModNet;
import tictim.paraglider.network.SyncMovementMsg;
import tictim.paraglider.network.SyncParaglidingMsg;
import tictim.paraglider.network.SyncVesselMsg;
import tictim.paraglider.utils.WindUpdateHelper;

public final class ServerPlayerMovement
extends PlayerMovement
implements INBTSerializable<CompoundNBT> {
    public static final int PANIC_INITIAL_DELAY = 10;
    public static final int PANIC_DELAY = 30;
    public static final int PANIC_DURATION = 15;
    public static final UUID HEART_CONTAINER_UUID = UUID.fromString("a0f1c25b-c4f9-4413-9619-7841cd7982a3");
    private final ServerPlayerEntity serverPlayer;
    private PlayerState prevState = PlayerState.IDLE;
    private boolean healthNeedsUpdate;
    private boolean prevIsParagliding;
    public boolean vesselNeedsSync;
    public boolean movementNeedsSync;
    public boolean paraglidingNeedsSync;
    private int panicParaglidingDelay = 10;
    private int panicParaglidingDuration = 0;

    public ServerPlayerMovement(ServerPlayerEntity player) {
        super((PlayerEntity)player);
        this.serverPlayer = player;
    }

    @Override
    public void setStaminaVessels(int staminaVessels) {
        int cache = this.getStaminaVessels();
        super.setStaminaVessels(staminaVessels);
        if (cache != staminaVessels) {
            this.vesselNeedsSync = true;
        }
    }

    @Override
    public void setHeartContainers(int heartContainers) {
        int cache = this.getHeartContainers();
        super.setHeartContainers(heartContainers);
        if (cache != heartContainers) {
            this.vesselNeedsSync = true;
        }
        this.healthNeedsUpdate = true;
    }

    @Override
    public boolean isParagliding() {
        return this.prevIsParagliding;
    }

    @Override
    public void update() {
        Object msg;
        boolean isParagliding;
        if (this.healthNeedsUpdate) {
            IAttributeInstance attrib = this.player.func_110148_a(SharedMonsterAttributes.field_111267_a);
            if (attrib != null) {
                attrib.func_188479_b(HEART_CONTAINER_UUID);
                if (this.getHeartContainers() > 0) {
                    attrib.func_111121_a(new AttributeModifier(HEART_CONTAINER_UUID, () -> "Heart Containers", (double)(this.getHeartContainers() * 2), AttributeModifier.Operation.ADDITION));
                }
                double mhp = attrib.func_111126_e();
                if ((double)this.player.func_110143_aJ() > mhp) {
                    this.player.func_70606_j((float)mhp);
                }
            }
            this.healthNeedsUpdate = false;
        }
        boolean isHoldingParaglider = Paraglider.isParaglider(this.player.func_184614_ca());
        if (ModCfg.ascendingWinds() && isHoldingParaglider && this.player.field_70170_p.func_82737_E() % 4L == 0L) {
            WindUpdateHelper.generateWind(this.player);
        }
        this.setState(this.calculatePlayerState(isHoldingParaglider));
        if (this.prevState != this.getState()) {
            this.movementNeedsSync = true;
        }
        this.updateStamina();
        boolean bl = isParagliding = this.getState().isParagliding() && (this.canUseParaglider() || this.tryPanicParagliding());
        if (this.prevIsParagliding != isParagliding) {
            this.paraglidingNeedsSync = true;
            this.prevIsParagliding = isParagliding;
        }
        if (!this.player.field_71075_bZ.field_75098_d && this.isDepleted()) {
            this.player.func_195064_c(new EffectInstance((Effect)Contents.EXHAUSTED.get(), 2, 0, false, false, false));
        }
        this.applyMovement();
        if (this.movementNeedsSync) {
            msg = new SyncMovementMsg(this);
            if (ModCfg.traceMovementPacket()) {
                ParagliderMod.LOGGER.debug("Sending packet {} to player {}", msg, (Object)this.player);
            }
            ModNet.NET.send(PacketDistributor.PLAYER.with(() -> this.serverPlayer), msg);
            this.paraglidingNeedsSync = true;
            this.movementNeedsSync = false;
        }
        if (this.paraglidingNeedsSync) {
            SyncParaglidingMsg msg2 = new SyncParaglidingMsg(this);
            if (ModCfg.traceParaglidingPacket()) {
                ParagliderMod.LOGGER.debug("Sending packet {} to player tracking {}", (Object)msg2, (Object)this.player);
            }
            ModNet.NET.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> this.serverPlayer), (Object)msg2);
            this.paraglidingNeedsSync = false;
        }
        if (this.vesselNeedsSync) {
            msg = new SyncVesselMsg(this.getStamina(), this.getHeartContainers(), this.getStaminaVessels());
            if (ModCfg.traceVesselPacket()) {
                ParagliderMod.LOGGER.debug("Sending packet {} to player {}", msg, (Object)this.player);
            }
            ModNet.NET.send(PacketDistributor.PLAYER.with(() -> this.serverPlayer), msg);
            this.vesselNeedsSync = false;
        }
        this.prevState = this.getState();
    }

    private PlayerState calculatePlayerState(boolean isHoldingParaglider) {
        if (this.player.field_71075_bZ.field_75100_b) {
            return PlayerState.IDLE;
        }
        if (!this.player.field_70122_E && isHoldingParaglider && !this.player.func_184613_cA()) {
            if (ModCfg.ascendingWinds() && this.isInsideWind()) {
                return PlayerState.ASCENDING;
            }
            if (this.prevState.isParagliding() || this.player.field_70143_R >= 1.45f) {
                return PlayerState.PARAGLIDING;
            }
        }
        if (this.player.func_203007_ba()) {
            return PlayerState.SWIMMING;
        }
        if (this.player.func_70090_H()) {
            return this.player.func_70644_a(Effects.field_76427_o) ? PlayerState.BREATHING_UNDERWATER : PlayerState.UNDERWATER;
        }
        if (this.player.func_70051_ag()) {
            return PlayerState.RUNNING;
        }
        if (this.player.field_70122_E) {
            return PlayerState.IDLE;
        }
        return PlayerState.MIDAIR;
    }

    @Override
    protected void updateStamina() {
        boolean wasDepleted = this.isDepleted();
        super.updateStamina();
        if (this.isDepleted() != wasDepleted) {
            this.movementNeedsSync = true;
        }
        if (this.isDepleted()) {
            if (this.getStamina() >= this.getMaxStamina()) {
                this.setDepleted(false);
                this.movementNeedsSync = true;
            }
        } else if (this.getStamina() <= 0) {
            this.setDepleted(true);
            this.panicParaglidingDelay = 10;
            this.movementNeedsSync = true;
        }
    }

    private boolean tryPanicParagliding() {
        if (this.panicParaglidingDuration > 0) {
            --this.panicParaglidingDuration;
            return true;
        }
        if (this.panicParaglidingDelay > 0) {
            --this.panicParaglidingDelay;
            return false;
        }
        this.panicParaglidingDelay = 30;
        this.panicParaglidingDuration = 15;
        return true;
    }

    private boolean isInsideWind() {
        return !this.player.field_70170_p.func_175647_a(WindEntity.class, this.player.func_174813_aQ(), null).isEmpty();
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74768_a("stamina", this.getStamina());
        nbt.func_74757_a("depleted", this.isDepleted());
        nbt.func_74768_a("recoveryDelay", this.getRecoveryDelay());
        nbt.func_74768_a("panicParaglidingDelay", this.panicParaglidingDelay);
        nbt.func_74768_a("staminaVessels", this.getStaminaVessels());
        nbt.func_74768_a("heartContainers", this.getHeartContainers());
        return nbt;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        this.setStamina(nbt.func_74762_e("stamina"));
        this.setDepleted(nbt.func_74767_n("depleted"));
        this.setRecoveryDelay(nbt.func_74762_e("recoveryDelay"));
        this.panicParaglidingDelay = nbt.func_74762_e("panicParaglidingDelay");
        this.setStaminaVessels(nbt.func_74762_e("staminaVessels"));
        this.setHeartContainers(nbt.func_74762_e("heartContainers"));
    }
}

