/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.client;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldVertexBufferUploader;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec2f;

public final class StaminaWheelRenderer {
    private final Map<WheelType, Wheel> wheel = new EnumMap<WheelType, Wheel>(WheelType.class);

    @Nullable
    public Wheel getWheel(WheelType type) {
        return this.wheel.get((Object)type);
    }

    public void addWheel(WheelType wheelType, double start, double end, Color color) {
        if ((start = Math.max(0.0, start)) >= (end = Math.min(1.0, end))) {
            return;
        }
        Wheel wheel = this.wheel.get((Object)wheelType);
        if (wheel != null) {
            this.wheel.put(wheelType, wheel.insert(new Wheel(start, end, color)));
        } else {
            this.wheel.put(wheelType, new Wheel(start, end, color));
        }
    }

    public void render(double x, double y, double size, boolean debug) {
        RenderSystem.disableDepthTest();
        BufferBuilder b = Tessellator.func_178181_a().func_178180_c();
        Minecraft mc = Minecraft.func_71410_x();
        if (debug) {
            int lines = 0;
            FontRenderer font = mc.field_71466_p;
            for (WheelType t : WheelType.values()) {
                Wheel wheel = this.getWheel(t);
                if (wheel == null) continue;
                font.func_175063_a((Object)((Object)t) + ":", 20.0f, (float)(10 + 10 * lines++), -1);
                for (String s : font.func_78271_c(wheel.toString(), mc.func_228018_at_().func_198107_o() - 30)) {
                    font.func_175063_a(s, 30.0f, (float)(10 + 10 * lines++), -1);
                }
            }
        }
        RenderSystem.pushMatrix();
        RenderSystem.translated((double)x, (double)y, (double)0.0);
        for (WheelType t : WheelType.values()) {
            Wheel wheel = this.getWheel(t);
            if (wheel == null) continue;
            mc.func_110434_K().func_110577_a(t.texture);
            RenderSystem.enableAlphaTest();
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            wheel.draw(b, size, debug);
        }
        RenderSystem.popMatrix();
        RenderSystem.enableDepthTest();
        this.wheel.clear();
    }

    public static enum WheelType {
        FIRST(new ResourceLocation("paraglider", "textures/stamina/first.png"), 0, 1000),
        SECOND(new ResourceLocation("paraglider", "textures/stamina/second.png"), 1000, 2000),
        THIRD(new ResourceLocation("paraglider", "textures/stamina/third.png"), 2000, 3000);

        public final ResourceLocation texture;
        public final int start;
        public final int end;

        private WheelType(ResourceLocation texture, int start, int end) {
            this.texture = Objects.requireNonNull(texture);
            this.start = start;
            this.end = end;
        }

        public double getProportion(int value) {
            return this.start >= value ? 0.0 : (this.end <= value ? 1.0 : (double)(value - this.start) / (double)(this.end - this.start));
        }
    }

    public static final class Color {
        public float red;
        public float green;
        public float blue;
        public float alpha;

        public static Color of(int red, int green, int blue) {
            return new Color((float)MathHelper.func_76125_a((int)red, (int)0, (int)255) / 255.0f, (float)MathHelper.func_76125_a((int)green, (int)0, (int)255) / 255.0f, (float)MathHelper.func_76125_a((int)blue, (int)0, (int)255) / 255.0f);
        }

        public static Color of(int red, int green, int blue, int alpha) {
            return new Color((float)MathHelper.func_76125_a((int)red, (int)0, (int)255) / 255.0f, (float)MathHelper.func_76125_a((int)green, (int)0, (int)255) / 255.0f, (float)MathHelper.func_76125_a((int)blue, (int)0, (int)255) / 255.0f, (float)MathHelper.func_76125_a((int)alpha, (int)0, (int)255) / 255.0f);
        }

        public Color(float red, float green, float blue) {
            this(red, green, blue, 1.0f);
        }

        public Color(float red, float green, float blue, float alpha) {
            this.red = red;
            this.green = green;
            this.blue = blue;
            this.alpha = alpha;
        }

        public void set(Color other) {
            this.red = other.red;
            this.green = other.green;
            this.blue = other.blue;
            this.alpha = other.alpha;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Color color = (Color)o;
            return Double.compare(color.red, this.red) == 0 && Double.compare(color.green, this.green) == 0 && Double.compare(color.blue, this.blue) == 0 && Double.compare(color.alpha, this.alpha) == 0;
        }

        public int hashCode() {
            return Objects.hash(Float.valueOf(this.red), Float.valueOf(this.green), Float.valueOf(this.blue), Float.valueOf(this.alpha));
        }

        public String toString() {
            return String.format("[R: %f, G: %f, B: %f, A: %f]", Float.valueOf(this.red), Float.valueOf(this.green), Float.valueOf(this.blue), Float.valueOf(this.alpha));
        }
    }

    public static final class Wheel {
        private double start;
        private double end;
        private final Color color;
        @Nullable
        private Wheel next;
        private static final double[] renderPoints = new double[]{0.0, 0.125, 0.375, 0.625, 0.875, 1.0};

        private Wheel(double start, double end, Color color) {
            this.start = start;
            this.end = end;
            this.color = Objects.requireNonNull(color);
        }

        public Wheel insert(Wheel wheel) {
            return this.insert(wheel, true);
        }

        private Wheel insert(Wheel wheel, boolean overwrite) {
            if (wheel.start <= this.start) {
                if (wheel.end >= this.end) {
                    return this.next != null ? wheel.insert(this.next, false) : wheel;
                }
                this.start = wheel.end;
                wheel.next = this;
                return wheel;
            }
            if (overwrite && wheel.start < this.end) {
                this.end = wheel.start;
            }
            this.next = this.next != null ? this.next.insert(wheel, overwrite) : wheel;
            return this;
        }

        public void draw(BufferBuilder b, double size, boolean debug) {
            ArrayList<Vec2f> debugVertices = debug ? new ArrayList<Vec2f>() : null;
            b.func_181668_a(6, DefaultVertexFormats.field_227851_o_);
            b.func_225582_a_(0.0, 0.0, 0.0).func_227885_a_(this.color.red, this.color.green, this.color.blue, this.color.alpha).func_225583_a_(0.5f, 0.5f).func_181675_d();
            this.drawInternal(b, size, debugVertices, false);
            b.func_178977_d();
            WorldVertexBufferUploader.func_181679_a((BufferBuilder)b);
            if (debugVertices != null) {
                FontRenderer font = Minecraft.func_71410_x().field_71466_p;
                for (Vec2f vec : debugVertices) {
                    float f;
                    String s = vec.field_189982_i + " " + vec.field_189983_j;
                    float f2 = vec.field_189982_i > 0.0f ? vec.field_189982_i * (float)size + 2.0f : vec.field_189982_i * (float)size - 2.0f - (float)font.func_78256_a(s);
                    if (vec.field_189983_j > 0.0f) {
                        float f3 = vec.field_189983_j * (float)(-size) - 2.0f;
                        font.getClass();
                        f = f3 - 9.0f;
                    } else {
                        f = vec.field_189983_j * (float)(-size) + 2.0f;
                    }
                    font.func_175063_a(s, f2, f, -16711936);
                }
            }
        }

        private void drawInternal(BufferBuilder b, double size, @Nullable List<Vec2f> debugVertices, boolean skipFirst) {
            double currentStart;
            for (int i = 0; i < renderPoints.length - 1 && !((currentStart = renderPoints[i]) >= this.end); ++i) {
                double currentEnd = renderPoints[i + 1];
                if (currentEnd <= this.start) continue;
                if (currentStart <= this.start && !skipFirst) {
                    this.vert(b, this.start, size, debugVertices);
                }
                this.vert(b, Math.min(currentEnd, this.end), size, debugVertices);
            }
            if (this.next != null) {
                this.next.drawInternal(b, size, debugVertices, this.end == this.next.start);
            }
        }

        private void vert(BufferBuilder b, double point, double size, @Nullable List<Vec2f> debugVertices) {
            double y;
            double x;
            if (point == 0.0 || point == 1.0) {
                x = 0.0;
                y = 1.0;
            } else if (point == 0.125) {
                x = -1.0;
                y = 1.0;
            } else if (point == 0.375) {
                x = -1.0;
                y = -1.0;
            } else if (point == 0.625) {
                x = 1.0;
                y = -1.0;
            } else if (point == 0.875) {
                x = 1.0;
                y = 1.0;
            } else if (point < 0.125 || point > 0.875) {
                x = -Math.tan(point * (Math.PI * 2));
                y = 1.0;
            } else if (point < 0.375) {
                x = -1.0;
                y = 1.0 / Math.tan(point * (Math.PI * 2));
            } else if (point < 0.625) {
                x = Math.tan(point * (Math.PI * 2));
                y = -1.0;
            } else {
                x = 1.0;
                y = -1.0 / Math.tan(point * (Math.PI * 2));
            }
            b.func_225582_a_(x * size, y * -size, 0.0).func_227885_a_(this.color.red, this.color.green, this.color.blue, this.color.alpha).func_225583_a_((float)(x / 2.0 + 0.5), (float)(y / 2.0 + 0.5)).func_181675_d();
            if (debugVertices != null) {
                debugVertices.add(new Vec2f((float)x, (float)y));
            }
        }

        public String toString() {
            return this.next != null ? String.format("[%f ~ %f](#%s) -> \n%s", this.start, this.end, this.color, this.next) : String.format("[%f ~ %f](#%s)", this.start, this.end, this.color);
        }
    }
}

