/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.contents;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import tictim.paraglider.capabilities.PlayerMovement;
import tictim.paraglider.contents.Contents;

public class HornedStatueBlock
extends Block {
    private static final VoxelShape SHAPE = Block.func_208617_a((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)14.0, (double)13.0);

    public HornedStatueBlock(Block.Properties properties) {
        super(properties);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{BlockStateProperties.field_208157_J});
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((IProperty)BlockStateProperties.field_208157_J, (Comparable)context.func_195992_f().func_176734_d());
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        PlayerMovement h;
        if (!world.field_72995_K && (h = (PlayerMovement)player.getCapability(PlayerMovement.CAP).orElse(null)) != null) {
            int heartContainers;
            int staminaVessels = h.getStaminaVessels();
            if (staminaVessels > 0) {
                h.setStaminaVessels(0);
                h.setStamina(Math.min(h.getStamina(), 1000));
                for (int i = 0; i < staminaVessels; ++i) {
                    InventoryHelper.func_180173_a((World)world, (double)player.func_226277_ct_(), (double)player.func_226278_cu_(), (double)player.func_226281_cx_(), (ItemStack)new ItemStack((IItemProvider)Contents.STAMINA_VESSEL.get()));
                }
            }
            if ((heartContainers = h.getHeartContainers()) > 0) {
                h.setHeartContainers(0);
                for (int i = 0; i < heartContainers; ++i) {
                    InventoryHelper.func_180173_a((World)world, (double)player.func_226277_ct_(), (double)player.func_226278_cu_(), (double)player.func_226281_cx_(), (ItemStack)new ItemStack((IItemProvider)Contents.HEART_CONTAINER.get()));
                }
            }
        }
        return ActionResultType.SUCCESS;
    }

    public void func_190948_a(ItemStack stack, @Nullable IBlockReader world, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add(new TranslationTextComponent("tooltip.horned_statue.1", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.GREEN)));
        tooltip.add(new TranslationTextComponent("tooltip.horned_statue.2", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.YELLOW).func_150217_b(Boolean.valueOf(true))));
    }
}

