/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.contents;

import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.Pose;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;
import tictim.paraglider.contents.Contents;

public class WindEntity
extends Entity {
    private BlockPos blockPos = null;
    private int lastUsedTickCount = 0;
    private static final DataParameter<Float> HEIGHT = EntityDataManager.func_187226_a(WindEntity.class, (IDataSerializer)DataSerializers.field_187193_c);

    public WindEntity(World world) {
        this((EntityType)Contents.WIND.get(), world);
    }

    public WindEntity(EntityType<?> type, World world) {
        super(type, world);
        this.field_70145_X = true;
        this.field_70180_af.func_187214_a(HEIGHT, (Object)Float.valueOf(0.0f));
    }

    public void extendLife() {
        if (this.blockPos != null) {
            this.lastUsedTickCount = this.field_70173_aa;
        }
    }

    protected void func_70088_a() {
    }

    public EntitySize func_213305_a(Pose poseIn) {
        return this.func_200600_R().func_220334_j().func_220312_a(1.0f, ((Float)this.field_70180_af.func_187225_a(HEIGHT)).floatValue());
    }

    public void setHeight(float height) {
        this.field_70180_af.func_187227_b(HEIGHT, (Object)Float.valueOf(height));
    }

    public void setBlockPos(@Nullable BlockPos pos) {
        if (pos != null) {
            this.func_70107_b((double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
            this.blockPos = pos.func_185334_h();
        } else {
            this.blockPos = null;
        }
    }

    @Nullable
    public BlockPos getBlockPos() {
        return this.blockPos;
    }

    public PushReaction func_184192_z() {
        return PushReaction.IGNORE;
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            if (this.field_70146_Z.nextInt(6) == 0) {
                this.field_70170_p.func_195589_b((IParticleData)ParticleTypes.field_197629_v, this.func_226277_ct_() + this.field_70146_Z.nextDouble() - 0.5, this.func_226278_cu_() + 0.5, this.func_226281_cx_() + this.field_70146_Z.nextDouble() - 0.5, 0.0, 1.0, 0.0);
            }
        } else if (this.field_70173_aa - this.lastUsedTickCount >= 200 || this.blockPos != null && !WindEntity.canBePlaced(this.field_70170_p.func_180495_p(this.blockPos))) {
            this.func_70106_y();
        }
    }

    public void func_184206_a(DataParameter<?> key) {
        super.func_184206_a(key);
        if (key == HEIGHT) {
            this.func_213323_x_();
        }
    }

    protected void func_70037_a(CompoundNBT nbt) {
        if (nbt.func_150297_b("pos", 10)) {
            this.blockPos = NBTUtil.func_186861_c((CompoundNBT)nbt.func_74775_l("pos"));
            this.lastUsedTickCount = nbt.func_74762_e("lastUsed");
            this.field_70180_af.func_187227_b(HEIGHT, (Object)Float.valueOf(nbt.func_74760_g("height")));
        }
    }

    protected void func_213281_b(CompoundNBT nbt) {
        if (this.blockPos != null) {
            nbt.func_218657_a("pos", (INBT)NBTUtil.func_186859_a((BlockPos)this.blockPos));
            nbt.func_74768_a("lastUsed", this.lastUsedTickCount);
            nbt.func_74776_a("height", ((Float)this.field_70180_af.func_187225_a(HEIGHT)).floatValue());
        }
    }

    public static boolean canBePlaced(BlockState state) {
        return state.func_177230_c() == Blocks.field_150480_ab || state.func_196959_b((IProperty)BlockStateProperties.field_208190_q) && (Boolean)state.func_177229_b((IProperty)BlockStateProperties.field_208190_q) != false;
    }
}

