/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.event;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import tictim.paraglider.ModCfg;
import tictim.paraglider.capabilities.Paraglider;
import tictim.paraglider.capabilities.PlayerMovement;
import tictim.paraglider.capabilities.PlayerState;
import tictim.paraglider.client.StaminaWheelRenderer;
import tictim.paraglider.contents.WindEntity;
import tictim.paraglider.item.ParagliderItem;

@Mod.EventBusSubscriber(modid="paraglider", value={Dist.CLIENT})
public final class ParagliderClientEventHandler {
    private static final StaminaWheelRenderer.Color STAMINA_COLOR = StaminaWheelRenderer.Color.of(0, 223, 83);
    private static final StaminaWheelRenderer.Color GLOW_STAMINA_COLOR = StaminaWheelRenderer.Color.of(255, 255, 255);
    private static final StaminaWheelRenderer.Color TRANSPARENT_STAMINA_COLOR = StaminaWheelRenderer.Color.of(255, 255, 255, 0);
    private static final StaminaWheelRenderer.Color DEPLETION_ALTERNATION_1 = StaminaWheelRenderer.Color.of(150, 2, 2);
    private static final StaminaWheelRenderer.Color DEPLETION_ALTERNATION_2 = StaminaWheelRenderer.Color.of(255, 150, 2);
    private static final StaminaWheelRenderer.Color EMPTY_STAMINA_COLOR = StaminaWheelRenderer.Color.of(2, 2, 2, 150);
    private static final StaminaWheelRenderer staminaWheelRenderer = new StaminaWheelRenderer();
    private static int prevStamina;
    private static long fullTime;
    private static final long FULL_GLOW_END_START = 100L;
    private static final long FULL_GLOW_END_TIME = 250L;
    private static final long HIDE_START = 1000L;
    private static final long HIDE_TIME = 100L;
    private static final long ALTERNATION_CYCLE = 300L;
    private static final long ALTERNATION_CYCLE_DEPLETED = 600L;
    private static final StaminaWheelRenderer.Color colorCache;
    private static final double WHEEL_SIZE = 10.0;

    private ParagliderClientEventHandler() {
    }

    @SubscribeEvent
    public static void onRenderOffHand(RenderHandEvent event) {
        if (event.getHand() == Hand.MAIN_HAND && ParagliderItem.hasParaglidingFlag(event.getItemStack())) {
            Minecraft.func_71410_x().field_71460_t.field_78516_c.func_187460_a(Hand.OFF_HAND);
        }
    }

    @SubscribeEvent
    public static void debug(RenderGameOverlayEvent.Text event) {
        PlayerMovement h;
        ClientPlayerEntity p;
        if (ModCfg.debugPlayerMovement() && (p = Minecraft.func_71410_x().field_71439_g) != null && (h = (PlayerMovement)p.getCapability(PlayerMovement.CAP).orElse(null)) != null) {
            List winds;
            ArrayList right = event.getRight();
            ArrayList<String> arr = new ArrayList<String>();
            arr.add("State: " + (Object)((Object)h.getState()));
            arr.add((h.isDepleted() ? TextFormatting.RED : "") + "Stamina: " + h.getStamina() + " / " + h.getMaxStamina());
            arr.add(h.getStaminaVessels() + " Stamina Vessels, " + h.getHeartContainers() + " Heart Containers");
            arr.add(h.getRecoveryDelay() + " Recovery Delay");
            arr.add("Paragliding: " + h.isParagliding());
            if (!right.isEmpty()) {
                arr.add("");
            }
            if (!(winds = p.field_70170_p.func_217357_a(WindEntity.class, p.func_174813_aQ().func_186662_g(5.0))).isEmpty()) {
                arr.add("Winds: " + winds.size() + " entries");
            }
            right.addAll(0, arr);
        }
    }

    @SubscribeEvent
    public static void renderStamina(RenderGameOverlayEvent.Post event) {
        PlayerMovement h;
        if (event.getType() == RenderGameOverlayEvent.ElementType.ALL && (h = (PlayerMovement)Minecraft.func_71410_x().field_71439_g.getCapability(PlayerMovement.CAP).orElse(null)) != null) {
            int maxStamina;
            int stamina = h.getStamina();
            if (stamina >= (maxStamina = h.getMaxStamina())) {
                long timeDiff;
                long time = System.currentTimeMillis();
                if (prevStamina != stamina) {
                    prevStamina = stamina;
                    fullTime = time;
                    timeDiff = 0L;
                } else {
                    timeDiff = time - fullTime;
                }
                if (timeDiff < 100L) {
                    colorCache.set(GLOW_STAMINA_COLOR);
                } else if (timeDiff < 350L) {
                    ParagliderClientEventHandler.blendColor(GLOW_STAMINA_COLOR, STAMINA_COLOR, (float)(timeDiff - 100L) / 250.0f, colorCache);
                } else if (timeDiff >= 1000L && timeDiff < 1100L) {
                    ParagliderClientEventHandler.blendColor(STAMINA_COLOR, TRANSPARENT_STAMINA_COLOR, (float)(timeDiff - 1000L) / 100.0f, colorCache);
                } else if (timeDiff >= 1100L) {
                    return;
                }
                for (StaminaWheelRenderer.WheelType t : StaminaWheelRenderer.WheelType.values()) {
                    staminaWheelRenderer.addWheel(t, 0.0, t.getProportion(stamina), colorCache);
                }
            } else {
                prevStamina = stamina;
                ParagliderClientEventHandler.blendColor(DEPLETION_ALTERNATION_1, DEPLETION_ALTERNATION_2, ParagliderClientEventHandler.cycle(System.currentTimeMillis(), h.isDepleted() ? 600L : 300L), colorCache);
                PlayerState.StaminaAction staminaAction = h.getState().staminaAction;
                for (StaminaWheelRenderer.WheelType t : StaminaWheelRenderer.WheelType.values()) {
                    staminaWheelRenderer.addWheel(t, 0.0, t.getProportion(maxStamina), EMPTY_STAMINA_COLOR);
                    if (h.isDepleted()) {
                        staminaWheelRenderer.addWheel(t, 0.0, t.getProportion(stamina), colorCache);
                        continue;
                    }
                    staminaWheelRenderer.addWheel(t, 0.0, t.getProportion(stamina), STAMINA_COLOR);
                    if (!staminaAction.isConsume || !(h.getState().isParagliding() ? ModCfg.paraglidingConsumesStamina() : ModCfg.runningConsumesStamina())) continue;
                    staminaWheelRenderer.addWheel(t, t.getProportion(stamina - staminaAction.change * 10), t.getProportion(stamina), colorCache);
                }
            }
            MainWindow window = event.getWindow();
            staminaWheelRenderer.render(window.func_198107_o() / 2 - 100, window.func_198087_p() / 2 - 15, 10.0, ModCfg.debugPlayerMovement() && Minecraft.func_71410_x().field_71439_g.func_184592_cb().getCapability(Paraglider.CAP).isPresent());
        }
    }

    private static float cycle(long currentTime, long cycleTime) {
        return (float)Math.abs(currentTime % cycleTime - cycleTime / 2L) / (float)(cycleTime / 2L);
    }

    private static void blendColor(StaminaWheelRenderer.Color color1, StaminaWheelRenderer.Color color2, float blend, StaminaWheelRenderer.Color dest) {
        dest.red = color1.red + (color2.red - color1.red) * blend;
        dest.green = color1.green + (color2.green - color1.green) * blend;
        dest.blue = color1.blue + (color2.blue - color1.blue) * blend;
        dest.alpha = color1.alpha + (color2.alpha - color1.alpha) * blend;
    }

    static {
        colorCache = new StaminaWheelRenderer.Color(0.0f, 0.0f, 0.0f, 0.0f);
    }
}

