/*
 * Decompiled with CFR 0.152.
 */
package com.fuzs.particlefixes.asm;

import com.fuzs.particlefixes.ParticleFixes;
import com.fuzs.particlefixes.asm.Hooks;
import java.util.Arrays;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class ClassTransformer
implements IClassTransformer {
    private static final String[] classesBeingTransformed = new String[]{"net.minecraft.world.ServerWorldEventHandler"};

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        boolean isObfuscated = !name.equals(transformedName);
        int index = Arrays.asList(classesBeingTransformed).indexOf(transformedName);
        return index != -1 ? ClassTransformer.transform(index, basicClass, isObfuscated) : basicClass;
    }

    private static byte[] transform(int index, byte[] basicClass, boolean isObfuscated) {
        ParticleFixes.LOGGER.info("Attempting to transform " + classesBeingTransformed[index]);
        try {
            ClassNode classNode = new ClassNode();
            ClassReader classReader = new ClassReader(basicClass);
            classReader.accept((ClassVisitor)classNode, 0);
            switch (index) {
                case 0: {
                    ClassTransformer.transformServerWorldEventHandler(classNode, isObfuscated);
                }
            }
            ClassWriter classWriter = new ClassWriter(3);
            classNode.accept((ClassVisitor)classWriter);
            return classWriter.toByteArray();
        }
        catch (Exception e) {
            e.printStackTrace();
            return basicClass;
        }
    }

    private static void transformServerWorldEventHandler(ClassNode serverWorldEventHandlerClass, boolean isObfuscated) {
        String SERVERWORLDEVENTHANDLER_SPAWNPARTICLE = isObfuscated ? "a" : "spawnParticle";
        String SERVERWORLDEVENTHANDLER_SPAWNPARTICLE_DESCRIPTOR = isObfuscated ? "(IZDDDDDD[I)V" : "(IZDDDDDD[I)V";
        boolean flag = false;
        for (MethodNode method : serverWorldEventHandlerClass.methods) {
            if (!method.name.equals(SERVERWORLDEVENTHANDLER_SPAWNPARTICLE) || !method.desc.equals(SERVERWORLDEVENTHANDLER_SPAWNPARTICLE_DESCRIPTOR)) continue;
            InsnList newInstructions = new InsnList();
            newInstructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
            newInstructions.add((AbstractInsnNode)new FieldInsnNode(180, isObfuscated ? "op" : "net/minecraft/world/ServerWorldEventHandler", isObfuscated ? "b" : "world", isObfuscated ? "Loo;" : "Lnet/minecraft/world/WorldServer;"));
            newInstructions.add((AbstractInsnNode)new VarInsnNode(21, 1));
            newInstructions.add((AbstractInsnNode)new VarInsnNode(21, 2));
            newInstructions.add((AbstractInsnNode)new VarInsnNode(24, 3));
            newInstructions.add((AbstractInsnNode)new VarInsnNode(24, 5));
            newInstructions.add((AbstractInsnNode)new VarInsnNode(24, 7));
            newInstructions.add((AbstractInsnNode)new VarInsnNode(24, 9));
            newInstructions.add((AbstractInsnNode)new VarInsnNode(24, 11));
            newInstructions.add((AbstractInsnNode)new VarInsnNode(24, 13));
            newInstructions.add((AbstractInsnNode)new VarInsnNode(25, 15));
            newInstructions.add((AbstractInsnNode)new MethodInsnNode(184, Type.getInternalName(Hooks.class), "spawnServerParticle", isObfuscated ? "(Loo;IZDDDDDD[I)V" : "(Lnet/minecraft/world/WorldServer;IZDDDDDD[I)V", false));
            method.instructions.insertBefore(method.instructions.getFirst(), newInstructions);
            flag = true;
        }
        ParticleFixes.LOGGER.info(flag ? "Transformation successful" : "Transformation failed");
    }
}

