/*
 * Decompiled with CFR 0.152.
 */
package shadows.placebo.loot;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import java.util.Random;
import java.util.function.Consumer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.ILootSerializer;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootPoolEntryType;
import net.minecraft.loot.StandaloneLootEntry;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.loot.functions.ILootFunction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import shadows.placebo.recipe.RecipeHelper;

public class StackLootEntry
extends StandaloneLootEntry {
    public static final Serializer SERIALIZER = new Serializer();
    public static final LootPoolEntryType STACKLOOTENTRYTYPE = (LootPoolEntryType)Registry.func_218322_a((Registry)Registry.field_239693_aY_, (ResourceLocation)new ResourceLocation("placebo", "stack_entry"), (Object)new LootPoolEntryType((ILootSerializer)SERIALIZER));
    private final ItemStack stack;
    private final int min;
    private final int max;

    public StackLootEntry(ItemStack stack, int min, int max, int weight, int quality) {
        super(weight, quality, new ILootCondition[0], new ILootFunction[0]);
        this.stack = stack;
        this.min = min;
        this.max = max;
    }

    public StackLootEntry(IForgeRegistryEntry<?> thing, int min, int max, int weight, int quality) {
        this(RecipeHelper.makeStack(thing), min, max, weight, quality);
    }

    public StackLootEntry(ItemStack stack) {
        this(stack, 1, 1, 1, 0);
    }

    protected void func_216154_a(Consumer<ItemStack> list, LootContext ctx) {
        ItemStack s = this.stack.func_77946_l();
        s.func_190920_e(MathHelper.func_76136_a((Random)ctx.func_216032_b(), (int)this.min, (int)this.max));
        list.accept(s);
    }

    public LootPoolEntryType func_230420_a_() {
        return STACKLOOTENTRYTYPE;
    }

    public static class Serializer
    extends StandaloneLootEntry.Serializer<StackLootEntry> {
        protected StackLootEntry func_212829_b_(JsonObject jsonObject, JsonDeserializationContext context, int weight, int quality, ILootCondition[] lootConditions, ILootFunction[] lootFunctions) {
            int min = JSONUtils.func_151208_a((JsonObject)jsonObject, (String)"min", (int)1);
            int max = JSONUtils.func_151208_a((JsonObject)jsonObject, (String)"max", (int)1);
            int count = JSONUtils.func_151208_a((JsonObject)jsonObject, (String)"count", (int)1);
            Item item = JSONUtils.func_188180_i((JsonObject)jsonObject, (String)"item");
            ItemStack stack = new ItemStack((IItemProvider)item, count);
            return new StackLootEntry(stack, min, max, weight, quality);
        }
    }
}

