/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.ctm.client.model;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BlockPart;
import net.minecraft.client.renderer.block.model.BlockPartFace;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelBlock;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import org.apache.commons.lang3.tuple.Pair;
import team.chisel.ctm.api.model.IModelCTM;
import team.chisel.ctm.api.texture.ICTMTexture;
import team.chisel.ctm.api.texture.IChiselFace;
import team.chisel.ctm.api.util.TextureInfo;
import team.chisel.ctm.client.model.ModelBakedCTM;
import team.chisel.ctm.client.texture.IMetadataSectionCTM;
import team.chisel.ctm.client.texture.render.TextureNormal;
import team.chisel.ctm.client.texture.type.TextureTypeNormal;
import team.chisel.ctm.client.util.ResourceUtil;

public class ModelCTM
implements IModelCTM {
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(IMetadataSectionCTM.class, (Object)new IMetadataSectionCTM.Serializer()).create();
    private final ModelBlock modelinfo;
    private IModel vanillamodel;
    private final Int2ObjectMap<JsonElement> overrides;
    protected final Int2ObjectMap<IMetadataSectionCTM> metaOverrides = new Int2ObjectArrayMap();
    protected Int2ObjectMap<TextureAtlasSprite> spriteOverrides;
    protected Map<Pair<Integer, String>, ICTMTexture<?>> textureOverrides;
    private final Collection<ResourceLocation> textureDependencies;
    private transient byte layers;
    private Map<String, ICTMTexture<?>> textures = new HashMap();

    public ModelCTM(ModelBlock modelinfo, IModel vanillamodel, Int2ObjectMap<JsonElement> overrides) throws IOException {
        IMetadataSectionCTM meta;
        this.modelinfo = modelinfo;
        this.vanillamodel = vanillamodel;
        this.overrides = overrides;
        this.textureDependencies = new HashSet<ResourceLocation>();
        this.textureDependencies.addAll(vanillamodel.getTextures());
        for (Map.Entry e : this.overrides.entrySet()) {
            meta = null;
            if (((JsonElement)e.getValue()).isJsonPrimitive() && ((JsonElement)e.getValue()).getAsJsonPrimitive().isString()) {
                ResourceLocation rl2 = new ResourceLocation(((JsonElement)e.getValue()).getAsString());
                meta = ResourceUtil.getMetadata(ResourceUtil.spriteToAbsolute(rl2));
                this.textureDependencies.add(rl2);
            } else if (((JsonElement)e.getValue()).isJsonObject()) {
                JsonObject obj = ((JsonElement)e.getValue()).getAsJsonObject();
                if (!obj.has("ctm_version")) {
                    obj.add("ctm_version", (JsonElement)new JsonPrimitive((Number)1));
                }
                meta = (IMetadataSectionCTM)GSON.fromJson((JsonElement)obj, IMetadataSectionCTM.class);
            }
            if (meta == null) continue;
            this.metaOverrides.put(e.getKey(), (Object)meta);
            this.textureDependencies.addAll(Arrays.asList(meta.getAdditionalTextures()));
        }
        this.textureDependencies.removeIf(rl -> rl.func_110623_a().startsWith("#"));
        for (ResourceLocation res : this.getTextures()) {
            meta = ResourceUtil.getMetadata(ResourceUtil.spriteToAbsolute(res));
            if (meta == null || meta.getType().requiredTextures() == meta.getAdditionalTextures().length + 1) continue;
            throw new IOException(String.format("Texture type %s requires exactly %d textures. %d were provided.", meta.getType(), meta.getType().requiredTextures(), meta.getAdditionalTextures().length + 1));
        }
    }

    @Override
    public IModel getVanillaParent() {
        return this.vanillamodel;
    }

    public Collection<ResourceLocation> getDependencies() {
        return Collections.emptySet();
    }

    public Collection<ResourceLocation> getTextures() {
        return this.textureDependencies;
    }

    public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        IBakedModel parent = this.vanillamodel.bake(state, format, rl -> {
            TextureAtlasSprite sprite = (TextureAtlasSprite)bakedTextureGetter.apply((ResourceLocation)rl);
            IMetadataSectionCTM chiselmeta = null;
            try {
                chiselmeta = ResourceUtil.getMetadata(sprite);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            IMetadataSectionCTM meta = chiselmeta;
            this.textures.computeIfAbsent(sprite.func_94215_i(), s -> {
                TextureNormal tex = meta == null ? new TextureNormal(TextureTypeNormal.INSTANCE, new TextureInfo(new TextureAtlasSprite[]{sprite}, Optional.empty(), null)) : meta.makeTexture(sprite, bakedTextureGetter);
                this.layers = (byte)(this.layers | 1 << (tex.getLayer() == null ? 7 : tex.getLayer().ordinal()));
                return tex;
            });
            return sprite;
        });
        if (this.spriteOverrides == null) {
            this.spriteOverrides = new Int2ObjectArrayMap();
            for (Map.Entry e : this.overrides.entrySet()) {
                if (!((JsonElement)e.getValue()).isJsonPrimitive() || !((JsonElement)e.getValue()).getAsJsonPrimitive().isString()) continue;
                TextureAtlasSprite sprite = bakedTextureGetter.apply(new ResourceLocation(((JsonElement)e.getValue()).getAsString()));
                this.spriteOverrides.put(e.getKey(), (Object)sprite);
            }
        }
        if (this.textureOverrides == null) {
            this.textureOverrides = new HashMap();
            for (Map.Entry e : this.metaOverrides.entrySet()) {
                List<BlockPartFace> matches = this.modelinfo.func_178298_a().stream().flatMap(b -> b.field_178240_c.values().stream()).filter(b -> b.field_178245_c == (Integer)e.getKey()).collect(Collectors.toList());
                HashMultimap bySprite = HashMultimap.create();
                matches.forEach(arg_0 -> this.lambda$bake$5((Multimap)bySprite, arg_0));
                for (Map.Entry e2 : bySprite.asMap().entrySet()) {
                    ICTMTexture<?> tex;
                    ResourceLocation texLoc = new ResourceLocation((String)e2.getKey());
                    TextureAtlasSprite sprite = this.getOverrideSprite((Integer)e.getKey());
                    if (sprite == null) {
                        sprite = bakedTextureGetter.apply(texLoc);
                    }
                    this.layers = (byte)(this.layers | 1 << ((tex = ((IMetadataSectionCTM)e.getValue()).makeTexture(sprite, bakedTextureGetter)).getLayer() == null ? 7 : tex.getLayer().ordinal()));
                    this.textureOverrides.put((Pair<Integer, String>)Pair.of(e.getKey(), (Object)texLoc.toString()), tex);
                }
            }
        }
        return new ModelBakedCTM(this, parent);
    }

    public IModelState getDefaultState() {
        return TRSRTransformation.identity();
    }

    @Override
    public void load() {
    }

    @Override
    @Deprecated
    public Collection<ICTMTexture<?>> getChiselTextures() {
        return this.getCTMTextures();
    }

    @Override
    public Collection<ICTMTexture<?>> getCTMTextures() {
        return ImmutableList.builder().addAll(this.textures.values()).addAll(this.textureOverrides.values()).build();
    }

    @Override
    public ICTMTexture<?> getTexture(String iconName) {
        return this.textures.get(iconName);
    }

    @Override
    @Deprecated
    public IChiselFace getFace(EnumFacing facing) {
        return null;
    }

    @Override
    @Deprecated
    public IChiselFace getDefaultFace() {
        return null;
    }

    @Override
    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        return this.layers < 0 && state.func_177230_c().func_180664_k() == layer || (this.layers >> layer.ordinal() & 1) == 1;
    }

    @Override
    public boolean ignoreStates() {
        return false;
    }

    @Override
    @Nullable
    public TextureAtlasSprite getOverrideSprite(int tintIndex) {
        return (TextureAtlasSprite)this.spriteOverrides.get(tintIndex);
    }

    @Override
    @Nullable
    public ICTMTexture<?> getOverrideTexture(int tintIndex, String sprite) {
        return this.textureOverrides.get(Pair.of((Object)tintIndex, (Object)sprite));
    }

    public IModel retexture(ImmutableMap<String, String> textures) {
        try {
            return ModelCTM.retexture(this, textures);
        }
        catch (IOException e) {
            e.printStackTrace();
            return ModelLoaderRegistry.getMissingModel();
        }
    }

    private static ModelCTM retexture(ModelCTM current, ImmutableMap<String, String> textures) throws IOException {
        IModel vanillamodel = current.getVanillaParent().retexture(textures);
        ArrayList<BlockPart> parts = new ArrayList<BlockPart>();
        for (BlockPart part : current.modelinfo.func_178298_a()) {
            parts.add(new BlockPart(part.field_178241_a, part.field_178239_b, (Map)Maps.newHashMap((Map)part.field_178240_c), part.field_178237_d, part.field_178238_e));
        }
        ModelBlock newModel = new ModelBlock(current.modelinfo.func_178305_e(), parts, (Map)Maps.newHashMap((Map)current.modelinfo.field_178318_c), current.modelinfo.func_178309_b(), current.modelinfo.func_178311_c(), current.modelinfo.func_181682_g(), (List)Lists.newArrayList((Iterable)current.modelinfo.func_187966_f()));
        newModel.field_178317_b = current.modelinfo.field_178317_b;
        newModel.field_178315_d = current.modelinfo.field_178315_d;
        ModelCTM ret = new ModelCTM(newModel, vanillamodel, (Int2ObjectMap<JsonElement>)new Int2ObjectArrayMap(current.overrides));
        ret.modelinfo.field_178318_c.putAll(textures);
        for (Map.Entry e : ret.metaOverrides.entrySet()) {
            ResourceLocation[] additionals = ((IMetadataSectionCTM)e.getValue()).getAdditionalTextures();
            for (int i = 0; i < additionals.length; ++i) {
                ResourceLocation res = additionals[i];
                if (!res.func_110623_a().startsWith("#")) continue;
                additionals[i] = new ResourceLocation((String)textures.get((Object)res.func_110623_a().substring(1)));
                ret.textureDependencies.add(additionals[i]);
            }
        }
        ObjectIterator objectIterator = ret.overrides.keySet().iterator();
        while (objectIterator.hasNext()) {
            int i = (Integer)objectIterator.next();
            ret.overrides.compute((Object)i, (idx, ele) -> {
                if (ele.isJsonPrimitive() && ele.getAsJsonPrimitive().isString()) {
                    ele = new JsonPrimitive((String)textures.get((Object)ele.getAsString().substring(1)));
                    ret.textureDependencies.add(new ResourceLocation(ele.getAsString()));
                }
                return ele;
            });
        }
        return ret;
    }

    private /* synthetic */ void lambda$bake$5(Multimap bySprite, BlockPartFace part) {
        bySprite.put((Object)this.modelinfo.field_178318_c.getOrDefault(part.field_178242_d.substring(1), part.field_178242_d), (Object)part);
    }
}

