/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.portality.gui;

import com.buuz135.portality.data.PortalInformation;
import com.buuz135.portality.gui.ContainerController;
import com.buuz135.portality.gui.GuiButtonImagePortal;
import com.buuz135.portality.gui.IHasTooltip;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import org.lwjgl.input.Mouse;

public class GuiPortals
extends GuiContainer {
    private ContainerController controller;
    private List<PortalInformation> informationList;
    private GuiTextField textField;
    private double scrolling;
    private double lastScrolling;
    private boolean isDragging;
    private int visiblePortalInformations;

    public GuiPortals(ContainerController controller) {
        super((Container)controller);
        this.field_146999_f = 200;
        this.field_147000_g = 186;
        this.controller = controller;
        this.scrolling = 0.0;
        this.lastScrolling = 0.0;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        if (this.informationList != null && !this.informationList.isEmpty()) {
            this.addPortalButtons();
        }
        this.textField = new GuiTextField(0, Minecraft.func_71410_x().field_71466_p, this.field_147003_i + this.field_146999_f - 131, this.field_147009_r + 3, 100, 10);
        this.textField.func_146195_b(true);
        this.textField.func_146189_e(true);
        this.textField.func_146185_a(true);
    }

    public void refresh(List<PortalInformation> informationList) {
        this.informationList = informationList;
        this.addPortalButtons();
    }

    private void addPortalButtons() {
        int pointer;
        if (this.informationList == null) {
            return;
        }
        ArrayList<PortalInformation> informationList = new ArrayList<PortalInformation>(this.informationList);
        informationList.removeIf(information -> information.isPrivate() && !information.getOwner().equals(this.field_146297_k.field_71439_g.func_110124_au()));
        informationList.sort((o1, o2) -> Boolean.compare(o2.isPrivate(), o1.isPrivate()));
        informationList.removeIf(information -> information.getDimension() == this.controller.getController().func_145831_w().field_73011_w.getDimension() && information.getLocation().equals((Object)this.controller.getController().func_174877_v()));
        if (!this.textField.func_146179_b().isEmpty()) {
            informationList.removeIf(portalInformation -> !portalInformation.getName().toLowerCase().contains(this.textField.func_146179_b()));
        }
        this.field_146292_n.clear();
        this.visiblePortalInformations = informationList.size();
        for (int i = pointer = (int)((double)informationList.size() / 7.0 * this.scrolling); i < pointer + 7; ++i) {
            if (informationList.size() <= i) continue;
            GuiButtonImagePortal buttonImage = new GuiButtonImagePortal((PortalInformation)informationList.get(i), i + 3, this.field_147003_i + 9, this.field_147009_r + 19 + 23 * (i - pointer), 157, 22, 0, 234, 0, new ResourceLocation("portality", "textures/gui/portals.png"), this.controller.getController());
            this.func_189646_b((GuiButton)buttonImage);
        }
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        int x = (this.field_146294_l - this.field_146999_f) / 2;
        int y = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_146276_q_();
        this.checkForScrolling(mouseX, mouseY);
        GuiPortals.func_73734_a((int)(this.field_147003_i + 5), (int)(this.field_147009_r + 15), (int)(this.field_147003_i + 165 + 5), (int)(this.field_147009_r + 168 + 15), (int)-14408668);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(new ResourceLocation("portality", "textures/gui/portals.png"));
        this.func_73729_b(x, y, 0, 0, this.field_146999_f, this.field_147000_g);
        this.func_175174_a(this.field_147003_i + this.field_146999_f - 22, (float)((double)(this.field_147009_r + 10) + 140.0 * this.scrolling), 200, 9, 18, 23);
        this.textField.func_146194_f();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        super.func_146979_b(mouseX, mouseY);
        for (GuiButton button : this.field_146292_n) {
            if (!(button instanceof IHasTooltip) || !button.func_146115_a()) continue;
            this.func_146283_a(((IHasTooltip)button).getTooltip(), mouseX - this.field_147003_i, mouseY - this.field_147009_r);
        }
    }

    public void func_73876_c() {
        super.func_73876_c();
        this.textField.func_146178_a();
        this.addPortalButtons();
    }

    protected void func_73869_a(char c, int keyCode) {
        if (keyCode == 1) {
            this.field_146297_k.field_71439_g.func_71053_j();
        }
        String text = this.textField.func_146179_b();
        this.textField.func_146201_a(c, keyCode);
        if (!text.equals(this.textField.func_146179_b())) {
            this.scrolling = 0.0;
            this.lastScrolling = 0.0;
            this.addPortalButtons();
        }
    }

    public void func_146274_d() throws IOException {
        int mouseS = Mouse.getEventDWheel();
        if (mouseS != 0) {
            double step = 1.0 / ((double)this.visiblePortalInformations / 7.0);
            if (mouseS < 0) {
                this.lastScrolling = this.scrolling;
                this.scrolling = Math.min(1.0, this.scrolling + step);
            }
            if (mouseS > 0) {
                this.lastScrolling = this.scrolling;
                this.scrolling = Math.max(0.0, this.scrolling - step);
            }
        }
        super.func_146274_d();
    }

    private void checkForScrolling(int mouseX, int mouseY) {
        if (Mouse.isButtonDown((int)0)) {
            if (!this.isDragging && mouseX > this.field_147003_i + this.field_146999_f - 22 && mouseX < this.field_147003_i + this.field_146999_f - 22 + 18 && mouseY > this.field_147009_r + 10 && mouseY < this.field_147009_r + 10 + 151) {
                this.isDragging = true;
            }
            if (this.isDragging) {
                this.lastScrolling = this.scrolling;
                this.scrolling = MathHelper.func_151237_a((double)((double)(mouseY -= 25 + this.field_147009_r) / 128.0), (double)0.0, (double)1.0);
            }
        } else {
            this.isDragging = false;
        }
    }
}

