/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.portality.handler;

import com.buuz135.portality.Portality;
import com.buuz135.portality.tile.TileController;
import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;

public class ChunkLoaderHandler
implements ForgeChunkManager.LoadingCallback {
    public static final HashMap<TileController, ForgeChunkManager.Ticket> tickets = new HashMap();

    public static void removePortalAsChunkloader(TileController controller) {
        ForgeChunkManager.Ticket ticket = tickets.get((Object)controller);
        if (ticket != null) {
            ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)ticket);
        }
        tickets.remove((Object)controller);
    }

    public static void addPortalAsChunkloader(TileController controller) {
        ChunkPos chunkCoordIntPair;
        if (controller != null && !ChunkLoaderHandler.isAlreadyChunkLoaded(chunkCoordIntPair = new ChunkPos(controller.func_174877_v().func_177958_n() >> 4, controller.func_174877_v().func_177952_p() >> 4), controller.func_145831_w().field_73011_w.getDimension())) {
            ForgeChunkManager.Ticket ticket = tickets.get((Object)controller);
            if (ticket == null) {
                ticket = ForgeChunkManager.requestTicket((Object)Portality.INSTANCE, (World)controller.func_145831_w(), (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL);
            }
            if (ticket != null) {
                ticket.getModData().func_74768_a("X", controller.func_174877_v().func_177958_n());
                ticket.getModData().func_74768_a("Y", controller.func_174877_v().func_177956_o());
                ticket.getModData().func_74768_a("Z", controller.func_174877_v().func_177952_p());
                ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)ticket, (ChunkPos)chunkCoordIntPair);
            }
            tickets.put(controller, ticket);
        }
    }

    public static boolean isAlreadyChunkLoaded(TileController dualVertical) {
        ChunkPos chunkCoordIntPair = new ChunkPos(dualVertical.func_174877_v().func_177958_n() >> 4, dualVertical.func_174877_v().func_177952_p() >> 4);
        return tickets.containsKey((Object)dualVertical) || ChunkLoaderHandler.isAlreadyChunkLoaded(chunkCoordIntPair, dualVertical.func_145831_w().field_73011_w.getDimension());
    }

    public static boolean isAlreadyChunkLoaded(ChunkPos chunkCoordIntPair, int dimID) {
        for (Map.Entry<TileController, ForgeChunkManager.Ticket> set : tickets.entrySet()) {
            ImmutableSet loadedChunks;
            if (set == null || set.getValue() == null || (loadedChunks = set.getValue().getChunkList()) == null || set.getValue().world.field_73011_w.getDimension() != dimID) continue;
            for (ChunkPos theChunks : loadedChunks) {
                if (!theChunks.equals((Object)chunkCoordIntPair)) continue;
                return true;
            }
        }
        return false;
    }

    public void ticketsLoaded(List<ForgeChunkManager.Ticket> tickets, World world) {
        for (ForgeChunkManager.Ticket ticket : tickets) {
            if (ticket == null) continue;
            TileEntity te = world.func_175625_s(new BlockPos(ticket.getModData().func_74762_e("X"), ticket.getModData().func_74762_e("Y"), ticket.getModData().func_74762_e("Z")));
            if (te instanceof TileController) {
                TileController dv = (TileController)te;
                ForgeChunkManager.Ticket ticket1 = ChunkLoaderHandler.tickets.get((Object)dv);
                if (ticket1 != null) {
                    ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)ticket1);
                }
                ChunkLoaderHandler.tickets.put(dv, ticket);
                ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)ticket, (ChunkPos)new ChunkPos(dv.func_174877_v().func_177958_n() >> 4, dv.func_174877_v().func_177952_p() >> 4));
                continue;
            }
            ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)ticket);
        }
    }
}

