/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.portality.handler;

import com.buuz135.portality.Portality;
import com.buuz135.portality.block.BlockController;
import com.buuz135.portality.data.PortalLinkData;
import com.buuz135.portality.network.PortalTeleportMessage;
import com.buuz135.portality.proxy.PortalityConfig;
import com.buuz135.portality.proxy.PortalitySoundHandler;
import com.buuz135.portality.tile.TileController;
import com.buuz135.portality.util.TeleportUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.MobEffects;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketCustomSound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class TeleportHandler {
    private HashMap<Entity, TeleportData> entityTimeToTeleport = new HashMap();
    private HashMap<Entity, TeleportedEntityData> entitesTeleported = new HashMap();
    private TileController controller;

    public TeleportHandler(TileController controller) {
        this.controller = controller;
    }

    public void addEntityToTeleport(Entity entity, PortalLinkData data) {
        if (!this.entityTimeToTeleport.containsKey(entity)) {
            this.entityTimeToTeleport.put(entity, new TeleportData(data));
        }
    }

    public void tick() {
        if (!(this.controller.func_145831_w().func_180495_p(this.controller.func_174877_v()).func_177230_c() instanceof BlockController)) {
            this.controller.closeLink();
            return;
        }
        EnumFacing facing = ((EnumFacing)this.controller.func_145831_w().func_180495_p(this.controller.func_174877_v()).func_177229_b((IProperty)BlockController.FACING)).func_176734_d();
        Random random = this.controller.func_145831_w().field_73012_v;
        BlockPos offset = this.controller.func_174877_v().func_177972_a(facing);
        double mult = (double)this.controller.getLength() / 20.0;
        this.controller.func_145831_w().func_175688_a(EnumParticleTypes.END_ROD, (double)offset.func_177958_n() + 0.5 + random.nextDouble() * 2.0 - 1.0, (double)offset.func_177956_o() + 2.5 + random.nextDouble() * 2.0 - 1.0, (double)offset.func_177952_p() + 0.5 + random.nextDouble() * 2.0 - 1.0, (double)facing.func_176730_m().func_177958_n() * mult, (double)facing.func_176730_m().func_177956_o() * mult, (double)facing.func_176730_m().func_177952_p() * mult, new int[0]);
        ArrayList<Object> entityRemove = new ArrayList<Object>();
        for (Map.Entry<Entity, TeleportData> entry : this.entityTimeToTeleport.entrySet()) {
            if (entry.getKey().field_70128_L || !this.controller.func_145831_w().func_72872_a(Entity.class, this.controller.getPortalArea()).contains(entry.getKey())) {
                entityRemove.add(entry.getKey());
                continue;
            }
            if (entry.getKey() instanceof EntityPlayer && entry.getKey().func_70093_af()) {
                entityRemove.add(entry.getKey());
                continue;
            }
            BlockPos destinationPos = this.controller.func_174877_v().func_177982_a(0, 2, 0).func_177967_a(facing, this.controller.getLength() - 1);
            Vec3d destination = new Vec3d((Vec3i)destinationPos).func_72441_c(0.5, 0.0, 0.5);
            double distance = destinationPos.func_185332_f(entry.getKey().func_180425_c().func_177958_n(), entry.getKey().func_180425_c().func_177956_o(), entry.getKey().func_180425_c().func_177952_p());
            TeleportData teleportData = entry.getValue();
            destination = destination.func_178786_a(entry.getKey().field_70165_t, entry.getKey().field_70163_u, entry.getKey().field_70161_v).func_186678_a((teleportData.time = teleportData.time + 0.05) / distance);
            if (distance <= 1.0) {
                if (!entry.getKey().field_70170_p.field_72995_K) {
                    if (this.controller.getEnergy().extractEnergyInternal(PortalityConfig.TELEPORT_ENERGY_AMOUNT, true) == PortalityConfig.TELEPORT_ENERGY_AMOUNT) {
                        WorldServer tpWorld = entry.getKey().field_70170_p.func_73046_m().func_71218_a(entry.getValue().data.getDimension());
                        EnumFacing tpFacing = (EnumFacing)tpWorld.func_180495_p(entry.getValue().data.getPos()).func_177229_b((IProperty)BlockController.FACING);
                        BlockPos pos = entry.getValue().data.getPos().func_177972_a(tpFacing);
                        Entity entity = TeleportUtil.teleportEntity(entry.getKey(), entry.getValue().data.getDimension(), (double)pos.func_177958_n() + 0.5, pos.func_177956_o() + 2, (double)pos.func_177952_p() + 0.5, tpFacing.func_185119_l(), 0.0f);
                        this.entitesTeleported.put(entity, new TeleportedEntityData(entry.getValue().data));
                        this.controller.getEnergy().extractEnergyInternal(PortalityConfig.TELEPORT_ENERGY_AMOUNT, false);
                        if (entry.getKey() instanceof EntityPlayerMP) {
                            Portality.NETWORK.sendTo((IMessage)new PortalTeleportMessage(tpFacing.func_176745_a(), this.controller.getLength()), (EntityPlayerMP)entry.getKey());
                        }
                        if (this.controller.teleportedEntity()) {
                            return;
                        }
                    } else if (entry.getKey() instanceof EntityLivingBase && PortalityConfig.HURT_PLAYERS) {
                        ((EntityLivingBase)entry.getKey()).func_70690_d(new PotionEffect(MobEffects.field_82731_v, 100, 1));
                    }
                }
                entityRemove.add(entry.getKey());
                continue;
            }
            entry.getKey().field_70159_w = destination.field_72450_a;
            entry.getKey().field_70181_x = destination.field_72448_b;
            entry.getKey().field_70179_y = destination.field_72449_c;
        }
        for (Entity entity : entityRemove) {
            this.entityTimeToTeleport.remove(entity);
        }
        entityRemove.clear();
        for (Map.Entry<Object, Object> entry : this.entitesTeleported.entrySet()) {
            ((TeleportedEntityData)entry.getValue()).ticks++;
            if (((TeleportedEntityData)entry.getValue()).ticks > 2 && !((TeleportedEntityData)entry.getValue()).moved) {
                ((Entity)entry.getKey()).field_70170_p.func_72872_a(EntityPlayerMP.class, new AxisAlignedBB(((Entity)entry.getKey()).field_70165_t, ((Entity)entry.getKey()).field_70163_u, ((Entity)entry.getKey()).field_70161_v, ((Entity)entry.getKey()).field_70165_t, ((Entity)entry.getKey()).field_70163_u, ((Entity)entry.getKey()).field_70161_v).func_186662_g(16.0)).forEach(entityPlayer -> entityPlayer.field_71135_a.func_147359_a((Packet)new SPacketCustomSound(PortalitySoundHandler.PORTAL_TP.func_187503_a().toString(), SoundCategory.BLOCKS, ((Entity)entry.getKey()).field_70165_t, ((Entity)entry.getKey()).field_70163_u, ((Entity)entry.getKey()).field_70161_v, 0.5f, 1.0f)));
                ((TeleportedEntityData)entry.getValue()).moved = true;
                World tpWorld = ((Entity)entry.getKey()).field_70170_p;
                EnumFacing tpFacing = (EnumFacing)tpWorld.func_180495_p(((TeleportedEntityData)entry.getValue()).data.getPos()).func_177229_b((IProperty)BlockController.FACING);
                Vec3d vec3d = new Vec3d(tpFacing.func_176730_m()).func_186678_a((double)(2 * this.controller.getLength()) / (double)PortalityConfig.MAX_PORTAL_LENGTH);
                ((Entity)entry.getKey()).field_70159_w = vec3d.field_72450_a;
                ((Entity)entry.getKey()).field_70181_x = vec3d.field_72448_b;
                ((Entity)entry.getKey()).field_70179_y = vec3d.field_72449_c;
                ((Entity)entry.getKey()).func_70034_d(tpFacing.func_185119_l());
            }
            if (((TeleportedEntityData)entry.getValue()).ticks <= 40) continue;
            entityRemove.add(entry.getKey());
        }
        for (Entity entity : entityRemove) {
            this.entitesTeleported.remove(entity);
        }
    }

    private class TeleportedEntityData {
        private int ticks;
        private boolean moved;
        private PortalLinkData data;

        public TeleportedEntityData(PortalLinkData data) {
            this.data = data;
            this.ticks = 0;
            this.moved = false;
        }
    }

    private class TeleportData {
        private PortalLinkData data;
        private double time;

        public TeleportData(PortalLinkData data) {
            this.data = data;
            this.time = 0.0;
        }
    }
}

