/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.portality.network;

import com.buuz135.portality.data.PortalLinkData;
import com.buuz135.portality.tile.TileController;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PortalLinkMessage
implements IMessage {
    private int type;
    private PortalLinkData linkSender;
    private PortalLinkData linkReceiver;

    public PortalLinkMessage() {
    }

    public PortalLinkMessage(int type, PortalLinkData linkSender, PortalLinkData linkReceiver) {
        this.type = type;
        this.linkSender = linkSender;
        this.linkReceiver = linkReceiver;
    }

    public void fromBytes(ByteBuf buf) {
        PacketBuffer packet = new PacketBuffer(buf);
        this.type = packet.readInt();
        try {
            this.linkSender = PortalLinkData.readFromNBT(packet.func_150793_b());
            this.linkReceiver = PortalLinkData.readFromNBT(packet.func_150793_b());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void toBytes(ByteBuf buf) {
        PacketBuffer packet = new PacketBuffer(buf);
        packet.writeInt(this.type);
        packet.func_150786_a(this.linkSender.writeToNBT());
        packet.func_150786_a(this.linkReceiver.writeToNBT());
    }

    public static class Handler
    implements IMessageHandler<PortalLinkMessage, IMessage> {
        public IMessage onMessage(PortalLinkMessage message, MessageContext ctx) {
            WorldServer world = ctx.getServerHandler().field_147369_b.field_70170_p.func_73046_m().func_71218_a(message.linkSender.getDimension());
            TileEntity tileEntity = world.func_175625_s(message.linkSender.getPos());
            if (tileEntity instanceof TileController) {
                ((TileController)tileEntity).linkTo(new PortalLinkData(message.linkReceiver.getDimension(), message.linkReceiver.getPos(), true), PortalLinkData.PortalCallType.values()[message.type]);
            }
            return null;
        }
    }
}

