/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.portality.network;

import com.buuz135.portality.Portality;
import com.buuz135.portality.data.PortalDataManager;
import com.buuz135.portality.data.PortalInformation;
import com.buuz135.portality.gui.GuiPortals;
import com.buuz135.portality.tile.TileController;
import com.buuz135.portality.util.BlockPosUtils;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PortalNetworkMessage {

    public static class HandleResponse
    implements IMessageHandler<Response, IMessage> {
        public IMessage onMessage(Response message, MessageContext ctx) {
            Minecraft.func_71410_x().func_152344_a(() -> {
                if (Minecraft.func_71410_x().field_71462_r instanceof GuiPortals) {
                    ((GuiPortals)Minecraft.func_71410_x().field_71462_r).refresh(message.information);
                }
            });
            return null;
        }
    }

    public static class HandleRequest
    implements IMessageHandler<Request, Response> {
        public Response onMessage(Request message, MessageContext ctx) {
            ctx.getServerHandler().field_147369_b.func_184102_h().func_152344_a(() -> {
                ArrayList<PortalInformation> infos = new ArrayList<PortalInformation>(PortalDataManager.getData(ctx.getServerHandler().field_147369_b.field_70170_p).getInformationList());
                infos.removeIf(information -> {
                    WorldServer world = ctx.getServerHandler().field_147369_b.func_184102_h().func_71218_a(information.getDimension());
                    return world.func_175625_s(information.getLocation()) instanceof TileController && !((TileController)world.func_175625_s(information.getLocation())).isFormed();
                });
                infos.removeIf(information -> !message.interdimensional && ctx.getServerHandler().field_147369_b.func_71121_q().field_73011_w.getDimension() != information.getDimension());
                infos.removeIf(information -> message.interdimensional && ctx.getServerHandler().field_147369_b.func_71121_q().field_73011_w.getDimension() != information.getDimension() && !information.isInterdimensional());
                infos.removeIf(information -> {
                    WorldServer world = ctx.getServerHandler().field_147369_b.field_70170_p.func_73046_m().func_71218_a(information.getDimension());
                    TileEntity entity = world.func_175625_s(information.getLocation());
                    return entity instanceof TileController && !message.interdimensional && ctx.getServerHandler().field_147369_b.func_71121_q().field_73011_w.getDimension() == information.getDimension() && (information.getLocation().func_185332_f(message.pos.func_177958_n(), message.pos.func_177956_o(), message.pos.func_177952_p()) >= (double)message.distance || information.getLocation().func_185332_f(message.pos.func_177958_n(), message.pos.func_177956_o(), message.pos.func_177952_p()) >= (double)BlockPosUtils.getMaxDistance(((TileController)entity).getLength()));
                });
                Portality.NETWORK.sendTo((IMessage)new Response(infos), ctx.getServerHandler().field_147369_b);
            });
            return null;
        }
    }

    public static class Response
    implements IMessage {
        private List<PortalInformation> information;

        public Response() {
            this.information = new ArrayList<PortalInformation>();
        }

        public Response(List<PortalInformation> information) {
            this.information = information;
        }

        public void fromBytes(ByteBuf buf) {
            PacketBuffer packet = new PacketBuffer(buf);
            for (int amount = packet.readInt(); amount > 0; --amount) {
                try {
                    this.information.add(PortalInformation.readFromNBT(packet.func_150793_b()));
                    continue;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }

        public void toBytes(ByteBuf buf) {
            PacketBuffer packet = new PacketBuffer(buf);
            packet.writeInt(this.information.size());
            for (PortalInformation portalInformation : this.information) {
                packet.func_150786_a(portalInformation.writetoNBT());
            }
        }
    }

    public static class Request
    implements IMessage {
        private boolean interdimensional;
        private BlockPos pos;
        private int distance;

        public Request() {
        }

        public Request(boolean interdimensional, BlockPos pos, int distance) {
            this.interdimensional = interdimensional;
            this.pos = pos;
            this.distance = distance;
        }

        public void fromBytes(ByteBuf buf) {
            this.interdimensional = buf.readBoolean();
            this.pos = BlockPos.func_177969_a((long)buf.readLong());
            this.distance = buf.readInt();
        }

        public void toBytes(ByteBuf buf) {
            buf.writeBoolean(this.interdimensional);
            buf.writeLong(this.pos.func_177986_g());
            buf.writeInt(this.distance);
        }
    }
}

