/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.portality.gui;

import com.buuz135.portality.data.PortalInformation;
import com.buuz135.portality.gui.PortalityAssetProvider;
import com.buuz135.portality.gui.button.GuiButtonImagePortal;
import com.buuz135.portality.gui.button.PortalCallButton;
import com.buuz135.portality.tile.TileController;
import com.hrznstudio.titanium.api.IFactory;
import com.hrznstudio.titanium.api.client.IGuiAddon;
import com.hrznstudio.titanium.client.gui.GuiAddonScreen;
import com.hrznstudio.titanium.client.gui.asset.IAssetProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.util.ResourceLocation;

public class GuiPortals
extends GuiAddonScreen {
    private final int guiHeight;
    private final int guiWidth;
    private List<PortalInformation> informationList;
    private TextFieldWidget textField;
    private double scrolling = 0.0;
    private double lastScrolling = 0.0;
    private boolean isDragging;
    private int visiblePortalInformations;
    private List<GuiButtonImagePortal> portalButtons = new ArrayList<GuiButtonImagePortal>();
    private PortalInformation selectedPortal;
    private TileController controller;

    public GuiPortals(TileController controller) {
        super((IAssetProvider)PortalityAssetProvider.PROVIDER, false);
        this.guiWidth = 200;
        this.guiHeight = 186;
        this.controller = controller;
    }

    public void init() {
        super.init();
        this.x = this.width / 2 - this.guiWidth / 2;
        this.y = this.height / 2 - this.guiWidth / 2;
        if (this.informationList != null && !this.informationList.isEmpty()) {
            this.addPortalButtons();
        }
        this.textField = new TextFieldWidget(Minecraft.func_71410_x().field_71466_p, this.x + this.guiWidth - 131, this.y + 3, 100, 10, "");
        this.textField.func_146195_b(true);
        this.textField.func_146189_e(true);
        this.textField.func_146185_a(true);
        this.setFocused((IGuiEventListener)this.textField);
        this.getAddons().add(new PortalCallButton(this.x + 9, this.y + this.guiHeight + 2, this.controller, PortalCallButton.CallAction.OPEN, this));
        this.getAddons().add(new PortalCallButton(this.x + 53 + 9, this.y + this.guiHeight + 2, this.controller, PortalCallButton.CallAction.ONCE, this));
        this.getAddons().add(new PortalCallButton(this.x + 106 + 9, this.y + this.guiHeight + 2, this.controller, PortalCallButton.CallAction.FORCE, this));
    }

    private void addPortalButtons() {
        int pointer;
        if (this.informationList == null) {
            return;
        }
        final ArrayList<PortalInformation> informationList = new ArrayList<PortalInformation>(this.informationList);
        informationList.removeIf(information -> information.isPrivate() && !information.getOwner().equals(Minecraft.func_71410_x().field_71439_g.func_110124_au()));
        informationList.sort((o1, o2) -> Boolean.compare(o2.isPrivate(), o1.isPrivate()));
        if (!this.textField.func_146179_b().isEmpty()) {
            informationList.removeIf(portalInformation -> !portalInformation.getName().toLowerCase().contains(this.textField.func_146179_b()));
        }
        this.buttons.removeIf(guiButton -> this.portalButtons.contains(guiButton));
        this.portalButtons.clear();
        this.visiblePortalInformations = informationList.size();
        for (int i = pointer = (int)((double)informationList.size() / 7.0 * this.scrolling); i < pointer + 7; ++i) {
            if (informationList.size() <= i) continue;
            final int finalI = i;
            GuiButtonImagePortal buttonImage = new GuiButtonImagePortal(this, (PortalInformation)informationList.get(finalI), this.x + 9, this.y + 19 + 23 * (finalI - pointer), 157, 22, 0, 234, 0, new ResourceLocation("portality", "textures/gui/portals.png")){

                public void onClick(double mouseX, double mouseY) {
                    if (this.isMouseOver(mouseX, mouseY)) {
                        GuiPortals.this.selectedPortal = (PortalInformation)informationList.get(finalI);
                    }
                    super.onClick(mouseX, mouseY);
                }
            };
            this.addButton((Widget)buttonImage);
            this.portalButtons.add(buttonImage);
        }
    }

    public boolean keyPressed(int p_keyPressed_1_, int p_keyPressed_2_, int p_keyPressed_3_) {
        boolean pressed = super.keyPressed(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_);
        Minecraft.func_71410_x().func_212871_a_(() -> {
            this.scrolling = 0.0;
            this.lastScrolling = 0.0;
            this.addPortalButtons();
        });
        return pressed;
    }

    public void refresh(List<PortalInformation> informationList) {
        this.informationList = informationList;
        this.addPortalButtons();
    }

    public void renderBackground(int mouseX, int mouseY, float partialTicks) {
        this.renderBackground();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(new ResourceLocation("portality", "textures/gui/portals.png"));
        this.blit(this.x, this.y, 0, 0, this.guiWidth, this.guiHeight);
        this.blit(this.x + this.guiWidth - 22, (int)((double)(this.y + 10) + 140.0 * this.scrolling), 200, 9, 18, 23);
        super.renderBackground(mouseX, mouseY, partialTicks);
        this.textField.render(mouseX, mouseY, partialTicks);
    }

    public List<IFactory<IGuiAddon>> guiAddons() {
        return Collections.emptyList();
    }

    public void tick() {
        super.tick();
        this.textField.func_146178_a();
    }

    public PortalInformation getSelectedPortal() {
        return this.selectedPortal;
    }

    public boolean isPauseScreen() {
        return false;
    }
}

