/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.portality.gui.button;

import com.hrznstudio.titanium.Titanium;
import com.hrznstudio.titanium.api.IFactory;
import com.hrznstudio.titanium.api.client.IGuiAddon;
import com.hrznstudio.titanium.block.tile.button.PosButton;
import com.hrznstudio.titanium.client.gui.ITileContainer;
import com.hrznstudio.titanium.client.gui.addon.BasicButtonAddon;
import com.hrznstudio.titanium.client.gui.asset.IAssetProvider;
import com.hrznstudio.titanium.network.locator.LocatorInstance;
import com.hrznstudio.titanium.network.locator.instance.TileEntityLocatorInstance;
import com.hrznstudio.titanium.network.messages.ButtonClickNetworkMessage;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class TextPortalButton
extends PosButton {
    private final String display;
    private Supplier<Consumer<Screen>> screenConsumer;

    public TextPortalButton(int posX, int posY, int sizeX, int sizeY, String display) {
        super(posX, posY, sizeX, sizeY);
        this.display = display;
        this.screenConsumer = () -> screen -> {};
    }

    public String getDisplay() {
        return this.display;
    }

    public TextPortalButton setClientConsumer(Supplier<Consumer<Screen>> screenConsumer) {
        this.screenConsumer = screenConsumer;
        return this;
    }

    public List<IFactory<? extends IGuiAddon>> getGuiAddons() {
        return Collections.singletonList(() -> new TextButtonAddon(this, this.display, this.screenConsumer.get()));
    }

    public class TextButtonAddon
    extends BasicButtonAddon {
        private String text;
        private Consumer<Screen> supplier;

        public TextButtonAddon(PosButton posButton, String text, Consumer<Screen> supplier) {
            super(posButton);
            this.text = text;
            this.supplier = supplier;
        }

        public void drawGuiContainerBackgroundLayer(Screen screen, IAssetProvider provider, int guiX, int guiY, int mouseX, int mouseY, float partialTicks) {
            super.drawGuiContainerBackgroundLayer(screen, provider, guiX, guiY, mouseX, mouseY, partialTicks);
            String string = new TranslationTextComponent(this.text, new Object[0]).func_150261_e();
            TextFormatting color = this.isInside(screen, mouseX - guiX, mouseY - guiY) ? TextFormatting.YELLOW : TextFormatting.WHITE;
            Minecraft.func_71410_x().field_71466_p.func_211126_b(color + string, (float)(guiX + this.getPosX() + this.getXSize() / 2 - Minecraft.func_71410_x().field_71466_p.func_78256_a(string) / 2), (float)(guiY + this.getPosY()) + (float)this.getYSize() / 2.0f - 3.5f, 0xFFFFFF);
        }

        public void handleClick(Screen tile, int guiX, int guiY, double mouseX, double mouseY, int button) {
            Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)new SimpleSound(SoundEvents.field_187909_gi, SoundCategory.PLAYERS, 1.0f, 1.0f, Minecraft.func_71410_x().field_71439_g.func_180425_c()));
            if (tile instanceof ITileContainer) {
                Titanium.NETWORK.get().sendToServer((Object)new ButtonClickNetworkMessage((LocatorInstance)new TileEntityLocatorInstance(((ITileContainer)tile).getTile().func_174877_v()), TextPortalButton.this.getId(), new CompoundNBT()));
            }
            this.supplier.accept(tile);
        }
    }
}

