/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.portality.handler;

import com.buuz135.portality.Portality;
import com.buuz135.portality.block.BlockController;
import com.buuz135.portality.data.PortalLinkData;
import com.buuz135.portality.network.PortalTeleportMessage;
import com.buuz135.portality.proxy.PortalityConfig;
import com.buuz135.portality.proxy.PortalitySoundHandler;
import com.buuz135.portality.tile.TileController;
import com.hrznstudio.titanium.util.TeleportationUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SPlaySoundPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkDirection;

public class TeleportHandler {
    private HashMap<Entity, TeleportData> entityTimeToTeleport = new HashMap();
    private HashMap<Entity, TeleportedEntityData> entitesTeleported = new HashMap();
    private TileController controller;

    public TeleportHandler(TileController controller) {
        this.controller = controller;
    }

    public void addEntityToTeleport(Entity entity, PortalLinkData data) {
        if (!this.entityTimeToTeleport.containsKey(entity)) {
            this.entityTimeToTeleport.put(entity, new TeleportData(data));
        }
    }

    public void tick() {
        if (!(this.controller.func_145831_w().func_180495_p(this.controller.func_174877_v()).func_177230_c() instanceof BlockController)) {
            this.controller.closeLink();
            return;
        }
        Direction facing = ((Direction)this.controller.func_145831_w().func_180495_p(this.controller.func_174877_v()).func_177229_b((IProperty)BlockController.FACING)).func_176734_d();
        Random random = this.controller.func_145831_w().field_73012_v;
        BlockPos offset = this.controller.func_174877_v().func_177972_a(facing);
        double mult = (double)this.controller.getLength() / 20.0;
        this.controller.func_145831_w().func_195594_a((IParticleData)ParticleTypes.field_197624_q, (double)offset.func_177958_n() + 0.5 + random.nextDouble() * (double)(this.controller.getWidth() + 2) - (double)(this.controller.getWidth() + 2) / 2.0, (double)offset.func_177956_o() + (double)this.controller.getHeight() / 2.0 + random.nextDouble() * (double)(this.controller.getHeight() - 2) - (double)(this.controller.getHeight() - 2) / 2.0, (double)offset.func_177952_p() + 0.5 + random.nextDouble() * 2.0 - 1.0, (double)facing.func_176730_m().func_177958_n() * mult, (double)facing.func_176730_m().func_177956_o() * mult, (double)facing.func_176730_m().func_177952_p() * mult);
        ArrayList<Object> entityRemove = new ArrayList<Object>();
        for (Map.Entry<Entity, TeleportData> entry : this.entityTimeToTeleport.entrySet()) {
            if (!entry.getKey().func_70089_S() || !this.controller.func_145831_w().func_217357_a(Entity.class, this.controller.getPortalArea()).contains(entry.getKey())) {
                entityRemove.add(entry.getKey());
                continue;
            }
            if (entry.getKey() instanceof PlayerEntity && entry.getKey().func_70093_af()) {
                entityRemove.add(entry.getKey());
                continue;
            }
            BlockPos destinationPos = this.controller.func_174877_v().func_177982_a(0, this.controller.getHeight() / 2, 0).func_177967_a(facing, this.controller.getLength() - 1);
            Vec3d destination = new Vec3d((Vec3i)destinationPos).func_72441_c(0.5, 0.0, 0.5);
            double distance = destinationPos.func_218139_n(new Vec3i(entry.getKey().func_180425_c().func_177958_n(), entry.getKey().func_180425_c().func_177956_o(), entry.getKey().func_180425_c().func_177952_p()));
            TeleportData teleportData = entry.getValue();
            destination = destination.func_178786_a(entry.getKey().field_70165_t, entry.getKey().field_70163_u, entry.getKey().field_70161_v).func_186678_a((teleportData.time = teleportData.time + 0.05) / distance);
            if (distance <= 1.5) {
                if (!entry.getKey().field_70170_p.field_72995_K) {
                    if (this.controller.getEnergyStorage().getEnergyStored() >= PortalityConfig.TELEPORT_ENERGY_AMOUNT) {
                        ServerWorld tpWorld = entry.getKey().field_70170_p.func_73046_m().func_71218_a(DimensionType.func_186069_a((int)entry.getValue().data.getDimension()));
                        Direction tpFacing = (Direction)tpWorld.func_180495_p(entry.getValue().data.getPos()).func_177229_b((IProperty)BlockController.FACING);
                        BlockPos pos = entry.getValue().data.getPos().func_177972_a(tpFacing);
                        Entity entity = TeleportationUtils.teleportEntity((Entity)entry.getKey(), (DimensionType)DimensionType.func_186069_a((int)entry.getValue().data.getDimension()), (double)((double)pos.func_177958_n() + 0.5), (double)(pos.func_177956_o() + 2), (double)((double)pos.func_177952_p() + 0.5), (float)tpFacing.func_185119_l(), (float)0.0f);
                        this.entitesTeleported.put(entity, new TeleportedEntityData(entry.getValue().data));
                        this.controller.getEnergyStorage().extractEnergyForced(PortalityConfig.TELEPORT_ENERGY_AMOUNT);
                        if (entry.getKey() instanceof ServerPlayerEntity) {
                            Portality.NETWORK.get().sendTo((Object)new PortalTeleportMessage(tpFacing.func_176745_a(), this.controller.getLength()), ((ServerPlayerEntity)entry.getKey()).field_71135_a.field_147371_a, NetworkDirection.PLAY_TO_CLIENT);
                        }
                        if (this.controller.teleportedEntity()) {
                            return;
                        }
                    } else if (entry.getKey() instanceof LivingEntity && PortalityConfig.HURT_PLAYERS) {
                        ((LivingEntity)entry.getKey()).func_195064_c(new EffectInstance(Effects.field_82731_v, 100, 1));
                    }
                }
                entityRemove.add(entry.getKey());
                continue;
            }
            entry.getKey().func_213293_j(destination.field_72450_a, destination.field_72448_b, destination.field_72449_c);
        }
        for (Entity entity : entityRemove) {
            this.entityTimeToTeleport.remove(entity);
        }
        entityRemove.clear();
        for (Map.Entry<Object, Object> entry : this.entitesTeleported.entrySet()) {
            ((TeleportedEntityData)entry.getValue()).ticks++;
            if (((TeleportedEntityData)entry.getValue()).ticks > 2 && !((TeleportedEntityData)entry.getValue()).moved) {
                if (((Entity)entry.getKey()).field_70170_p.field_72995_K) {
                    ((Entity)entry.getKey()).field_70170_p.func_217357_a(ServerPlayerEntity.class, new AxisAlignedBB(((Entity)entry.getKey()).field_70165_t, ((Entity)entry.getKey()).field_70163_u, ((Entity)entry.getKey()).field_70161_v, ((Entity)entry.getKey()).field_70165_t, ((Entity)entry.getKey()).field_70163_u, ((Entity)entry.getKey()).field_70161_v).func_186662_g(16.0)).forEach(entityPlayer -> entityPlayer.field_71135_a.func_147359_a((IPacket)new SPlaySoundPacket(PortalitySoundHandler.PORTAL_TP.getRegistryName(), SoundCategory.BLOCKS, new Vec3d(((Entity)entry.getKey()).field_70165_t, ((Entity)entry.getKey()).field_70163_u, ((Entity)entry.getKey()).field_70161_v), 0.5f, 1.0f)));
                }
                ((TeleportedEntityData)entry.getValue()).moved = true;
                World tpWorld = ((Entity)entry.getKey()).field_70170_p;
                if (tpWorld.func_180495_p(((TeleportedEntityData)entry.getValue()).data.getPos()).func_177230_c() instanceof BlockController) {
                    Direction tpFacing = (Direction)tpWorld.func_180495_p(((TeleportedEntityData)entry.getValue()).data.getPos()).func_177229_b((IProperty)BlockController.FACING);
                    Vec3d vec3d = new Vec3d(tpFacing.func_176730_m()).func_186678_a((double)(2 * this.controller.getLength()) / (double)PortalityConfig.MAX_PORTAL_LENGTH);
                    ((Entity)entry.getKey()).func_213293_j(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c);
                    ((Entity)entry.getKey()).func_70034_d(tpFacing.func_185119_l());
                }
            }
            if (((TeleportedEntityData)entry.getValue()).ticks <= 40) continue;
            entityRemove.add(entry.getKey());
        }
        for (Entity entity : entityRemove) {
            this.entitesTeleported.remove(entity);
        }
    }

    private class TeleportedEntityData {
        private int ticks;
        private boolean moved;
        private PortalLinkData data;

        public TeleportedEntityData(PortalLinkData data) {
            this.data = data;
            this.ticks = 0;
            this.moved = false;
        }
    }

    private class TeleportData {
        private PortalLinkData data;
        private double time;

        public TeleportData(PortalLinkData data) {
            this.data = data;
            this.time = 0.0;
        }
    }
}

