/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.block.tile;

import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.api.IFactory;
import com.hrznstudio.titanium.api.IMachine;
import com.hrznstudio.titanium.api.augment.IAugment;
import com.hrznstudio.titanium.api.augment.IAugmentType;
import com.hrznstudio.titanium.api.client.AssetTypes;
import com.hrznstudio.titanium.api.client.IGuiAddon;
import com.hrznstudio.titanium.block.BlockTileBase;
import com.hrznstudio.titanium.block.tile.TilePowered;
import com.hrznstudio.titanium.block.tile.inventory.PosInvHandler;
import com.hrznstudio.titanium.block.tile.inventory.SidedInvHandler;
import com.hrznstudio.titanium.block.tile.sideness.IFacingHandler;
import com.hrznstudio.titanium.client.gui.addon.AssetGuiAddon;
import com.hrznstudio.titanium.util.FacingUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;

public class TileMachine
extends TilePowered
implements IMachine {
    @Save
    private SidedInvHandler augmentInventory = (SidedInvHandler)this.getAugmentFactory().create().setTile(this).setInputFilter((stack, integer) -> stack.func_77973_b() instanceof IAugment && this.canAcceptAugment((IAugment)stack.func_77973_b()));

    public TileMachine(BlockTileBase blockTileBase) {
        super(blockTileBase);
        this.addInventory(this.augmentInventory);
        this.addGuiAddonFactory(this.getAugmentBackground());
        for (FacingUtil.Sideness value : FacingUtil.Sideness.values()) {
            this.augmentInventory.getFacingModes().put(value, IFacingHandler.FaceMode.NONE);
        }
    }

    @Override
    public boolean isActive() {
        return false;
    }

    @Override
    public boolean isPaused() {
        return false;
    }

    @Override
    public boolean canAcceptAugment(IAugment augment) {
        return augment.canWorkIn(this);
    }

    @Override
    public List<IAugment> getInstalledAugments() {
        return this.getItemStackAugments().stream().filter(item -> item.func_77973_b() instanceof IAugment).map(stack -> (IAugment)stack.func_77973_b()).collect(Collectors.toList());
    }

    @Override
    public List<IAugment> getInstalledAugments(IAugmentType filter) {
        return this.getInstalledAugments().stream().filter(iAugment -> iAugment.getAugmentType().getType().equals(filter.getType())).collect(Collectors.toList());
    }

    @Override
    public boolean hasAugmentInstalled(IAugmentType augmentType) {
        return this.getInstalledAugments(augmentType).size() > 0;
    }

    public IFactory<PosInvHandler> getAugmentFactory() {
        return () -> new SidedInvHandler("augments", 180, 11, 4, 0).disableFacingAddon().setColor(DyeColor.PURPLE).setRange(1, 4);
    }

    public IFactory<? extends IGuiAddon> getAugmentBackground() {
        return () -> new AssetGuiAddon(AssetTypes.AUGMENT_BACKGROUND, 175, 4, true);
    }

    private List<ItemStack> getItemStackAugments() {
        ArrayList<ItemStack> augments = new ArrayList<ItemStack>();
        for (int i = 0; i < this.augmentInventory.getSlots(); ++i) {
            augments.add(this.augmentInventory.getStackInSlot(i).func_77946_l());
        }
        return augments;
    }

    @Override
    public boolean onActivated(PlayerEntity playerIn, Hand hand, Direction facing, double hitX, double hitY, double hitZ) {
        if (super.onActivated(playerIn, hand, facing, hitX, hitY, hitZ)) {
            return true;
        }
        this.openGui(playerIn);
        return true;
    }
}

