/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.block.tile;

import com.google.common.collect.Sets;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.api.IFactory;
import com.hrznstudio.titanium.block.BlockTileBase;
import com.hrznstudio.titanium.block.tile.TileActive;
import com.hrznstudio.titanium.energy.NBTEnergyHandler;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class TilePowered
extends TileActive {
    @Save
    private NBTEnergyHandler energyHandler = this.getEnergyHandlerFactory().create();
    private LazyOptional<IEnergyStorage> energyCap = LazyOptional.of(() -> this.energyHandler);

    public TilePowered(BlockTileBase blockTileBase) {
        super(blockTileBase);
    }

    protected IFactory<NBTEnergyHandler> getEnergyHandlerFactory() {
        return () -> new NBTEnergyHandler(this, 10000);
    }

    public NBTEnergyHandler getEnergyStorage() {
        return this.energyHandler;
    }

    public Set<Direction> getValidEnergyFaces() {
        return Sets.newHashSet((Object[])Direction.values());
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityEnergy.ENERGY) {
            return this.energyCap.cast();
        }
        return super.getCapability(cap, side);
    }
}

