/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.block.tile.fluid;

import com.hrznstudio.titanium.api.IFactory;
import com.hrznstudio.titanium.api.client.IGuiAddon;
import com.hrznstudio.titanium.api.client.IGuiAddonProvider;
import com.hrznstudio.titanium.block.tile.fluid.PosFluidTank;
import com.hrznstudio.titanium.block.tile.sideness.ICapabilityHolder;
import com.hrznstudio.titanium.block.tile.sideness.IFacingHandler;
import com.hrznstudio.titanium.util.FacingUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class MultiTankHandler
implements IGuiAddonProvider,
ICapabilityHolder<PosFluidTank, MultiTankCapabilityHandler> {
    private final LinkedHashSet<PosFluidTank> tanks = new LinkedHashSet();
    private final HashMap<FacingUtil.Sideness, LazyOptional<MultiTankCapabilityHandler>> lazyOptionals = new HashMap();

    public MultiTankHandler() {
        this.lazyOptionals.put(null, (LazyOptional<MultiTankCapabilityHandler>)LazyOptional.empty());
        for (FacingUtil.Sideness value : FacingUtil.Sideness.values()) {
            this.lazyOptionals.put(value, (LazyOptional<MultiTankCapabilityHandler>)LazyOptional.empty());
        }
    }

    @Override
    public void add(PosFluidTank tank) {
        this.tanks.add(tank);
        this.rebuildCapability(new FacingUtil.Sideness[]{null});
        this.rebuildCapability(FacingUtil.Sideness.values());
    }

    private void rebuildCapability(FacingUtil.Sideness[] sides) {
        for (FacingUtil.Sideness side : sides) {
            this.lazyOptionals.get((Object)side).invalidate();
            this.lazyOptionals.put(side, (LazyOptional<MultiTankCapabilityHandler>)LazyOptional.of(() -> new MultiTankCapabilityHandler(this.getHandlersForSide(side))));
        }
    }

    private List<PosFluidTank> getHandlersForSide(FacingUtil.Sideness sideness) {
        if (sideness == null) {
            return new ArrayList<PosFluidTank>(this.tanks);
        }
        ArrayList<PosFluidTank> handlers = new ArrayList<PosFluidTank>();
        for (PosFluidTank tankHandler : this.tanks) {
            if (tankHandler instanceof IFacingHandler) {
                if (!((IFacingHandler)((Object)tankHandler)).getFacingModes().containsKey((Object)sideness) || !((IFacingHandler)((Object)tankHandler)).getFacingModes().get((Object)sideness).allowsConnection()) continue;
                handlers.add(tankHandler);
                continue;
            }
            handlers.add(tankHandler);
        }
        return handlers;
    }

    @Override
    @Nonnull
    public LazyOptional<MultiTankCapabilityHandler> getCapabilityForSide(@Nullable FacingUtil.Sideness sideness) {
        return this.lazyOptionals.get((Object)sideness);
    }

    @Override
    public boolean handleFacingChange(String handlerName, FacingUtil.Sideness facing, IFacingHandler.FaceMode mode) {
        for (PosFluidTank tankHandler : this.tanks) {
            if (!tankHandler.getName().equals(handlerName) || !(tankHandler instanceof IFacingHandler)) continue;
            ((IFacingHandler)((Object)tankHandler)).getFacingModes().put(facing, mode);
            this.rebuildCapability(new FacingUtil.Sideness[]{facing});
            return true;
        }
        return false;
    }

    public HashSet<PosFluidTank> getTanks() {
        return this.tanks;
    }

    @Override
    public List<IFactory<? extends IGuiAddon>> getGuiAddons() {
        ArrayList<IFactory<? extends IGuiAddon>> addons = new ArrayList<IFactory<? extends IGuiAddon>>();
        for (PosFluidTank tank : this.tanks) {
            addons.addAll(tank.getGuiAddons());
        }
        return addons;
    }

    public static class MultiTankCapabilityHandler
    implements IFluidHandler {
        private final List<PosFluidTank> tanks;

        public MultiTankCapabilityHandler(List<PosFluidTank> tanks) {
            this.tanks = tanks;
        }

        public boolean isEmpty() {
            return this.tanks.isEmpty();
        }

        public int getTanks() {
            return this.tanks.size();
        }

        @Nonnull
        public FluidStack getFluidInTank(int tank) {
            return this.tanks.get(tank).getFluid();
        }

        public int getTankCapacity(int tank) {
            return this.tanks.get(tank).getTankCapacity(tank);
        }

        public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
            return this.tanks.get(tank).isFluidValid(stack);
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            for (PosFluidTank tank : this.tanks) {
                if (tank.fill(resource, IFluidHandler.FluidAction.SIMULATE) == 0) continue;
                return tank.fill(resource, action);
            }
            return 0;
        }

        @Nonnull
        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            for (PosFluidTank tank : this.tanks) {
                if (tank.drain(resource, IFluidHandler.FluidAction.SIMULATE).isEmpty()) continue;
                return tank.drain(resource, action);
            }
            return FluidStack.EMPTY;
        }

        @Nonnull
        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            for (PosFluidTank tank : this.tanks) {
                if (tank.drain(maxDrain, IFluidHandler.FluidAction.SIMULATE).isEmpty()) continue;
                return tank.drain(maxDrain, action);
            }
            return FluidStack.EMPTY;
        }
    }
}

