/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.block.tile.fluid;

import com.hrznstudio.titanium.api.IFactory;
import com.hrznstudio.titanium.api.client.AssetTypes;
import com.hrznstudio.titanium.api.client.IAssetType;
import com.hrznstudio.titanium.api.client.IGuiAddon;
import com.hrznstudio.titanium.api.client.IGuiAddonProvider;
import com.hrznstudio.titanium.block.tile.TileBase;
import com.hrznstudio.titanium.client.gui.addon.TankGuiAddon;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class PosFluidTank
extends FluidTank
implements IGuiAddonProvider {
    private final int posX;
    private final int posY;
    private String name;
    private TileEntity tile;
    private Type tankType;
    private Action tankAction;
    private Runnable onContentChange;

    public PosFluidTank(String name, int amount, int posX, int posY) {
        super(amount);
        this.posX = posX;
        this.posY = posY;
        this.name = name;
        this.tankType = Type.NORMAL;
        this.tankAction = Action.BOTH;
        this.onContentChange = () -> {};
    }

    public PosFluidTank setTile(TileEntity tile) {
        this.tile = tile;
        return this;
    }

    protected void onContentsChanged() {
        super.onContentsChanged();
        if (this.tile instanceof TileBase) {
            ((TileBase)this.tile).markForUpdate();
        } else {
            this.tile.func_70296_d();
        }
        this.onContentChange.run();
    }

    public String getName() {
        return this.name;
    }

    public int getPosX() {
        return this.posX;
    }

    public int getPosY() {
        return this.posY;
    }

    public Type getTankType() {
        return this.tankType;
    }

    public PosFluidTank setTankType(Type tankType) {
        this.tankType = tankType;
        return this;
    }

    public PosFluidTank setOnContentChange(Runnable onContentChange) {
        this.onContentChange = onContentChange;
        return this;
    }

    public Action getTankAction() {
        return this.tankAction;
    }

    public PosFluidTank setTankAction(Action tankAction) {
        this.tankAction = tankAction;
        return this;
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        return this.getTankAction().canFill() ? super.fill(resource, action) : 0;
    }

    @Nonnull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        return this.getTankAction().canDrain() ? this.drainInternal(resource, action) : FluidStack.EMPTY;
    }

    private FluidStack drainInternal(FluidStack resource, IFluidHandler.FluidAction action) {
        if (resource.isEmpty() || !resource.isFluidEqual(this.fluid)) {
            return FluidStack.EMPTY;
        }
        return this.drain(resource.getAmount(), action);
    }

    @Nonnull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        return this.getTankAction().canDrain() ? this.drainInternal(maxDrain, action) : FluidStack.EMPTY;
    }

    @Nonnull
    private FluidStack drainInternal(int maxDrain, IFluidHandler.FluidAction action) {
        int drained = maxDrain;
        if (this.fluid.getAmount() < drained) {
            drained = this.fluid.getAmount();
        }
        FluidStack stack = new FluidStack(this.fluid, drained);
        if (action.execute() && drained > 0) {
            this.fluid.shrink(drained);
            this.onContentsChanged();
        }
        return stack;
    }

    public int fillForced(FluidStack resource, IFluidHandler.FluidAction action) {
        return super.fill(resource, action);
    }

    @Nonnull
    public FluidStack drainForced(FluidStack resource, IFluidHandler.FluidAction action) {
        if (resource.isEmpty() || !resource.isFluidEqual(this.fluid)) {
            return FluidStack.EMPTY;
        }
        return this.drainForced(resource.getAmount(), action);
    }

    @Nonnull
    public FluidStack drainForced(int maxDrain, IFluidHandler.FluidAction action) {
        return this.drainInternal(maxDrain, action);
    }

    @Override
    public List<IFactory<? extends IGuiAddon>> getGuiAddons() {
        ArrayList<IFactory<? extends IGuiAddon>> addons = new ArrayList<IFactory<? extends IGuiAddon>>();
        addons.add(() -> new TankGuiAddon(this));
        return addons;
    }

    public static enum Action {
        FILL(true, false),
        DRAIN(false, true),
        BOTH(true, true),
        NONE(false, false);

        private final boolean fill;
        private final boolean drain;

        private Action(boolean fill, boolean drain) {
            this.fill = fill;
            this.drain = drain;
        }

        public boolean canFill() {
            return this.fill;
        }

        public boolean canDrain() {
            return this.drain;
        }
    }

    public static enum Type {
        NORMAL(AssetTypes.TANK_NORMAL),
        SMALL(AssetTypes.TANK_SMALL);

        private final IAssetType assetType;

        private Type(IAssetType assetType) {
            this.assetType = assetType;
        }

        public IAssetType getAssetType() {
            return this.assetType;
        }
    }
}

