/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.block.tile.fluid;

import com.hrznstudio.titanium.api.IFactory;
import com.hrznstudio.titanium.api.client.AssetTypes;
import com.hrznstudio.titanium.api.client.IAsset;
import com.hrznstudio.titanium.api.client.IGuiAddon;
import com.hrznstudio.titanium.api.client.IGuiAddonProvider;
import com.hrznstudio.titanium.block.tile.fluid.PosFluidTank;
import com.hrznstudio.titanium.block.tile.sideness.IFacingHandler;
import com.hrznstudio.titanium.block.tile.sideness.SidedHandlerManager;
import com.hrznstudio.titanium.client.gui.addon.FacingHandlerGuiAddon;
import com.hrznstudio.titanium.util.FacingUtil;
import java.awt.Color;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.item.DyeColor;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class SidedFluidTank
extends PosFluidTank
implements IFacingHandler,
IGuiAddonProvider {
    private int color = DyeColor.WHITE.func_196060_f();
    private int facingHandlerX = 8;
    private int facingHandlerY = 84;
    private HashMap<FacingUtil.Sideness, IFacingHandler.FaceMode> facingModes = new HashMap();
    private int pos;
    private boolean hasFacingAddon;

    public SidedFluidTank(String name, int amount, int posX, int posY, int pos) {
        super(name, amount, posX, posY);
        this.pos = pos;
        for (FacingUtil.Sideness facing : FacingUtil.Sideness.values()) {
            this.facingModes.put(facing, IFacingHandler.FaceMode.ENABLED);
        }
        this.hasFacingAddon = true;
    }

    public SidedFluidTank disableFacingAddon() {
        this.hasFacingAddon = false;
        return this;
    }

    @Override
    public HashMap<FacingUtil.Sideness, IFacingHandler.FaceMode> getFacingModes() {
        return this.facingModes;
    }

    @Override
    public int getColor() {
        return new Color(this.color).getRGB();
    }

    public SidedFluidTank setColor(int color) {
        this.color = color;
        return this;
    }

    public SidedFluidTank setColor(DyeColor color) {
        this.color = color.func_196060_f();
        return this;
    }

    @Override
    public Rectangle getRectangle(IAsset asset) {
        return new Rectangle(this.getPosX() - 2, this.getPosY() - 2, (int)asset.getArea().getWidth() + 3, (int)asset.getArea().getHeight() + 3);
    }

    @Override
    public int getFacingHandlerX() {
        return this.facingHandlerX;
    }

    @Override
    public int getFacingHandlerY() {
        return this.facingHandlerY;
    }

    @Override
    public boolean work(World world, BlockPos pos, Direction blockFacing, int workAmount) {
        AtomicBoolean hasWorked;
        TileEntity entity;
        Direction real;
        for (FacingUtil.Sideness sideness : this.facingModes.keySet()) {
            if (!this.facingModes.get((Object)sideness).equals((Object)IFacingHandler.FaceMode.PUSH)) continue;
            real = FacingUtil.getFacingFromSide(blockFacing, sideness);
            entity = world.func_175625_s(pos.func_177972_a(real));
            hasWorked = new AtomicBoolean(false);
            if (entity == null) continue;
            entity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, real.func_176734_d()).ifPresent(iFluidHandler -> hasWorked.set(this.transfer(sideness, (IFluidHandler)this, (IFluidHandler)iFluidHandler, workAmount)));
            if (!hasWorked.get()) continue;
            return true;
        }
        for (FacingUtil.Sideness sideness : this.facingModes.keySet()) {
            if (!this.facingModes.get((Object)sideness).equals((Object)IFacingHandler.FaceMode.PULL)) continue;
            real = FacingUtil.getFacingFromSide(blockFacing, sideness);
            entity = world.func_175625_s(pos.func_177972_a(real));
            hasWorked = new AtomicBoolean(false);
            if (entity == null) continue;
            entity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, real.func_176734_d()).ifPresent(iFluidHandler -> hasWorked.set(this.transfer(sideness, (IFluidHandler)iFluidHandler, (IFluidHandler)this, workAmount)));
            if (!hasWorked.get()) continue;
            return true;
        }
        return false;
    }

    @Override
    public SidedFluidTank setFacingHandlerPos(int x, int y) {
        this.facingHandlerX = x;
        this.facingHandlerY = y;
        return this;
    }

    private boolean transfer(FacingUtil.Sideness sideness, IFluidHandler from, IFluidHandler to, int workAmount) {
        FluidStack stack = from.drain(workAmount * 100, IFluidHandler.FluidAction.SIMULATE);
        if (!stack.isEmpty()) {
            return !(stack = from.drain(to.fill(stack, IFluidHandler.FluidAction.EXECUTE), IFluidHandler.FluidAction.EXECUTE)).isEmpty();
        }
        return false;
    }

    @Override
    public List<IFactory<? extends IGuiAddon>> getGuiAddons() {
        List<IFactory<? extends IGuiAddon>> addons = super.getGuiAddons();
        if (this.hasFacingAddon) {
            addons.add(() -> new FacingHandlerGuiAddon(SidedHandlerManager.ofRight(this.getFacingHandlerX(), this.getFacingHandlerY(), this.pos, AssetTypes.BUTTON_SIDENESS_MANAGER, 4), this, this.getTankType().getAssetType()));
        }
        return addons;
    }

    public FluidTank readFromNBT(CompoundNBT nbt) {
        if (nbt.func_74764_b("FacingModes")) {
            CompoundNBT compound = nbt.func_74775_l("FacingModes");
            for (String face : compound.func_150296_c()) {
                this.facingModes.put(FacingUtil.Sideness.valueOf(face), IFacingHandler.FaceMode.valueOf(compound.func_74779_i(face)));
            }
        }
        return super.readFromNBT(nbt);
    }

    public CompoundNBT writeToNBT(CompoundNBT comp) {
        CompoundNBT nbt = super.writeToNBT(comp);
        CompoundNBT compound = new CompoundNBT();
        for (FacingUtil.Sideness facing : this.facingModes.keySet()) {
            compound.func_74778_a(facing.name(), this.facingModes.get((Object)facing).name());
        }
        nbt.func_218657_a("FacingModes", (INBT)compound);
        return nbt;
    }
}

