/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.block.tile.inventory;

import com.hrznstudio.titanium.api.IFactory;
import com.hrznstudio.titanium.api.client.IGuiAddon;
import com.hrznstudio.titanium.api.client.IGuiAddonProvider;
import com.hrznstudio.titanium.block.tile.inventory.PosInvHandler;
import com.hrznstudio.titanium.block.tile.sideness.ICapabilityHolder;
import com.hrznstudio.titanium.block.tile.sideness.IFacingHandler;
import com.hrznstudio.titanium.util.FacingUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.ItemStackHandler;

public class MultiInventoryHandler
implements IGuiAddonProvider,
ICapabilityHolder<PosInvHandler, MultiInvCapabilityHandler> {
    private final LinkedHashSet<PosInvHandler> inventoryHandlers = new LinkedHashSet();
    private final HashMap<FacingUtil.Sideness, LazyOptional<MultiInvCapabilityHandler>> lazyOptionals = new HashMap();

    public MultiInventoryHandler() {
        this.lazyOptionals.put(null, (LazyOptional<MultiInvCapabilityHandler>)LazyOptional.empty());
        for (FacingUtil.Sideness value : FacingUtil.Sideness.values()) {
            this.lazyOptionals.put(value, (LazyOptional<MultiInvCapabilityHandler>)LazyOptional.empty());
        }
    }

    @Override
    public void add(PosInvHandler invHandler) {
        this.inventoryHandlers.add(invHandler);
        this.rebuildCapability(new FacingUtil.Sideness[]{null});
        this.rebuildCapability(FacingUtil.Sideness.values());
    }

    private void rebuildCapability(FacingUtil.Sideness[] sides) {
        for (FacingUtil.Sideness side : sides) {
            this.lazyOptionals.get((Object)side).invalidate();
            this.lazyOptionals.put(side, (LazyOptional<MultiInvCapabilityHandler>)LazyOptional.of(() -> new MultiInvCapabilityHandler(this.getHandlersForSide(side))));
        }
    }

    private List<PosInvHandler> getHandlersForSide(FacingUtil.Sideness sideness) {
        if (sideness == null) {
            return new ArrayList<PosInvHandler>(this.inventoryHandlers);
        }
        ArrayList<PosInvHandler> handlers = new ArrayList<PosInvHandler>();
        for (PosInvHandler inventoryHandler : this.inventoryHandlers) {
            if (inventoryHandler instanceof IFacingHandler) {
                if (!((IFacingHandler)((Object)inventoryHandler)).getFacingModes().containsKey((Object)sideness) || !((IFacingHandler)((Object)inventoryHandler)).getFacingModes().get((Object)sideness).allowsConnection()) continue;
                handlers.add(inventoryHandler);
                continue;
            }
            handlers.add(inventoryHandler);
        }
        return handlers;
    }

    @Override
    @Nonnull
    public LazyOptional<MultiInvCapabilityHandler> getCapabilityForSide(FacingUtil.Sideness sideness) {
        return this.lazyOptionals.get((Object)sideness);
    }

    @Override
    public boolean handleFacingChange(String handlerName, FacingUtil.Sideness facing, IFacingHandler.FaceMode mode) {
        for (PosInvHandler inventoryHandler : this.inventoryHandlers) {
            if (!inventoryHandler.getName().equals(handlerName) || !(inventoryHandler instanceof IFacingHandler)) continue;
            ((IFacingHandler)((Object)inventoryHandler)).getFacingModes().put(facing, mode);
            this.rebuildCapability(new FacingUtil.Sideness[]{facing});
            return true;
        }
        return false;
    }

    public HashSet<PosInvHandler> getInventoryHandlers() {
        return this.inventoryHandlers;
    }

    @Override
    public List<IFactory<? extends IGuiAddon>> getGuiAddons() {
        ArrayList<IFactory<? extends IGuiAddon>> addons = new ArrayList<IFactory<? extends IGuiAddon>>();
        this.inventoryHandlers.forEach(posInvHandler -> addons.addAll(posInvHandler.getGuiAddons()));
        return addons;
    }

    public static class MultiInvCapabilityHandler
    extends ItemStackHandler {
        private final List<PosInvHandler> inventoryHandlers;
        private int slotAmount;

        public MultiInvCapabilityHandler(List<PosInvHandler> inventoryHandlers) {
            this.inventoryHandlers = inventoryHandlers;
            this.slotAmount = 0;
            for (PosInvHandler inventoryHandler : this.inventoryHandlers) {
                this.slotAmount += inventoryHandler.getSlots();
            }
        }

        public int getSlots() {
            return this.slotAmount;
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            PosInvHandler handler = this.getFromSlot(slot);
            if (handler != null) {
                if (handler.getInsertPredicate().test(stack, slot)) {
                    return handler.insertItem(this.getRelativeSlot(handler, slot), stack, simulate);
                }
                return stack;
            }
            return super.insertItem(slot, stack, simulate);
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            PosInvHandler handler = this.getFromSlot(slot);
            if (handler != null) {
                int relativeSlot = this.getRelativeSlot(handler, slot);
                if (!handler.getExtractPredicate().test(handler.getStackInSlot(relativeSlot), relativeSlot)) {
                    return ItemStack.field_190927_a;
                }
                return handler.extractItem(relativeSlot, amount, simulate);
            }
            return super.extractItem(slot, amount, simulate);
        }

        @Nonnull
        public ItemStack getStackInSlot(int slot) {
            PosInvHandler handler = this.getFromSlot(slot);
            if (handler != null) {
                return handler.getStackInSlot(this.getRelativeSlot(handler, slot));
            }
            return super.getStackInSlot(slot);
        }

        public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
            PosInvHandler handler = this.getFromSlot(slot);
            if (handler != null) {
                handler.setStackInSlot(this.getRelativeSlot(handler, slot), stack);
            }
            super.setStackInSlot(slot, stack);
        }

        protected void validateSlotIndex(int slot) {
            if (slot < 0 || slot >= this.slotAmount) {
                throw new RuntimeException("Slot " + slot + " not in valid range - [0," + this.slotAmount + ")");
            }
        }

        public PosInvHandler getFromSlot(int slot) {
            for (PosInvHandler handler : this.inventoryHandlers) {
                if ((slot -= handler.getSlots()) >= 0) continue;
                return handler;
            }
            return null;
        }

        public int getRelativeSlot(PosInvHandler handler, int slot) {
            for (PosInvHandler h : this.inventoryHandlers) {
                if (h.equals(handler)) {
                    return slot;
                }
                slot -= h.getSlots();
            }
            return 0;
        }
    }
}

