/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.module;

import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.hrznstudio.titanium.annotation.config.ConfigFile;
import com.hrznstudio.titanium.config.AnnotationConfigManager;
import com.hrznstudio.titanium.event.handler.EventManager;
import com.hrznstudio.titanium.module.Module;
import com.hrznstudio.titanium.util.AnnotationUtil;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.GatherDataEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public abstract class ModuleController {
    private final String modid;
    private final Map<String, Module> moduleMap = new HashMap<String, Module>();
    private final Map<String, Module> disabledModuleMap = new HashMap<String, Module>();
    private final AnnotationConfigManager configManager = new AnnotationConfigManager();

    public ModuleController() {
        this.modid = ModLoadingContext.get().getActiveContainer().getModId();
        this.onPreInit();
        this.onInit();
        this.onPostInit();
    }

    private void addConfig(AnnotationConfigManager.Type type) {
        for (Class configClass : type.getConfigClass()) {
            if (!this.configManager.isClassManaged(configClass)) continue;
            return;
        }
        this.configManager.add(type);
    }

    public void onPreInit() {
    }

    public void onInit() {
        this.initModules();
        if (!this.moduleMap.isEmpty()) {
            File modulesConfig = new File("config/" + this.modid + "/modules.toml");
            if (!modulesConfig.exists()) {
                modulesConfig.getParentFile().mkdirs();
            }
            CommentedFileConfig config = CommentedFileConfig.of((File)modulesConfig);
            config.load();
            new HashMap<String, Module>(this.moduleMap).forEach((id, m) -> {
                if (!m.isForced()) {
                    boolean active;
                    String cm = "modules." + id;
                    String c = cm + ".enabled";
                    config.setComment(cm, m.getDescription());
                    boolean bl = active = config.add(c, (Object)m.isEnabledByDefault()) ? m.isEnabledByDefault() : ((Boolean)config.getOrElse(c, (Object)m.isEnabledByDefault())).booleanValue();
                    if (active) {
                        m.initConfig(config);
                    } else {
                        this.disabledModuleMap.put((String)id, this.moduleMap.remove(id));
                    }
                } else {
                    m.initConfig(config);
                }
            });
            config.save();
            config.close();
        }
        EventManager.mod(RegistryEvent.Register.class).process(event -> this.moduleMap.values().forEach(m -> {
            List<IForgeRegistryEntry> l = m.getEntries((Class)event.getGenericType());
            if (!l.isEmpty()) {
                l.forEach(arg_0 -> ((IForgeRegistry)event.getRegistry()).register(arg_0));
            }
        })).subscribe();
    }

    public void onPostInit() {
        AnnotationUtil.getFilteredAnnotatedClasses(ConfigFile.class, this.modid).forEach(aClass -> {
            ConfigFile annotation = aClass.getAnnotation(ConfigFile.class);
            this.addConfig(AnnotationConfigManager.Type.of(annotation.type(), aClass).setName(annotation.value()));
        });
        EventManager.mod(ModConfig.Loading.class).process(ev -> this.configManager.inject()).subscribe();
        EventManager.mod(ModConfig.ConfigReloading.class).process(ev -> this.configManager.inject()).subscribe();
        EventManager.mod(GatherDataEvent.class).process(this::addDataProvider).subscribe();
    }

    protected abstract void initModules();

    public void addModule(Module module) {
        this.moduleMap.put(module.getId(), module);
    }

    public void addModule(Module.Builder builder) {
        this.addModule(builder.build());
    }

    public void addDataProvider(GatherDataEvent event) {
    }
}

