/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.network;

import com.hrznstudio.titanium.network.locator.LocatorFactory;
import com.hrznstudio.titanium.network.locator.LocatorInstance;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Date;
import java.util.HashMap;
import java.util.UUID;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Pair;

public class CompoundSerializableDataHandler {
    private static final HashMap<Class, Pair<Reader, Writer>> FIELD_SERIALIZER = new HashMap();

    public static <T> void map(Class<T> type, Reader<T> reader, Writer<T> writer) {
        FIELD_SERIALIZER.put(type, (Pair<Reader, Writer>)Pair.of(reader, writer));
    }

    private static long[] readLongArray(PacketBuffer buf) {
        return buf.func_186873_b(new long[0]);
    }

    private static String readString(PacketBuffer buf) {
        return buf.func_150789_c(Short.MAX_VALUE);
    }

    private static FluidStack readFluidStack(PacketBuffer buf) throws IOException {
        return FluidStack.loadFluidStackFromNBT((CompoundNBT)buf.func_150793_b());
    }

    private static void writeFluidStack(PacketBuffer buf, FluidStack stack) {
        buf.func_150786_a(stack.writeToNBT(new CompoundNBT()));
    }

    private static void writeUpdatePacket(PacketBuffer buf, SUpdateTileEntityPacket packet) {
        try {
            packet.func_148840_b(buf);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static SUpdateTileEntityPacket readUpdatePacket(PacketBuffer buf) {
        SUpdateTileEntityPacket packet = new SUpdateTileEntityPacket();
        try {
            packet.func_148840_b(buf);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return packet;
    }

    private static Pair<Reader, Writer> getHandler(Class<?> clazz) {
        Pair<Reader, Writer> pair = FIELD_SERIALIZER.get(clazz);
        if (pair == null) {
            throw new RuntimeException("No R/W handler for  " + clazz);
        }
        return pair;
    }

    public static void writeField(Field f, Class clazz, PacketBuffer buf, Object instance) throws IllegalArgumentException, IllegalAccessException {
        Pair<Reader, Writer> handler = CompoundSerializableDataHandler.getHandler(clazz);
        ((Writer)handler.getRight()).write(buf, f.get(instance));
    }

    public static void readField(Field f, Class clazz, PacketBuffer buf, Object instance) throws IllegalArgumentException, IllegalAccessException, IOException {
        Pair<Reader, Writer> handler = CompoundSerializableDataHandler.getHandler(clazz);
        f.set(instance, ((Reader)handler.getLeft()).read(buf));
    }

    public static boolean acceptField(Field f, Class<?> type) {
        int mods = f.getModifiers();
        return !Modifier.isFinal(mods) && !Modifier.isStatic(mods) && !Modifier.isTransient(mods) && FIELD_SERIALIZER.containsKey(type);
    }

    static {
        CompoundSerializableDataHandler.map(Byte.TYPE, PacketBuffer::readByte, PacketBuffer::writeByte);
        CompoundSerializableDataHandler.map(Short.TYPE, PacketBuffer::readShort, PacketBuffer::writeShort);
        CompoundSerializableDataHandler.map(Integer.TYPE, PacketBuffer::func_150792_a, PacketBuffer::func_150787_b);
        CompoundSerializableDataHandler.map(Long.TYPE, PacketBuffer::func_179260_f, PacketBuffer::func_179254_b);
        CompoundSerializableDataHandler.map(Float.TYPE, PacketBuffer::readFloat, PacketBuffer::writeFloat);
        CompoundSerializableDataHandler.map(Double.TYPE, PacketBuffer::readDouble, PacketBuffer::writeDouble);
        CompoundSerializableDataHandler.map(Boolean.TYPE, PacketBuffer::readBoolean, PacketBuffer::writeBoolean);
        CompoundSerializableDataHandler.map(Character.TYPE, PacketBuffer::readChar, PacketBuffer::writeChar);
        CompoundSerializableDataHandler.map(Byte.class, PacketBuffer::readByte, PacketBuffer::writeByte);
        CompoundSerializableDataHandler.map(Short.class, PacketBuffer::readShort, PacketBuffer::writeShort);
        CompoundSerializableDataHandler.map(Integer.class, PacketBuffer::func_150792_a, PacketBuffer::func_150787_b);
        CompoundSerializableDataHandler.map(Long.class, PacketBuffer::func_179260_f, PacketBuffer::func_179254_b);
        CompoundSerializableDataHandler.map(Float.class, PacketBuffer::readFloat, PacketBuffer::writeFloat);
        CompoundSerializableDataHandler.map(Double.class, PacketBuffer::readDouble, PacketBuffer::writeDouble);
        CompoundSerializableDataHandler.map(Boolean.class, PacketBuffer::readBoolean, PacketBuffer::writeBoolean);
        CompoundSerializableDataHandler.map(Character.class, PacketBuffer::readChar, PacketBuffer::writeChar);
        CompoundSerializableDataHandler.map(byte[].class, PacketBuffer::func_179251_a, PacketBuffer::func_179250_a);
        CompoundSerializableDataHandler.map(int[].class, PacketBuffer::func_186863_b, PacketBuffer::func_186875_a);
        CompoundSerializableDataHandler.map(long[].class, CompoundSerializableDataHandler::readLongArray, PacketBuffer::func_186865_a);
        CompoundSerializableDataHandler.map(String.class, CompoundSerializableDataHandler::readString, PacketBuffer::func_180714_a);
        CompoundSerializableDataHandler.map(CompoundNBT.class, PacketBuffer::func_150793_b, PacketBuffer::func_150786_a);
        CompoundSerializableDataHandler.map(ItemStack.class, PacketBuffer::func_150791_c, PacketBuffer::func_150788_a);
        CompoundSerializableDataHandler.map(FluidStack.class, CompoundSerializableDataHandler::readFluidStack, CompoundSerializableDataHandler::writeFluidStack);
        CompoundSerializableDataHandler.map(BlockPos.class, PacketBuffer::func_179259_c, PacketBuffer::func_179255_a);
        CompoundSerializableDataHandler.map(ITextComponent.class, PacketBuffer::func_179258_d, PacketBuffer::func_179256_a);
        CompoundSerializableDataHandler.map(Date.class, PacketBuffer::func_192573_m, PacketBuffer::func_192574_a);
        CompoundSerializableDataHandler.map(UUID.class, PacketBuffer::func_179253_g, PacketBuffer::func_179252_a);
        CompoundSerializableDataHandler.map(SUpdateTileEntityPacket.class, CompoundSerializableDataHandler::readUpdatePacket, CompoundSerializableDataHandler::writeUpdatePacket);
        CompoundSerializableDataHandler.map(LocatorInstance.class, LocatorFactory::readPacketBuffer, LocatorFactory::writePacketBuffer);
    }

    public static interface Reader<T> {
        public T read(PacketBuffer var1) throws IOException;
    }

    public static interface Writer<T> {
        public void write(PacketBuffer var1, T var2);
    }
}

