/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.network.locator;

import com.hrznstudio.titanium.network.CompoundSerializableDataHandler;
import com.hrznstudio.titanium.network.locator.LocatorType;
import java.lang.reflect.Field;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;

public abstract class LocatorInstance {
    private final LocatorType type;

    protected LocatorInstance(@Nonnull LocatorType type) {
        this.type = type;
    }

    @Nonnull
    public LocatorType getType() {
        return this.type;
    }

    public abstract Optional<?> locale(PlayerEntity var1);

    public final void fromBytes(PacketBuffer buf) {
        try {
            Class<?> clazz = this.getClass();
            for (Field f : clazz.getDeclaredFields()) {
                Class<?> type;
                if (!f.isAccessible()) {
                    f.setAccessible(true);
                }
                if (!CompoundSerializableDataHandler.acceptField(f, type = f.getType())) continue;
                CompoundSerializableDataHandler.readField(f, type, buf, this);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error at reading packet " + this, e);
        }
    }

    public final void toBytes(PacketBuffer buf) {
        try {
            Class<?> clazz = this.getClass();
            for (Field f : clazz.getDeclaredFields()) {
                Class<?> type;
                if (!f.isAccessible()) {
                    f.setAccessible(true);
                }
                if (!CompoundSerializableDataHandler.acceptField(f, type = f.getType())) continue;
                CompoundSerializableDataHandler.writeField(f, type, buf, this);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error at writing packet " + this, e);
        }
    }
}

