/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.recipe.serializer;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.hrznstudio.titanium.network.CompoundSerializableDataHandler;
import com.hrznstudio.titanium.recipe.serializer.IRecipeSerializerReversed;
import com.hrznstudio.titanium.recipe.serializer.JSONSerializableDataHandler;
import com.hrznstudio.titanium.recipe.serializer.SerializableRecipe;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class GenericSerializer<T extends SerializableRecipe>
extends ForgeRegistryEntry<IRecipeSerializer<?>>
implements IRecipeSerializer<T>,
IRecipeSerializerReversed<T> {
    private final Class<T> recipeClass;
    private IRecipeType<T> recipeType;

    public GenericSerializer(ResourceLocation resourceLocation, Class<T> recipeClass) {
        this.recipeClass = recipeClass;
        this.recipeType = IRecipeType.func_222147_a((String)resourceLocation.toString());
        this.setRegistryName(resourceLocation);
    }

    public T read(ResourceLocation recipeId, JsonObject json) {
        try {
            SerializableRecipe recipe = (SerializableRecipe)this.recipeClass.getConstructor(ResourceLocation.class).newInstance(recipeId);
            for (Map.Entry entry : json.entrySet()) {
                if (!this.fieldExists((String)entry.getKey()) || !JSONSerializableDataHandler.acceptField(this.recipeClass.getField((String)entry.getKey()), this.recipeClass.getField((String)entry.getKey()).getType())) continue;
                this.recipeClass.getField((String)entry.getKey()).set(recipe, JSONSerializableDataHandler.read(this.recipeClass.getField((String)entry.getKey()).getType(), (JsonElement)entry.getValue()));
            }
            return (T)recipe;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public JsonObject write(T recipe) {
        JsonObject object = new JsonObject();
        for (Field field : this.recipeClass.getFields()) {
            if (!JSONSerializableDataHandler.acceptField(field, field.getType())) continue;
            try {
                object.add(field.getName(), JSONSerializableDataHandler.write(field.getType(), field.get(recipe)));
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return object;
    }

    public T read(ResourceLocation recipeId, PacketBuffer buffer) {
        try {
            SerializableRecipe recipe = (SerializableRecipe)this.recipeClass.getConstructor(ResourceLocation.class).newInstance(recipeId);
            for (Field field : this.recipeClass.getFields()) {
                if (!CompoundSerializableDataHandler.acceptField(field, this.recipeClass)) continue;
                CompoundSerializableDataHandler.readField(field, field.getType(), buffer, recipe);
            }
            return (T)recipe;
        }
        catch (IOException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void write(PacketBuffer buffer, T recipe) {
        for (Field field : this.recipeClass.getFields()) {
            if (!CompoundSerializableDataHandler.acceptField(field, this.recipeClass)) continue;
            try {
                CompoundSerializableDataHandler.writeField(field, field.getType(), buffer, recipe);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    public IRecipeType<T> getRecipeType() {
        return this.recipeType;
    }

    private boolean fieldExists(String field) {
        for (Field recipeClassField : this.recipeClass.getFields()) {
            if (!recipeClassField.getName().equalsIgnoreCase(field)) continue;
            return true;
        }
        return false;
    }
}

