/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium;

import com.hrznstudio.titanium.TitaniumClient;
import com.hrznstudio.titanium._impl.creative.CreativeFEGeneratorBlock;
import com.hrznstudio.titanium._impl.test.AssetTestBlock;
import com.hrznstudio.titanium._impl.test.MachineTestBlock;
import com.hrznstudio.titanium._impl.test.TestBlock;
import com.hrznstudio.titanium._impl.test.TwentyFourTestBlock;
import com.hrznstudio.titanium._impl.test.recipe.TestSerializableRecipe;
import com.hrznstudio.titanium.block.tile.ActiveTile;
import com.hrznstudio.titanium.client.screen.container.BasicTileContainerScreen;
import com.hrznstudio.titanium.command.RewardCommand;
import com.hrznstudio.titanium.command.RewardGrantCommand;
import com.hrznstudio.titanium.container.impl.BasicTileContainer;
import com.hrznstudio.titanium.event.custom.ResourceRegistrationEvent;
import com.hrznstudio.titanium.event.handler.EventManager;
import com.hrznstudio.titanium.material.ResourceRegistry;
import com.hrznstudio.titanium.material.ResourceType;
import com.hrznstudio.titanium.material.ResourceTypeProperties;
import com.hrznstudio.titanium.module.Feature;
import com.hrznstudio.titanium.module.Module;
import com.hrznstudio.titanium.module.ModuleController;
import com.hrznstudio.titanium.network.NetworkHandler;
import com.hrznstudio.titanium.network.locator.LocatorTypes;
import com.hrznstudio.titanium.network.messages.ButtonClickNetworkMessage;
import com.hrznstudio.titanium.recipe.generator.BlockItemModelGeneratorProvider;
import com.hrznstudio.titanium.recipe.generator.titanium.DefaultLootTableProvider;
import com.hrznstudio.titanium.recipe.generator.titanium.JsonRecipeSerializerProvider;
import com.hrznstudio.titanium.recipe.generator.titanium.ResourceRegistryProvider;
import com.hrznstudio.titanium.reward.Reward;
import com.hrznstudio.titanium.reward.RewardManager;
import com.hrznstudio.titanium.reward.RewardSyncMessage;
import com.hrznstudio.titanium.reward.storage.RewardWorldStorage;
import com.hrznstudio.titanium.util.SidedHandler;
import com.mojang.brigadier.CommandDispatcher;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.command.CommandSource;
import net.minecraft.data.IDataProvider;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.DrawHighlightEvent;
import net.minecraftforge.common.extensions.IForgeContainerType;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.GatherDataEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="titanium")
public class Titanium
extends ModuleController {
    public static final String MODID = "titanium";
    public static final Logger LOGGER = LogManager.getLogger((String)"titanium");
    public static NetworkHandler NETWORK = new NetworkHandler("titanium");

    public Titanium() {
        NETWORK.registerMessage(ButtonClickNetworkMessage.class);
        NETWORK.registerMessage(RewardSyncMessage.class);
        SidedHandler.runOn(Dist.CLIENT, () -> () -> EventManager.mod(FMLClientSetupEvent.class).process(this::clientSetup).subscribe());
        EventManager.mod(FMLCommonSetupEvent.class).process(this::commonSetup).subscribe();
        EventManager.forge(PlayerEvent.PlayerLoggedInEvent.class).process(this::onPlayerLoggedIn).subscribe();
        EventManager.forge(FMLServerStartingEvent.class).process(this::onServerStart).subscribe();
    }

    public static void openGui(ActiveTile tile, ServerPlayerEntity player) {
        NetworkHooks.openGui((ServerPlayerEntity)player, (INamedContainerProvider)tile, (BlockPos)tile.func_174877_v());
    }

    @Override
    public void onPreInit() {
        super.onPreInit();
        EventManager.mod(ResourceRegistrationEvent.class).process(event -> {
            ResourceTypeProperties.DEFAULTS.put(Block.class, new ResourceTypeProperties<Block.Properties>(Block.Properties.func_200950_a((Block)Blocks.field_150366_p)));
            ResourceTypeProperties.DEFAULTS.put(Item.class, new ResourceTypeProperties<Item.Properties>(new Item.Properties().func_200916_a((ItemGroup)ResourceRegistry.RESOURCES)));
            event.get("iron").setColor(0xD8D8D8).withOverride(ResourceType.ORE, (ForgeRegistryEntry)Blocks.field_150366_p).withOverride(ResourceType.METAL_BLOCK, (ForgeRegistryEntry)Blocks.field_150339_S).withOverride(ResourceType.INGOT, (ForgeRegistryEntry)Items.field_151042_j).withOverride(ResourceType.NUGGET, (ForgeRegistryEntry)Items.field_191525_da);
            event.get("gold").setColor(16438858).withOverride(ResourceType.ORE, (ForgeRegistryEntry)Blocks.field_150352_o).withOverride(ResourceType.METAL_BLOCK, (ForgeRegistryEntry)Blocks.field_150340_R).withOverride(ResourceType.INGOT, (ForgeRegistryEntry)Items.field_151043_k).withOverride(ResourceType.NUGGET, (ForgeRegistryEntry)Items.field_151074_bl);
            event.get("coal").setColor(0x363636).withOverride(ResourceType.ORE, (ForgeRegistryEntry)Blocks.field_150365_q).withOverride(ResourceType.GEM_BLOCK, (ForgeRegistryEntry)Blocks.field_150402_ci).withOverride(ResourceType.GEM, (ForgeRegistryEntry)Items.field_151044_h);
            event.get("lapis_lazuli").setColor(3432131).withOverride(ResourceType.ORE, (ForgeRegistryEntry)Blocks.field_150369_x).withOverride(ResourceType.GEM_BLOCK, (ForgeRegistryEntry)Blocks.field_150368_y).withOverride(ResourceType.GEM, (ForgeRegistryEntry)Items.field_196128_bn);
            event.get("diamond").setColor(4910553).withOverride(ResourceType.ORE, (ForgeRegistryEntry)Blocks.field_150482_ag).withOverride(ResourceType.GEM_BLOCK, (ForgeRegistryEntry)Blocks.field_150484_ah).withOverride(ResourceType.GEM, (ForgeRegistryEntry)Items.field_151045_i);
            event.get("redstone").setColor(11144961).withOverride(ResourceType.ORE, (ForgeRegistryEntry)Blocks.field_150450_ax).withOverride(ResourceType.GEM_BLOCK, (ForgeRegistryEntry)Blocks.field_150451_bX).withOverride(ResourceType.DUST, (ForgeRegistryEntry)Items.field_151137_ax);
            event.get("emerald").setColor(1564002).withOverride(ResourceType.ORE, (ForgeRegistryEntry)Blocks.field_150412_bA).withOverride(ResourceType.GEM_BLOCK, (ForgeRegistryEntry)Blocks.field_150475_bE).withOverride(ResourceType.GEM, (ForgeRegistryEntry)Items.field_151166_bC);
            event.get("nether_quartz").setColor(14537926).withOverride(ResourceType.NETHER_ORE, (ForgeRegistryEntry)Blocks.field_196766_fg).withOverride(ResourceType.GEM_BLOCK, (ForgeRegistryEntry)Blocks.field_150371_ca).withOverride(ResourceType.GEM, (ForgeRegistryEntry)Items.field_151128_bU);
            event.get("glowstone").setColor(16759902).withOverride(ResourceType.GEM_BLOCK, (ForgeRegistryEntry)Blocks.field_150426_aN).withOverride(ResourceType.DUST, (ForgeRegistryEntry)Items.field_151114_aO);
        }).subscribe();
    }

    @Override
    public void onInit() {
        ResourceRegistry.onInit();
        super.onInit();
    }

    @Override
    protected void initModules() {
        this.addModule(Module.builder("core").force().feature((Feature.Builder)Feature.builder("core").force().content(ContainerType.class, (IForgeRegistryEntry)((ContainerType)IForgeContainerType.create(BasicTileContainer::new).setRegistryName(new ResourceLocation(MODID, "tile_container"))))));
        TestBlock.TEST = new TestBlock();
        TwentyFourTestBlock.TEST = new TwentyFourTestBlock();
        AssetTestBlock.TEST = new AssetTestBlock();
        MachineTestBlock.TEST = new MachineTestBlock();
        this.addModule(Module.builder("test_module").disableByDefault().description("Test module for titanium features").feature((Feature.Builder)((Feature.Builder)((Feature.Builder)((Feature.Builder)Feature.builder("blocks").description("Adds test titanium blocks").content(Block.class, (IForgeRegistryEntry)TestBlock.TEST)).content(Block.class, (IForgeRegistryEntry)TwentyFourTestBlock.TEST)).content(Block.class, (IForgeRegistryEntry)AssetTestBlock.TEST)).content(Block.class, (IForgeRegistryEntry)MachineTestBlock.TEST)).feature(Feature.builder("events").description("Adds test titanium events").event(EventManager.forge(EntityItemPickupEvent.class).filter(ev -> ev.getItem().func_92059_d().func_77973_b() == Items.field_151055_y).process(ev -> {
            ev.getItem().lifespan = 0;
        }).cancel())).feature(((Feature.Builder)Feature.builder("recipe").description("Testing of recipe stuff").content(IRecipeSerializer.class, (IForgeRegistryEntry)TestSerializableRecipe.SERIALIZER)).event(EventManager.mod(FMLCommonSetupEvent.class).process(event -> {
            IRecipeType cfr_ignored_0 = (IRecipeType)Registry.func_218322_a((Registry)Registry.field_218367_H, (ResourceLocation)TestSerializableRecipe.SERIALIZER.getRegistryName(), TestSerializableRecipe.SERIALIZER.getRecipeType());
        })).event(EventManager.forge(PlayerInteractEvent.LeftClickBlock.class).filter(leftClickBlock -> !leftClickBlock.getWorld().field_72995_K && leftClickBlock.getPlayer() != null).process(leftClickBlock -> {
            Map recipes = (Map)ObfuscationReflectionHelper.getPrivateValue(RecipeManager.class, (Object)leftClickBlock.getWorld().func_199532_z(), (String)"field_199522_d");
            ((Map)recipes.get(TestSerializableRecipe.SERIALIZER.getRecipeType())).values().stream().map(iRecipe -> (TestSerializableRecipe)iRecipe).filter(testSerializableRecipe -> testSerializableRecipe.isValid(leftClickBlock.getPlayer().func_184586_b(leftClickBlock.getHand()), leftClickBlock.getWorld().func_180495_p(leftClickBlock.getPos()).func_177230_c())).findFirst().ifPresent(testSerializableRecipe -> {
                leftClickBlock.getPlayer().func_184586_b(leftClickBlock.getHand()).func_190918_g(1);
                ItemHandlerHelper.giveItemToPlayer((PlayerEntity)leftClickBlock.getPlayer(), (ItemStack)testSerializableRecipe.func_77571_b().func_77946_l());
                leftClickBlock.setCanceled(true);
            });
        }))));
        this.addModule(Module.builder("creative").disableByDefault().description("Creative features").feature((Feature.Builder)Feature.builder("blocks").description("Adds creative machine features").content(Block.class, (IForgeRegistryEntry)CreativeFEGeneratorBlock.INSTANCE)));
        ResourceRegistry.initModules(this);
    }

    @Override
    public void onPostInit() {
        super.onPostInit();
        ResourceRegistry.onPostInit();
    }

    @Override
    public void addDataProvider(GatherDataEvent event) {
        event.getGenerator().func_200390_a((IDataProvider)new BlockItemModelGeneratorProvider(event.getGenerator(), MODID));
        event.getGenerator().func_200390_a((IDataProvider)new DefaultLootTableProvider(event.getGenerator(), MODID));
        event.getGenerator().func_200390_a((IDataProvider)new JsonRecipeSerializerProvider(event.getGenerator(), MODID));
        event.getGenerator().func_200390_a((IDataProvider)new ResourceRegistryProvider(event.getGenerator()));
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        RewardManager.get().getRewards().values().forEach(rewardGiver -> rewardGiver.getRewards().forEach(reward -> reward.register(Dist.DEDICATED_SERVER)));
        LocatorTypes.register();
    }

    @OnlyIn(value=Dist.CLIENT)
    private void clientSetup(FMLClientSetupEvent event) {
        EventManager.forge(DrawHighlightEvent.HighlightBlock.class).process(TitaniumClient::blockOverlayEvent).subscribe();
        TitaniumClient.registerModelLoader();
        RewardManager.get().getRewards().values().forEach(rewardGiver -> rewardGiver.getRewards().forEach(reward -> reward.register(Dist.CLIENT)));
        ScreenManager.func_216911_a(BasicTileContainer.TYPE, BasicTileContainerScreen::new);
    }

    private void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        event.getPlayer().func_184102_h().execute(() -> {
            RewardWorldStorage storage = RewardWorldStorage.get(event.getPlayer().func_184102_h().func_71218_a(DimensionType.field_223227_a_));
            if (!storage.getConfiguredPlayers().contains(event.getPlayer().func_110124_au())) {
                for (ResourceLocation collectRewardsResourceLocation : RewardManager.get().collectRewardsResourceLocations(event.getPlayer().func_110124_au())) {
                    Reward reward = RewardManager.get().getReward(collectRewardsResourceLocation);
                    storage.add(event.getPlayer().func_110124_au(), reward.getResourceLocation(), reward.getOptions()[0]);
                }
                storage.getConfiguredPlayers().add(event.getPlayer().func_110124_au());
                storage.func_76185_a();
            }
            CompoundNBT nbt = storage.serializeSimple();
            event.getPlayer().func_184102_h().func_184103_al().func_181057_v().forEach(serverPlayerEntity -> NETWORK.get().sendTo((Object)new RewardSyncMessage(nbt), serverPlayerEntity.field_71135_a.field_147371_a, NetworkDirection.PLAY_TO_CLIENT));
        });
    }

    private void onServerStart(FMLServerStartingEvent event) {
        RewardCommand.register((CommandDispatcher<CommandSource>)event.getCommandDispatcher());
        RewardGrantCommand.register((CommandDispatcher<CommandSource>)event.getCommandDispatcher());
    }
}

