/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.component.progress;

import com.hrznstudio.titanium.api.IFactory;
import com.hrznstudio.titanium.api.client.IScreenAddon;
import com.hrznstudio.titanium.api.client.IScreenAddonProvider;
import com.hrznstudio.titanium.component.IComponentHarness;
import com.hrznstudio.titanium.component.progress.ProgressBarComponent;
import java.util.ArrayList;
import java.util.List;

public class MultiProgressBarHandler<T extends IComponentHarness>
implements IScreenAddonProvider {
    private final List<ProgressBarComponent<T>> posWorkBars = new ArrayList<ProgressBarComponent<T>>();

    public void addBar(ProgressBarComponent<T> bar) {
        this.posWorkBars.add(bar);
    }

    public void update() {
        for (ProgressBarComponent<T> posWorkBar : this.posWorkBars) {
            if (posWorkBar.getCanIncrease().test(posWorkBar.getComponentHarness())) {
                if (posWorkBar.getIncreaseType() && posWorkBar.getProgress() == 0) {
                    posWorkBar.onStart();
                }
                if (!posWorkBar.getIncreaseType() && posWorkBar.getProgress() == posWorkBar.getMaxProgress()) {
                    posWorkBar.onStart();
                }
                posWorkBar.tickBar();
                continue;
            }
            if (!posWorkBar.getCanReset().test(posWorkBar.getComponentHarness())) continue;
            posWorkBar.setProgress(posWorkBar.getIncreaseType() ? 0 : posWorkBar.getMaxProgress());
        }
    }

    @Override
    public List<IFactory<? extends IScreenAddon>> getScreenAddons() {
        ArrayList<IFactory<? extends IScreenAddon>> list = new ArrayList<IFactory<? extends IScreenAddon>>();
        for (ProgressBarComponent<T> posWorkBar : this.posWorkBars) {
            list.addAll(posWorkBar.getScreenAddons());
        }
        return list;
    }
}

