/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.container.impl;

import com.hrznstudio.titanium.block.tile.ActiveTile;
import com.hrznstudio.titanium.component.inventory.InventoryComponent;
import com.hrznstudio.titanium.container.impl.BasicInventoryContainer;
import com.hrznstudio.titanium.network.locator.ILocatable;
import com.hrznstudio.titanium.network.locator.LocatorInstance;
import com.hrznstudio.titanium.network.locator.instance.TileEntityLocatorInstance;
import java.util.Iterator;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.items.SlotItemHandler;
import net.minecraftforge.registries.ObjectHolder;

public class BasicTileContainer<T extends ActiveTile<T>>
extends BasicInventoryContainer
implements ILocatable {
    @ObjectHolder(value="titanium:tile_container")
    public static ContainerType<BasicTileContainer<?>> TYPE;
    private T tile;

    public BasicTileContainer(int id, PlayerInventory player, PacketBuffer buffer) {
        this((ActiveTile)player.field_70458_d.func_130014_f_().func_175625_s(buffer.func_179259_c()), player, id);
    }

    public BasicTileContainer(T tile, PlayerInventory inventory, int id) {
        super(TYPE, inventory, id, ((ActiveTile)tile).getAssetProvider());
        this.tile = tile;
        this.initInventory();
    }

    public void addTileSlots() {
        if (((ActiveTile)this.tile).getMultiInventoryComponent() != null) {
            for (InventoryComponent handler : ((ActiveTile)this.tile).getMultiInventoryComponent().getInventoryHandlers()) {
                int i = 0;
                for (int y = 0; y < handler.getYSize(); ++y) {
                    for (int x = 0; x < handler.getXSize(); ++x) {
                        this.func_75146_a((Slot)new SlotItemHandler(handler, i, handler.getXPos() + (Integer)handler.getSlotPosition().apply(i).getLeft(), handler.getYPos() + (Integer)handler.getSlotPosition().apply(i).getRight()));
                        ++i;
                    }
                }
            }
        }
    }

    public void updateSlotPosition() {
        if (((ActiveTile)this.tile).getMultiInventoryComponent() != null) {
            for (InventoryComponent handler : ((ActiveTile)this.tile).getMultiInventoryComponent().getInventoryHandlers()) {
                int i = 0;
                for (int y = 0; y < handler.getYSize(); ++y) {
                    for (int x = 0; x < handler.getXSize(); ++x) {
                        Slot inventorySlot;
                        Iterator iterator = this.field_75151_b.iterator();
                        while (!(!iterator.hasNext() || (inventorySlot = (Slot)iterator.next()) instanceof SlotItemHandler && ((SlotItemHandler)inventorySlot).getItemHandler().equals(handler) && i == inventorySlot.getSlotIndex())) {
                        }
                        ++i;
                    }
                }
            }
        }
    }

    @Override
    public boolean func_75145_c(@Nonnull PlayerEntity player) {
        return true;
    }

    public T getTile() {
        return this.tile;
    }

    @Override
    public LocatorInstance getLocatorInstance() {
        return new TileEntityLocatorInstance(this.tile.func_174877_v());
    }

    @Override
    public void addExtraSlots() {
        super.addExtraSlots();
        this.addTileSlots();
    }
}

