/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.portality.data;

import java.util.UUID;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;

public class PortalInformation {
    private UUID id;
    private UUID owner;
    private String name;
    private boolean isActive;
    private boolean isPrivate;
    private RegistryKey<World> dimension;
    private BlockPos location;
    private ItemStack display;
    private boolean interdimensional;

    public PortalInformation(UUID id, UUID owner, boolean isActive, boolean isPrivate, RegistryKey<World> dimension, BlockPos location, String name, ItemStack display, boolean interdimensional) {
        this.id = id;
        this.owner = owner;
        this.isActive = isActive;
        this.isPrivate = isPrivate;
        this.dimension = dimension;
        this.location = location;
        this.name = name;
        this.display = display;
        this.interdimensional = interdimensional;
    }

    public static PortalInformation readFromNBT(CompoundNBT info) {
        return new PortalInformation(info.func_186857_a("ID"), info.func_186857_a("Owner"), info.func_74767_n("Active"), info.func_74767_n("Private"), (RegistryKey<World>)RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation(info.func_74779_i("Dimension"))), BlockPos.func_218283_e((long)info.func_74763_f("Position")), info.func_74779_i("Name"), ItemStack.func_199557_a((CompoundNBT)info.func_74775_l("Display")), info.func_74767_n("Interdimensional"));
    }

    public UUID getId() {
        return this.id;
    }

    public UUID getOwner() {
        return this.owner;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public void setActive(boolean active) {
        this.isActive = active;
    }

    public boolean isPrivate() {
        return this.isPrivate;
    }

    public void setPrivate(boolean aPrivate) {
        this.isPrivate = aPrivate;
    }

    public RegistryKey<World> getDimension() {
        return this.dimension;
    }

    public BlockPos getLocation() {
        return this.location;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ItemStack getDisplay() {
        return this.display;
    }

    public void setDisplay(ItemStack display) {
        this.display = display;
    }

    public boolean isInterdimensional() {
        return this.interdimensional;
    }

    public void setInterdimensional(boolean interdimensional) {
        this.interdimensional = interdimensional;
    }

    public CompoundNBT writetoNBT() {
        CompoundNBT infoTag = new CompoundNBT();
        infoTag.func_186854_a("ID", this.getId());
        infoTag.func_186854_a("Owner", this.getOwner());
        infoTag.func_74757_a("Active", this.isActive());
        infoTag.func_74757_a("Private", this.isPrivate());
        infoTag.func_74778_a("Dimension", this.getDimension().func_240901_a_().toString());
        infoTag.func_74772_a("Position", this.getLocation().func_218275_a());
        infoTag.func_74778_a("Name", this.getName());
        infoTag.func_218657_a("Display", (INBT)this.display.serializeNBT());
        infoTag.func_74757_a("Interdimensional", this.interdimensional);
        return infoTag;
    }

    public String toString() {
        return "PortalInformation{id=" + this.id + ", owner=" + this.owner + ", isActive=" + this.isActive + ", isPrivate=" + this.isPrivate + ", dimension=" + this.dimension + ", location=" + this.location + '}';
    }
}

