/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.portality.gui;

import com.buuz135.portality.data.PortalInformation;
import com.buuz135.portality.gui.PortalityAssetProvider;
import com.buuz135.portality.gui.button.GuiButtonImagePortal;
import com.buuz135.portality.gui.button.PortalCallButton;
import com.buuz135.portality.tile.ControllerTile;
import com.hrznstudio.titanium.api.IFactory;
import com.hrznstudio.titanium.api.client.IScreenAddon;
import com.hrznstudio.titanium.client.screen.ScreenAddonScreen;
import com.hrznstudio.titanium.client.screen.asset.IAssetProvider;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import org.lwjgl.glfw.GLFW;

public class PortalsScreen
extends ScreenAddonScreen {
    private final int guiHeight;
    private final int guiWidth;
    private List<PortalInformation> informationList;
    private TextFieldWidget textField;
    private double scrolling = 0.0;
    private double lastScrolling = 0.0;
    private boolean isDragging;
    private int visiblePortalInformations;
    private List<GuiButtonImagePortal> portalButtons = new ArrayList<GuiButtonImagePortal>();
    private List<PortalInformation> currentlyShowing = new ArrayList<PortalInformation>();
    private PortalInformation selectedPortal;
    private ControllerTile controller;

    public PortalsScreen(ControllerTile controller) {
        super((IAssetProvider)PortalityAssetProvider.PROVIDER, false);
        this.guiWidth = 200;
        this.guiHeight = 186;
        this.controller = controller;
    }

    public void func_231160_c_() {
        super.func_231160_c_();
        this.x = this.field_230708_k_ / 2 - this.guiWidth / 2;
        this.y = this.field_230709_l_ / 2 - this.guiWidth / 2;
        if (this.informationList != null && !this.informationList.isEmpty()) {
            this.addPortalButtons();
        }
        this.textField = new TextFieldWidget(Minecraft.func_71410_x().field_71466_p, this.x + this.guiWidth - 131, this.y + 3, 100, 10, (ITextComponent)new StringTextComponent(""));
        this.textField.func_146195_b(true);
        this.textField.func_146189_e(true);
        this.textField.func_146185_a(true);
        this.getAddons().add(new PortalCallButton(this.x + 9, this.y + this.guiHeight + 2, this.controller, PortalCallButton.CallAction.OPEN, this));
        this.getAddons().add(new PortalCallButton(this.x + 53 + 9, this.y + this.guiHeight + 2, this.controller, PortalCallButton.CallAction.ONCE, this));
        this.getAddons().add(new PortalCallButton(this.x + 106 + 9, this.y + this.guiHeight + 2, this.controller, PortalCallButton.CallAction.FORCE, this));
    }

    private void addPortalButtons() {
        if (this.informationList == null) {
            return;
        }
        ArrayList<PortalInformation> tempInformations = new ArrayList<PortalInformation>(this.informationList);
        tempInformations.removeIf(information -> information.isPrivate() && !information.getOwner().equals(Minecraft.func_71410_x().field_71439_g.func_110124_au()));
        tempInformations.sort((o1, o2) -> Boolean.compare(o2.isPrivate(), o1.isPrivate()));
        if (!this.textField.func_146179_b().isEmpty()) {
            tempInformations.removeIf(portalInformation -> !portalInformation.getName().toLowerCase().contains(this.textField.func_146179_b().toLowerCase()));
        }
        this.field_230710_m_.removeIf(guiButton -> this.portalButtons.contains(guiButton));
        this.portalButtons.clear();
        this.visiblePortalInformations = tempInformations.size();
        int pointer = (int)((double)(tempInformations.size() - 7) * this.scrolling);
        this.currentlyShowing = tempInformations;
        for (int i = pointer; i < pointer + 7; ++i) {
            if (tempInformations.size() <= i) continue;
            final int finalI = i;
            GuiButtonImagePortal buttonImage = new GuiButtonImagePortal(this, (PortalInformation)tempInformations.get(finalI), this.x + 9, this.y + 19 + 23 * (finalI - pointer), 157, 22, 0, 234, 0, new ResourceLocation("portality", "textures/gui/portals.png")){

                public void func_230930_b_() {
                    PortalsScreen.this.selectedPortal = (PortalInformation)PortalsScreen.this.currentlyShowing.get(finalI + (int)((double)(PortalsScreen.this.currentlyShowing.size() - 7) * PortalsScreen.this.scrolling));
                }
            };
            this.func_230480_a_((Widget)buttonImage);
            this.portalButtons.add(buttonImage);
        }
    }

    public boolean func_231046_a_(int p_keyPressed_1_, int p_keyPressed_2_, int p_keyPressed_3_) {
        boolean pressed = super.func_231046_a_(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_);
        Minecraft.func_71410_x().func_212871_a_(() -> {
            this.scrolling = 0.0;
            this.lastScrolling = 0.0;
            this.addPortalButtons();
        });
        return pressed;
    }

    public void refresh(List<PortalInformation> informationList) {
        this.informationList = informationList;
        this.addPortalButtons();
    }

    public void renderBackground(MatrixStack stack, int mouseX, int mouseY, float partialTicks) {
        this.checkForScrolling(mouseX, mouseY);
        this.func_238651_a_(stack, 0);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(new ResourceLocation("portality", "textures/gui/portals.png"));
        Minecraft.func_71410_x().field_71462_r.func_238474_b_(stack, this.x, this.y, 0, 0, this.guiWidth, this.guiHeight);
        Minecraft.func_71410_x().field_71462_r.func_238474_b_(stack, this.x + this.guiWidth - 22, (int)((double)(this.y + 10) + 140.0 * this.scrolling), 200, 9, 18, 23);
        super.renderBackground(stack, mouseX, mouseY, partialTicks);
        this.textField.func_230431_b_(stack, mouseX, mouseY, partialTicks);
    }

    public List<IFactory<IScreenAddon>> guiAddons() {
        return Collections.emptyList();
    }

    public PortalInformation getSelectedPortal() {
        return this.selectedPortal;
    }

    public boolean func_231177_au__() {
        return false;
    }

    private void checkForScrolling(int mouseX, int mouseY) {
        if (GLFW.glfwGetMouseButton((long)Minecraft.func_71410_x().func_228018_at_().func_198092_i(), (int)0) == 1) {
            if (!this.isDragging && mouseX > this.x + this.guiWidth - 22 && mouseX < this.x + this.guiWidth - 22 + 18 && mouseY > this.y + 10 && mouseY < this.y + 10 + 151) {
                this.isDragging = true;
            }
            if (this.isDragging) {
                this.lastScrolling = this.scrolling;
                this.scrolling = MathHelper.func_151237_a((double)((double)(mouseY -= 25 + this.y) / 128.0), (double)0.0, (double)1.0);
                this.addPortalButtons();
            }
        } else {
            this.isDragging = false;
        }
    }

    public boolean func_231043_a_(double x, double y, double z) {
        this.scrolling = MathHelper.func_151237_a((double)(this.scrolling -= z / ((double)this.currentlyShowing.size() - 7.0)), (double)0.0, (double)1.0);
        this.addPortalButtons();
        return true;
    }
}

