/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.portality.proxy.client.render;

import com.buuz135.portality.block.ControllerBlock;
import com.buuz135.portality.tile.ControllerTile;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.awt.Color;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3f;

public class TESRPortal
extends TileEntityRenderer<ControllerTile> {
    private static final Random RANDOM = new Random(31100L);
    public static RenderType TYPE = TESRPortal.createRenderType();

    public TESRPortal(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
    }

    public static RenderType createRenderType() {
        RenderType.State state = RenderType.State.func_228694_a_().func_228724_a_(new RenderState.TextureState(new ResourceLocation("portality", "textures/blocks/portal_render.png"), false, false)).func_228726_a_(new RenderState.TransparencyState("translucent_transparency", () -> {
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            RenderSystem.enableAlphaTest();
        }, () -> {
            RenderSystem.disableBlend();
            RenderSystem.disableAlphaTest();
        })).func_228728_a_(true);
        return RenderType.func_228633_a_((String)"portal_render", (VertexFormat)DefaultVertexFormats.field_181709_i, (int)7, (int)256, (boolean)false, (boolean)true, (RenderType.State)state);
    }

    public void renderTop(MatrixStack stack, IVertexBuilder buffer, ControllerTile te, float frame, float xTrans, float yTrans, float zTrans, double offset, int width, Color color) {
        double scale = 0.9335;
        float y = 3.999f;
        float off = 4.0f - y;
        RenderSystem.enableAlphaTest();
        for (int posX = 0; posX < width; ++posX) {
            for (int posZ = 0; posZ < te.getLength(); ++posZ) {
                float pX1 = 1.0f;
                float u = 1.0f;
                float pX2 = 0.0f;
                float u2 = 0.0f;
                if (posX == 0) {
                    pX2 = 1.0f - frame;
                    u2 = 1.0f - frame;
                }
                if (posX == 1 && frame < 0.0f) {
                    pX2 = -frame;
                    u2 = -frame;
                }
                if (posX == width - 1) {
                    pX1 = Math.max(1.0f - frame, 0.0f);
                    u = 1.0f - 1.0f * frame;
                }
                int alpha = 150;
                float xOffset = (float)posX - 2.0f + frame + off + xTrans;
                float yOffset = yTrans - off;
                float zOffset = (float)posZ + zTrans;
                Matrix4f matrix = stack.func_227866_c_().func_227870_a_();
                buffer.func_227888_a_(matrix, pX2 + xOffset, yOffset, 0.0f + zOffset).func_225583_a_(u2, 0.0f).func_225586_a_(color.getRed(), color.getGreen(), color.getBlue(), alpha).func_181675_d();
                buffer.func_227888_a_(matrix, pX1 + xOffset, yOffset, 0.0f + zOffset).func_225583_a_(u, 0.0f).func_225586_a_(color.getRed(), color.getGreen(), color.getBlue(), alpha).func_181675_d();
                buffer.func_227888_a_(matrix, pX1 + xOffset, yOffset, 1.0f + zOffset).func_225583_a_(u, 1.0f).func_225586_a_(color.getRed(), color.getGreen(), color.getBlue(), alpha).func_181675_d();
                buffer.func_227888_a_(matrix, pX2 + xOffset, yOffset, 1.0f + zOffset).func_225583_a_(u2, 1.0f).func_225586_a_(color.getRed(), color.getGreen(), color.getBlue(), alpha).func_181675_d();
            }
        }
    }

    public void render(ControllerTile te, float p_225616_2_, MatrixStack matrixStack, IRenderTypeBuffer typeBuffer, int p_225616_5_, int p_225616_6_) {
        Direction facing;
        if (!te.isFormed()) {
            return;
        }
        RenderSystem.pushMatrix();
        float frame = (float)(te.func_145831_w().func_82737_E() % 60L) / 60.0f;
        Color color = Color.CYAN;
        int x = 0;
        int y = 0;
        int z = 0;
        if (te.isDisplayNameEnabled() && te.isActive()) {
            matrixStack.func_227860_a_();
            String name = te.getLinkData().getName();
            matrixStack.func_227861_a_(0.5, 1.5, 0.5);
            matrixStack.func_227863_a_(Minecraft.func_71410_x().func_175598_ae().func_229098_b_());
            matrixStack.func_227862_a_(-0.025f, -0.025f, 0.025f);
            float f1 = Minecraft.func_71410_x().field_71474_y.func_216840_a(0.25f);
            int j = (int)(f1 * 255.0f) << 24;
            Minecraft.func_71410_x().field_71466_p.func_228079_a_(name, (float)(-Minecraft.func_71410_x().field_71466_p.func_78256_a(name)) / 2.0f, 0.0f, -1, false, matrixStack.func_227866_c_().func_227870_a_(), typeBuffer, false, j, 0xF000F0);
            matrixStack.func_227865_b_();
        }
        if ((facing = (Direction)te.func_145831_w().func_180495_p(te.func_174877_v()).func_177229_b((Property)ControllerBlock.FACING_HORIZONTAL)) == Direction.SOUTH) {
            z = -1;
            x = -1;
            matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-180.0f));
        }
        if (facing == Direction.EAST) {
            z = -1;
            matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-90.0f));
        }
        if (facing == Direction.WEST) {
            x = -1;
            matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(90.0f));
        }
        if (facing == Direction.NORTH) {
            // empty if block
        }
        IVertexBuilder buffer = typeBuffer.getBuffer(TYPE);
        this.renderTop(matrixStack, buffer, te, frame, (float)(-te.getWidth()) + 2.0f + (float)x, (float)(te.getHeight() + y) - 1.0f, z, 0.4, te.getWidth() * 2, color);
        matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(90.0f));
        this.renderTop(matrixStack, buffer, te, frame, 2 + y, te.getWidth() - 1 - x, z, 0.2, te.getHeight() - 1, color);
        matrixStack.func_227863_a_(Vector3f.field_229182_e_.func_229187_a_(90.0f));
        matrixStack.func_227863_a_(Vector3f.field_229182_e_.func_229187_a_(90.0f));
        this.renderTop(matrixStack, buffer, te, frame, 2 - te.getHeight() + y, te.getWidth() + x, z, 0.0, te.getHeight() - 1, color);
        matrixStack.func_227863_a_(Vector3f.field_229182_e_.func_229187_a_(90.0f));
        this.renderTop(matrixStack, buffer, te, frame, -te.getWidth() - x + 1, -1 - y, z, 0.6, te.getWidth() * 2, color);
        RenderSystem.popMatrix();
    }
}

