/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.portality.tile;

import com.buuz135.portality.block.ControllerBlock;
import com.buuz135.portality.block.module.IPortalModule;
import com.buuz135.portality.data.PortalDataManager;
import com.buuz135.portality.data.PortalInformation;
import com.buuz135.portality.data.PortalLinkData;
import com.buuz135.portality.gui.ControllerScreen;
import com.buuz135.portality.gui.PortalsScreen;
import com.buuz135.portality.gui.RenameControllerScreen;
import com.buuz135.portality.gui.button.PortalSettingButton;
import com.buuz135.portality.gui.button.TextPortalButton;
import com.buuz135.portality.handler.ChunkLoaderHandler;
import com.buuz135.portality.handler.StructureHandler;
import com.buuz135.portality.handler.TeleportHandler;
import com.buuz135.portality.network.PortalNetworkMessage;
import com.buuz135.portality.proxy.CommonProxy;
import com.buuz135.portality.proxy.PortalityConfig;
import com.buuz135.portality.proxy.PortalitySoundHandler;
import com.buuz135.portality.proxy.client.TickeableSound;
import com.buuz135.portality.util.BlockPosUtils;
import com.hrznstudio.titanium.block.BasicTileBlock;
import com.hrznstudio.titanium.block.tile.PoweredTile;
import com.hrznstudio.titanium.client.screen.addon.StateButtonInfo;
import com.hrznstudio.titanium.component.energy.EnergyStorageComponent;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ControllerTile
extends PoweredTile<ControllerTile> {
    private static String NBT_FORMED = "Formed";
    private static String NBT_LENGTH = "Length";
    private static String NBT_WIDTH = "Width";
    private static String NBT_HEIGHT = "Height";
    private static String NBT_PORTAL = "Portal";
    private static String NBT_LINK = "Link";
    private static String NBT_DISPLAY = "Display";
    private static String NBT_ONCE = "Once";
    private boolean isFormed = false;
    private boolean onceCall = false;
    private boolean display = true;
    private PortalInformation information;
    private PortalLinkData linkData;
    @OnlyIn(value=Dist.CLIENT)
    private TickeableSound sound;
    private TeleportHandler teleportHandler = new TeleportHandler(this);
    private StructureHandler structureHandler = new StructureHandler(this);

    public ControllerTile() {
        super((BasicTileBlock)CommonProxy.BLOCK_CONTROLLER);
        this.addButton(new PortalSettingButton(-22, 12, () -> () -> OpenGui.open(1, this), new StateButtonInfo[]{new StateButtonInfo(0, PortalSettingButton.RENAME, new String[]{"portality.display.change_name"})}){

            @Override
            public int getState() {
                return 0;
            }
        }.setId(1));
        this.addButton(new PortalSettingButton(-22, 34, () -> () -> {}, new StateButtonInfo[]{new StateButtonInfo(0, PortalSettingButton.PUBLIC, new String[]{"portality.display.make_private"}), new StateButtonInfo(1, PortalSettingButton.PRIVATE, new String[]{"portality.display.make_public"})}){

            @Override
            public int getState() {
                return ControllerTile.this.information != null && ControllerTile.this.information.isPrivate() ? 1 : 0;
            }
        }.setPredicate((playerEntity, compoundNBT) -> {
            if (this.information.getOwner().equals(playerEntity.func_110124_au())) {
                this.togglePrivacy();
            }
        }).setId(2));
        this.addButton(new PortalSettingButton(-22, 56, () -> () -> {}, new StateButtonInfo[]{new StateButtonInfo(0, PortalSettingButton.NAME_SHOWN, new String[]{"portality.display.hide_name"}), new StateButtonInfo(1, PortalSettingButton.NAME_HIDDEN, new String[]{"portality.display.show_name"})}){

            @Override
            public int getState() {
                return ControllerTile.this.display ? 0 : 1;
            }
        }.setPredicate((playerEntity, compoundNBT) -> {
            if (this.information.getOwner().equals(playerEntity.func_110124_au())) {
                this.setDisplayNameEnabled(!this.isDisplayNameEnabled());
            }
        }).setId(3));
        this.addButton(new TextPortalButton(5, 90, 80, 16, "portality.display.call_portal").setClientConsumer(() -> screen -> OpenGui.open(2, this)).setId(4).setPredicate((playerEntity, compoundNBT) -> PortalNetworkMessage.sendInformationToPlayer((ServerPlayerEntity)playerEntity, this.isInterdimensional(), this.func_174877_v(), BlockPosUtils.getMaxDistance(this.getLength()))));
        this.addButton(new TextPortalButton(90, 90, 80, 16, "portality.display.close_portal").setPredicate((playerEntity, compoundNBT) -> this.closeLink()).setId(5));
    }

    public void func_73660_a() {
        if (this.isActive()) {
            this.teleportHandler.tick();
            if (this.linkData != null) {
                for (Entity entity : this.field_145850_b.func_217357_a(Entity.class, this.getPortalArea())) {
                    this.teleportHandler.addEntityToTeleport(entity, this.linkData);
                }
            }
        }
        if (!this.field_145850_b.field_72995_K) {
            this.workModules();
        }
        if (this.field_145850_b.field_72995_K) {
            this.tickSound();
            return;
        }
        if (this.isActive() && this.linkData != null) {
            this.getEnergyStorage().extractEnergy((this.linkData.isCaller() ? 2 : 1) * this.structureHandler.getLength() * PortalityConfig.POWER_PORTAL_TICK, false);
            if (this.getEnergyStorage().getEnergyStored() == 0 || !this.isFormed) {
                this.closeLink();
            }
        }
        if (this.field_145850_b.func_82737_E() % 10L == 0L) {
            if (this.structureHandler.shouldCheckForStructure()) {
                this.isFormed = this.structureHandler.checkArea();
                if (this.isFormed) {
                    this.structureHandler.setShouldCheckForStructure(false);
                } else {
                    this.structureHandler.cancelFrameBlocks();
                }
            }
            if (this.isFormed) {
                this.getPortalInfo();
                if (this.linkData != null) {
                    ChunkLoaderHandler.addPortalAsChunkloader(this);
                    TileEntity tileEntity = this.field_145850_b.func_73046_m().func_71218_a(this.linkData.getDimension()).func_175625_s(this.linkData.getPos());
                    if (!(tileEntity instanceof ControllerTile && ((ControllerTile)tileEntity).getLinkData() != null && ((ControllerTile)tileEntity).getLinkData().getDimension().equals((Object)this.field_145850_b.func_234923_W_()) && ((ControllerTile)tileEntity).getLinkData().getPos().equals((Object)this.field_174879_c))) {
                        this.closeLink();
                    }
                }
            }
            this.markForUpdate();
        }
    }

    @Nonnull
    public ControllerTile getSelf() {
        return this;
    }

    @OnlyIn(value=Dist.CLIENT)
    private void tickSound() {
        if (this.isActive()) {
            if (this.sound == null) {
                this.sound = new TickeableSound(this.field_145850_b, this.field_174879_c, PortalitySoundHandler.PORTAL);
                Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)this.sound);
            } else {
                this.sound.increase();
            }
        } else if (this.sound != null) {
            if (this.sound.func_147655_f() > 0.0f) {
                this.sound.decrease();
            } else {
                this.sound.setDone();
                this.sound = null;
            }
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound = super.func_189515_b(compound);
        compound.func_74757_a(NBT_FORMED, this.isFormed);
        compound.func_74768_a(NBT_LENGTH, this.structureHandler.getLength());
        compound.func_74768_a(NBT_WIDTH, this.structureHandler.getWidth());
        compound.func_74768_a(NBT_HEIGHT, this.structureHandler.getHeight());
        compound.func_74757_a(NBT_ONCE, this.onceCall);
        compound.func_74757_a(NBT_DISPLAY, this.display);
        if (this.information != null) {
            compound.func_218657_a(NBT_PORTAL, (INBT)this.information.writetoNBT());
        }
        if (this.linkData != null) {
            compound.func_218657_a(NBT_LINK, (INBT)this.linkData.writeToNBT());
        }
        return compound;
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        this.isFormed = compound.func_74767_n(NBT_FORMED);
        this.structureHandler.setLength(compound.func_74762_e(NBT_LENGTH));
        this.structureHandler.setWidth(compound.func_74762_e(NBT_WIDTH));
        this.structureHandler.setHeight(compound.func_74762_e(NBT_HEIGHT));
        if (compound.func_74764_b(NBT_PORTAL)) {
            this.information = PortalInformation.readFromNBT(compound.func_74775_l(NBT_PORTAL));
        }
        if (compound.func_74764_b(NBT_LINK)) {
            this.linkData = PortalLinkData.readFromNBT(compound.func_74775_l(NBT_LINK));
        }
        this.onceCall = compound.func_74767_n(NBT_ONCE);
        this.display = compound.func_74767_n(NBT_DISPLAY);
        super.func_230337_a_(state, compound);
    }

    public void breakController() {
        this.closeLink();
        this.structureHandler.cancelFrameBlocks();
    }

    private void workModules() {
        boolean interdimensional = false;
        for (BlockPos pos : this.structureHandler.getModules()) {
            Block block = this.field_145850_b.func_180495_p(pos).func_177230_c();
            if (!(block instanceof IPortalModule)) continue;
            if (((IPortalModule)block).allowsInterdimensionalTravel()) {
                interdimensional = true;
            }
            if (!this.isActive()) continue;
            ((IPortalModule)block).work(this, pos);
        }
        PortalDataManager.setPortalInterdimensional(this.field_145850_b, this.field_174879_c, interdimensional);
    }

    public AxisAlignedBB getPortalArea() {
        if (!(this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c() instanceof ControllerBlock)) {
            return new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        }
        Direction facing = (Direction)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((Property)ControllerBlock.FACING_HORIZONTAL);
        BlockPos corner1 = this.field_174879_c.func_177967_a(facing.func_176746_e(), this.structureHandler.getWidth()).func_177972_a(Direction.UP);
        BlockPos corner2 = this.field_174879_c.func_177967_a(facing.func_176735_f(), this.structureHandler.getWidth()).func_177967_a(Direction.UP, this.structureHandler.getHeight() - 1).func_177967_a(facing.func_176734_d(), this.structureHandler.getLength() - 1);
        return new AxisAlignedBB(corner1, corner2);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return this.getPortalArea();
    }

    private void getPortalInfo() {
        this.information = PortalDataManager.getInfoFromPos(this.field_145850_b, this.field_174879_c);
        this.markForUpdate();
    }

    public void togglePrivacy() {
        PortalDataManager.setPortalPrivacy(this.field_145850_b, this.field_174879_c, !this.information.isPrivate());
        this.getPortalInfo();
        this.markForUpdate();
    }

    public boolean isFormed() {
        return this.isFormed;
    }

    public boolean isPrivate() {
        return this.information != null && this.information.isPrivate();
    }

    public UUID getOwner() {
        if (this.information != null) {
            return this.information.getOwner();
        }
        return null;
    }

    public UUID getID() {
        if (this.information != null) {
            return this.information.getId();
        }
        return null;
    }

    public String getPortalDisplayName() {
        if (this.information != null) {
            return this.information.getName();
        }
        return "";
    }

    public void setDisplayName(String name) {
        if (this.information != null) {
            this.information.setName(name);
        }
    }

    public boolean isInterdimensional() {
        return this.information != null && this.information.isInterdimensional();
    }

    public ItemStack getDisplay() {
        if (this.information != null) {
            return this.information.getDisplay();
        }
        return ItemStack.field_190927_a;
    }

    public void linkTo(PortalLinkData data, PortalLinkData.PortalCallType type) {
        ServerWorld world;
        TileEntity entity;
        if (type == PortalLinkData.PortalCallType.FORCE) {
            this.closeLink();
        }
        if (this.linkData != null) {
            return;
        }
        if (type == PortalLinkData.PortalCallType.SINGLE) {
            this.onceCall = true;
        }
        if (data.isCaller() && (entity = (world = this.field_145850_b.func_73046_m().func_71218_a(data.getDimension())).func_175625_s(data.getPos())) instanceof ControllerTile) {
            data.setName(((ControllerTile)entity).getPortalDisplayName());
            ((ControllerTile)entity).linkTo(new PortalLinkData((RegistryKey<World>)this.field_145850_b.func_234923_W_(), this.field_174879_c, false, this.getPortalDisplayName()), type);
            int power = PortalityConfig.PORTAL_POWER_OPEN_INTERDIMENSIONAL;
            if (entity.func_145831_w().equals(this.field_145850_b)) {
                power = (int)this.field_174879_c.func_177951_i(new Vector3i(entity.func_174877_v().func_177958_n(), entity.func_174877_v().func_177952_p(), entity.func_174877_v().func_177956_o())) * this.structureHandler.getLength();
            }
            this.getEnergyStorage().extractEnergy(power, false);
        }
        PortalDataManager.setActiveStatus(this.field_145850_b, this.field_174879_c, true);
        this.linkData = data;
    }

    public void closeLink() {
        if (this.linkData != null) {
            PortalDataManager.setActiveStatus(this.field_145850_b, this.field_174879_c, false);
            ServerWorld world = this.field_145850_b.func_73046_m().func_71218_a(this.linkData.getDimension());
            TileEntity entity = world.func_175625_s(this.linkData.getPos());
            this.linkData = null;
            if (entity instanceof ControllerTile) {
                ((ControllerTile)entity).closeLink();
            }
        }
        ChunkLoaderHandler.removePortalAsChunkloader(this);
    }

    public boolean isActive() {
        return this.information != null && this.information.isActive();
    }

    public PortalLinkData getLinkData() {
        return this.linkData;
    }

    public boolean isDisplayNameEnabled() {
        return this.display;
    }

    public void setDisplayNameEnabled(ItemStack display) {
        PortalDataManager.setPortalDisplay(this.field_145850_b, this.field_174879_c, display);
        this.getPortalInfo();
        this.markForUpdate();
    }

    public void setDisplayNameEnabled(boolean display) {
        this.display = display;
        this.markForUpdate();
    }

    public List<BlockPos> getModules() {
        return this.structureHandler.getModules();
    }

    public boolean teleportedEntity() {
        if (this.onceCall) {
            this.onceCall = false;
            this.closeLink();
            return true;
        }
        return false;
    }

    public boolean isShouldCheckForStructure() {
        return this.structureHandler.shouldCheckForStructure();
    }

    public void setShouldCheckForStructure(boolean shouldCheckForStructure) {
        this.structureHandler.setShouldCheckForStructure(shouldCheckForStructure);
    }

    public int getWidth() {
        return this.structureHandler.getWidth();
    }

    public int getHeight() {
        return this.structureHandler.getHeight();
    }

    public int getLength() {
        return this.structureHandler.getLength();
    }

    public PortalInformation getInformation() {
        this.getPortalInfo();
        return this.information;
    }

    @OnlyIn(value=Dist.CLIENT)
    public ActionResultType onActivated(PlayerEntity playerIn, Hand hand, Direction facing, double hitX, double hitY, double hitZ) {
        if (super.onActivated(playerIn, hand, facing, hitX, hitY, hitZ) != ActionResultType.SUCCESS && !this.field_145850_b.func_201670_d()) {
            Minecraft.func_71410_x().func_213165_a(() -> OpenGui.open(0, this));
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    protected EnergyStorageComponent<ControllerTile> createEnergyStorage() {
        return new EnergyStorageComponent(PortalityConfig.MAX_PORTAL_POWER, PortalityConfig.MAX_PORTAL_POWER_IN, 10, 20);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class OpenGui {
        public static void open(int id, ControllerTile controller) {
            switch (id) {
                case 0: {
                    Minecraft.func_71410_x().func_147108_a((Screen)new ControllerScreen(controller));
                    return;
                }
                case 1: {
                    Minecraft.func_71410_x().func_147108_a((Screen)new RenameControllerScreen(controller));
                    return;
                }
                case 2: {
                    Minecraft.func_71410_x().func_147108_a((Screen)new PortalsScreen(controller));
                    return;
                }
            }
        }
    }
}

