/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.block;

import com.hrznstudio.titanium.api.IFactory;
import com.hrznstudio.titanium.api.IRecipeProvider;
import com.hrznstudio.titanium.api.raytrace.DistanceRayTraceResult;
import com.hrznstudio.titanium.datagenerator.loot.block.BasicBlockLootTables;
import com.hrznstudio.titanium.datagenerator.loot.block.IBlockLootTableProvider;
import com.hrznstudio.titanium.module.api.IAlternativeEntries;
import com.hrznstudio.titanium.module.api.RegistryManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootTable;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;

public abstract class BasicBlock
extends Block
implements IAlternativeEntries,
IRecipeProvider,
IBlockLootTableProvider {
    private ItemGroup itemGroup = ItemGroup.field_78027_g;
    private BlockItem item;

    public BasicBlock(AbstractBlock.Properties properties) {
        super(properties);
    }

    @Nullable
    protected static DistanceRayTraceResult rayTraceBox(BlockPos pos, Vector3d start, Vector3d end, VoxelShape shape) {
        BlockRayTraceResult bbResult = shape.func_212433_a(start, end, pos);
        if (bbResult != null) {
            Vector3d hitVec = bbResult.func_216347_e();
            Direction sideHit = bbResult.func_216354_b();
            double dist = start.func_72438_d(hitVec);
            return new DistanceRayTraceResult(hitVec, sideHit, pos, shape, dist);
        }
        return null;
    }

    @Nonnull
    public VoxelShape func_220071_b(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext selectionContext) {
        if (this.hasCustomBoxes(state, world, pos)) {
            VoxelShape shape = VoxelShapes.func_197880_a();
            for (VoxelShape shape1 : this.getBoundingBoxes(state, world, pos)) {
                shape = VoxelShapes.func_197878_a((VoxelShape)shape, (VoxelShape)shape1, (IBooleanFunction)IBooleanFunction.field_223244_o_);
            }
            return shape;
        }
        return super.func_220071_b(state, world, pos, selectionContext);
    }

    public IFactory<BlockItem> getItemBlockFactory() {
        return () -> (BlockItem)new BlockItem((Block)this, new Item.Properties().func_200916_a(this.itemGroup)).setRegistryName(Objects.requireNonNull(this.getRegistryName()));
    }

    @Override
    public void addAlternatives(RegistryManager<?> registry) {
        this.item = this.getItemBlockFactory().create();
        registry.content(Item.class, this.item);
    }

    @Nonnull
    public Item func_199767_j() {
        return this.item;
    }

    public void setItem(BlockItem item) {
        this.item = item;
    }

    public List<VoxelShape> getBoundingBoxes(BlockState state, IBlockReader source, BlockPos pos) {
        return Collections.emptyList();
    }

    public boolean hasCustomBoxes(BlockState state, IBlockReader source, BlockPos pos) {
        return false;
    }

    @Nullable
    protected RayTraceResult rayTraceBoxesClosest(Vector3d start, Vector3d end, BlockPos pos, List<VoxelShape> boxes) {
        ArrayList<DistanceRayTraceResult> results = new ArrayList<DistanceRayTraceResult>();
        for (VoxelShape box : boxes) {
            DistanceRayTraceResult hit = BasicBlock.rayTraceBox(pos, start, end, box);
            if (hit == null) continue;
            results.add(hit);
        }
        DistanceRayTraceResult closestHit = null;
        double curClosest = Double.MAX_VALUE;
        for (DistanceRayTraceResult hit : results) {
            if (!(curClosest > hit.getDistance())) continue;
            closestHit = hit;
            curClosest = hit.getDistance();
        }
        return closestHit;
    }

    public ItemGroup getItemGroup() {
        return this.itemGroup;
    }

    public void setItemGroup(ItemGroup itemGroup) {
        this.itemGroup = itemGroup;
    }

    @Override
    public void registerRecipe(Consumer<IFinishedRecipe> consumer) {
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.func_177230_c() != newState.func_177230_c()) {
            InventoryHelper.func_219961_a((World)worldIn, (BlockPos)pos, this.getDynamicDrops(state, worldIn, pos, newState, isMoving));
            worldIn.func_175666_e(pos, (Block)this);
        }
        super.func_196243_a(state, worldIn, pos, newState, isMoving);
    }

    public NonNullList<ItemStack> getDynamicDrops(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        NonNullList stacks = NonNullList.func_191196_a();
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity != null) {
            tileentity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(iItemHandler -> {
                for (int i = 0; i < iItemHandler.getSlots(); ++i) {
                    stacks.add((Object)iItemHandler.getStackInSlot(i));
                }
            });
        }
        return stacks;
    }

    public boolean hasIndividualRenderVoxelShape() {
        return false;
    }

    @Override
    public LootTable.Builder getLootTable(@Nonnull BasicBlockLootTables blockLootTables) {
        return blockLootTables.droppingSelf((IItemProvider)this);
    }
}

