/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.client.screen.addon;

import com.hrznstudio.titanium.api.client.assets.types.ITankAsset;
import com.hrznstudio.titanium.client.screen.addon.BasicScreenAddon;
import com.hrznstudio.titanium.client.screen.asset.IAssetProvider;
import com.hrznstudio.titanium.component.fluid.FluidTankComponent;
import com.hrznstudio.titanium.util.AssetUtil;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import java.awt.Rectangle;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.Texture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;

public class TankScreenAddon
extends BasicScreenAddon {
    private IFluidTank tank;
    private ITankAsset asset;
    private FluidTankComponent.Type type;

    public TankScreenAddon(int posX, int posY, IFluidTank tank, FluidTankComponent.Type type) {
        super(posX, posY);
        this.tank = tank;
        this.type = type;
    }

    @Override
    public void drawBackgroundLayer(MatrixStack stack, Screen screen, IAssetProvider provider, int guiX, int guiY, int mouseX, int mouseY, float partialTicks) {
        this.asset = IAssetProvider.getAsset(provider, this.type.getAssetType());
        Rectangle area = this.asset.getArea();
        if (!this.tank.getFluid().isEmpty()) {
            TextureAtlasSprite sprite;
            Texture texture;
            FluidStack fluidStack = this.tank.getFluid();
            int stored = this.tank.getFluidAmount();
            int capacity = this.tank.getCapacity();
            int topBottomPadding = this.asset.getFluidRenderPadding(Direction.UP) + this.asset.getFluidRenderPadding(Direction.DOWN);
            int offset = stored * (area.height - topBottomPadding) / capacity;
            ResourceLocation flowing = fluidStack.getFluid().getAttributes().getStillTexture(fluidStack);
            if (flowing != null && (texture = screen.getMinecraft().func_110434_K().func_229267_b_(AtlasTexture.field_110575_b)) instanceof AtlasTexture && (sprite = ((AtlasTexture)texture).func_195424_a(flowing)) != null) {
                screen.getMinecraft().func_110434_K().func_110577_a(AtlasTexture.field_110575_b);
                Color color = new Color(fluidStack.getFluid().getAttributes().getColor());
                RenderSystem.color4f((float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f), (float)((float)color.getAlpha() / 255.0f));
                RenderSystem.enableBlend();
                Screen.func_238470_a_((MatrixStack)stack, (int)(this.getPosX() + guiX + this.asset.getFluidRenderPadding(Direction.WEST)), (int)(this.getPosY() + guiY + this.asset.getFluidRenderPadding(Direction.UP) + (fluidStack.getFluid().getAttributes().isGaseous() ? area.height - topBottomPadding : area.height - topBottomPadding - offset)), (int)0, (int)((int)(area.getWidth() - (double)this.asset.getFluidRenderPadding(Direction.EAST) - (double)this.asset.getFluidRenderPadding(Direction.WEST))), (int)offset, (TextureAtlasSprite)sprite);
                RenderSystem.disableBlend();
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
        }
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableAlphaTest();
        ITankAsset asset = IAssetProvider.getAsset(provider, this.type.getAssetType());
        AssetUtil.drawAsset(stack, screen, asset, guiX + this.getPosX(), guiY + this.getPosY());
    }

    @Override
    public void drawForegroundLayer(MatrixStack stack, Screen screen, IAssetProvider provider, int guiX, int guiY, int mouseX, int mouseY) {
    }

    public List<ITextProperties> getTooltipLines() {
        return Arrays.asList(new StringTextComponent(TextFormatting.GOLD + "Fluid: " + TextFormatting.WHITE + (this.tank.getFluid().isEmpty() ? "Empty" : new TranslationTextComponent(this.tank.getFluid().getFluid().getAttributes().getTranslationKey(this.tank.getFluid())).getString())), new StringTextComponent(TextFormatting.GOLD + "Amount: " + TextFormatting.WHITE + new DecimalFormat().format(this.tank.getFluidAmount()) + TextFormatting.GOLD + "/" + TextFormatting.WHITE + new DecimalFormat().format(this.tank.getCapacity()) + TextFormatting.DARK_AQUA + "mb"));
    }

    @Override
    public int getXSize() {
        return this.asset != null ? this.asset.getArea().width : 0;
    }

    @Override
    public int getYSize() {
        return this.asset != null ? this.asset.getArea().height : 0;
    }
}

