/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.component.bundle;

import com.hrznstudio.titanium.api.IFactory;
import com.hrznstudio.titanium.api.client.AssetTypes;
import com.hrznstudio.titanium.api.client.IScreenAddon;
import com.hrznstudio.titanium.block.tile.BasicTile;
import com.hrznstudio.titanium.client.screen.addon.AssetScreenAddon;
import com.hrznstudio.titanium.component.IComponentBundle;
import com.hrznstudio.titanium.component.IComponentHandler;
import com.hrznstudio.titanium.component.IComponentHarness;
import com.hrznstudio.titanium.component.inventory.InventoryComponent;
import com.hrznstudio.titanium.component.progress.ProgressBarComponent;
import com.hrznstudio.titanium.container.addon.IContainerAddon;
import com.hrznstudio.titanium.util.TitaniumFluidUtil;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class TankInteractionBundle<T extends BasicTile>
implements IComponentBundle,
INBTSerializable<CompoundNBT> {
    private final Supplier<LazyOptional<IFluidHandler>> fluidHandler;
    private int posX;
    private int posY;
    private InventoryComponent<T> input;
    private InventoryComponent<T> output;
    private ProgressBarComponent<T> bar;

    public TankInteractionBundle(Supplier<LazyOptional<IFluidHandler>> fluidHandler, int posX, int posY, T componentHarness, int maxProgress) {
        this.fluidHandler = fluidHandler;
        this.posX = posX;
        this.posY = posY;
        this.input = new InventoryComponent("tank_input", posX + 5, posY + 7, 1).setSlotToItemStackRender(0, new ItemStack((IItemProvider)Items.field_151133_ar)).setOutputFilter((stack, integer) -> false).setSlotToColorRender(0, DyeColor.BLUE).setInputFilter((stack, integer) -> stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).isPresent()).setComponentHarness((IComponentHarness)componentHarness);
        this.output = new InventoryComponent("tank_output", posX + 5, posY + 60, 1).setSlotToItemStackRender(0, new ItemStack((IItemProvider)Items.field_151133_ar)).setInputFilter((stack, integer) -> false).setSlotToColorRender(0, DyeColor.ORANGE).setComponentHarness((IComponentHarness)componentHarness);
        this.bar = new ProgressBarComponent(posX + 5, posY + 30, maxProgress).setBarDirection(ProgressBarComponent.BarDirection.ARROW_DOWN).setCanReset(t -> true).setCanIncrease(t -> !this.input.getStackInSlot(0).func_190926_b() && this.input.getStackInSlot(0).getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).isPresent() && !this.getOutputStack(false).func_190926_b() && (this.output.getStackInSlot(0).func_190926_b() || ItemHandlerHelper.canItemStacksStack((ItemStack)this.getOutputStack(false), (ItemStack)this.output.getStackInSlot(0)))).setOnFinishWork(() -> {
            ItemStack result = this.getOutputStack(false);
            if (ItemHandlerHelper.insertItem(this.output, (ItemStack)result, (boolean)true).func_190926_b()) {
                result = this.getOutputStack(true);
                ItemHandlerHelper.insertItem(this.output, (ItemStack)result, (boolean)false);
                this.input.getStackInSlot(0).func_190918_g(1);
                componentHarness.func_70296_d();
            }
        }).setComponentHarness((BasicTile)((Object)((IComponentHarness)componentHarness)));
    }

    @Override
    public void accept(IComponentHandler ... handler) {
        for (IComponentHandler iComponentHandler : handler) {
            iComponentHandler.add(this.input, this.output, this.bar);
        }
    }

    public ItemStack getOutputStack(boolean execute) {
        return (ItemStack)this.fluidHandler.get().map(iFluidHandler -> {
            ItemStack stack = this.input.getStackInSlot(0).func_77946_l();
            stack.func_190920_e(1);
            FluidActionResult result = FluidUtil.tryFillContainer((ItemStack)stack, (IFluidHandler)iFluidHandler, (int)Integer.MAX_VALUE, null, (boolean)execute);
            if (result.isSuccess()) {
                return result.getResult();
            }
            result = TitaniumFluidUtil.tryEmptyContainer(stack, iFluidHandler, Integer.MAX_VALUE, execute);
            if (result.isSuccess()) {
                return result.getResult();
            }
            return ItemStack.field_190927_a;
        }).orElse((Object)ItemStack.field_190927_a);
    }

    @Override
    public List<IFactory<? extends IScreenAddon>> getScreenAddons() {
        return Collections.singletonList(() -> new AssetScreenAddon(AssetTypes.AUGMENT_BACKGROUND, this.posX, this.posY, true));
    }

    @Override
    public List<IFactory<? extends IContainerAddon>> getContainerAddons() {
        return Collections.emptyList();
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT compoundNBT = new CompoundNBT();
        compoundNBT.func_218657_a("Input", (INBT)this.input.serializeNBT());
        compoundNBT.func_218657_a("Output", (INBT)this.output.serializeNBT());
        compoundNBT.func_218657_a("Bar", (INBT)this.bar.serializeNBT());
        return compoundNBT;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        this.input.deserializeNBT(nbt.func_74775_l("Input"));
        this.output.deserializeNBT(nbt.func_74775_l("Output"));
        this.bar.deserializeNBT(nbt.func_74775_l("Bar"));
    }
}

