/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.material;

import com.google.common.collect.HashMultimap;
import com.hrznstudio.titanium.Titanium;
import com.hrznstudio.titanium.annotation.MaterialReference;
import com.hrznstudio.titanium.api.material.IHasColor;
import com.hrznstudio.titanium.api.material.IResourceType;
import com.hrznstudio.titanium.event.handler.EventManager;
import com.hrznstudio.titanium.material.ResourceMaterial;
import com.hrznstudio.titanium.module.Feature;
import com.hrznstudio.titanium.module.Module;
import com.hrznstudio.titanium.module.ModuleController;
import com.hrznstudio.titanium.plugin.PluginPhase;
import com.hrznstudio.titanium.tab.AdvancedTitaniumTab;
import com.hrznstudio.titanium.util.AnnotationUtil;
import com.hrznstudio.titanium.util.SidedHandler;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ResourceRegistry {
    public static AdvancedTitaniumTab RESOURCES = new AdvancedTitaniumTab("resources", true);
    public static Logger LOGGER = LogManager.getLogger((String)"titanium-ResourceRegistry");
    public static final String PLUGIN_NAME = "resources";
    private static HashMap<String, ResourceMaterial> MATERIALS = new HashMap();
    private static HashMap<String, HashMultimap<String, Field>> ANNOTATED_FIELDS = new HashMap();
    private static Field modifiersField;

    public static void onInit() {
        ResourceRegistry.scanForReferences();
        Titanium.RESOURCES.execute(PluginPhase.CONSTRUCTION);
        SidedHandler.runOn(Dist.CLIENT, () -> () -> EventManager.mod(ColorHandlerEvent.Item.class).process(item -> ResourceRegistry.getMaterials().forEach(material -> material.getGenerated().values().stream().filter(entry -> entry instanceof IHasColor).forEach(entry -> {
            if (entry instanceof Block) {
                item.getBlockColors().func_186722_a((state, world, pos, tint) -> ((IHasColor)entry).getColor(tint), new Block[]{(Block)entry});
            } else if (entry instanceof Item) {
                item.getItemColors().func_199877_a((stack, tint) -> ((IHasColor)entry).getColor(tint), new IItemProvider[]{(IItemProvider)entry});
            }
        }))).subscribe());
    }

    private static void scanForReferences() {
        if (modifiersField == null) {
            try {
                modifiersField = Field.class.getDeclaredField("modifiers");
                modifiersField.setAccessible(true);
            }
            catch (NoSuchFieldException e) {
                LOGGER.error((Object)e);
            }
        }
        for (Field annotatedField : AnnotationUtil.getAnnotatedFields(MaterialReference.class)) {
            if (!Modifier.isStatic(annotatedField.getModifiers())) continue;
            MaterialReference reference = annotatedField.getAnnotation(MaterialReference.class);
            if (!annotatedField.isAccessible()) {
                annotatedField.setAccessible(true);
            }
            if (Modifier.isFinal(annotatedField.getModifiers())) {
                try {
                    modifiersField.setInt(annotatedField, annotatedField.getModifiers() & 0xFFFFFFEF);
                }
                catch (IllegalAccessException e) {
                    LOGGER.error((Object)e);
                }
            }
            ANNOTATED_FIELDS.computeIfAbsent(reference.material(), s -> HashMultimap.create()).put((Object)reference.type(), (Object)annotatedField);
        }
    }

    public static void initModules(ModuleController controller) {
        Module.Builder builder = Module.builder(PLUGIN_NAME).useCustomFile();
        ResourceRegistry.getMaterials().forEach(material -> {
            if (material.getGeneratorTypes().size() > 0) {
                material.getGeneratorTypes().values().forEach(type -> {
                    Feature.Builder feature = Feature.builder(material.getMaterialType() + "." + type.func_176610_l());
                    ForgeRegistryEntry entry = material.generate((IResourceType)type);
                    if (entry != null) {
                        feature.content(entry.getRegistryType(), (IForgeRegistryEntry)entry);
                        builder.feature(feature);
                    }
                });
            }
        });
        controller.addModule(builder);
    }

    public static void onPostInit() {
        ResourceRegistry.getMaterials().stream().map(material -> material.getGenerated().values()).flatMap(Collection::stream).filter(forgeRegistryEntry -> forgeRegistryEntry instanceof IItemProvider && ForgeRegistries.ITEMS.containsKey(forgeRegistryEntry.getRegistryName())).forEach(forgeRegistryEntry -> RESOURCES.addIconStack(new ItemStack((IItemProvider)((IItemProvider)forgeRegistryEntry).func_199767_j())));
    }

    public static ResourceMaterial getOrCreate(String type) {
        return MATERIALS.computeIfAbsent(type, s -> new ResourceMaterial(type));
    }

    public static Collection<ResourceMaterial> getMaterials() {
        return MATERIALS.values();
    }

    public static void injectField(ResourceMaterial material, IResourceType type, ForgeRegistryEntry entry) {
        HashMultimap<String, Field> multimap;
        if (ANNOTATED_FIELDS.containsKey(material.getMaterialType()) && (multimap = ANNOTATED_FIELDS.get(material.getMaterialType())).containsKey((Object)type.func_176610_l())) {
            multimap.get((Object)type.func_176610_l()).stream().filter(field -> entry.getRegistryType().isAssignableFrom(field.getType())).forEach(field -> {
                try {
                    field.set(null, entry);
                }
                catch (IllegalAccessException e) {
                    LOGGER.error((Object)e);
                }
            });
        }
    }
}

