/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.recipe.serializer;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.hrznstudio.titanium.Titanium;
import com.hrznstudio.titanium.network.CompoundSerializableDataHandler;
import com.hrznstudio.titanium.recipe.serializer.IRecipeSerializerReversed;
import com.hrznstudio.titanium.recipe.serializer.JSONSerializableDataHandler;
import com.hrznstudio.titanium.recipe.serializer.SerializableRecipe;
import java.lang.reflect.Field;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class GenericSerializer<T extends SerializableRecipe>
extends ForgeRegistryEntry<IRecipeSerializer<?>>
implements IRecipeSerializer<T>,
IRecipeSerializerReversed<T> {
    private final Class<T> recipeClass;
    private final IRecipeType<T> recipeType;

    public GenericSerializer(IRecipeType<T> recipeType, Class<T> recipeClass) {
        this.recipeType = recipeType;
        this.recipeClass = recipeClass;
    }

    public GenericSerializer(ResourceLocation resourceLocation, Class<T> recipeClass) {
        this(IRecipeType.func_222147_a((String)resourceLocation.toString()), recipeClass);
        this.setRegistryName(resourceLocation);
    }

    @Nonnull
    public T read(@Nonnull ResourceLocation recipeId, JsonObject json) {
        try {
            SerializableRecipe recipe = (SerializableRecipe)this.recipeClass.getConstructor(ResourceLocation.class).newInstance(recipeId);
            for (Map.Entry entry : json.entrySet()) {
                if (!this.fieldExists((String)entry.getKey()) || !JSONSerializableDataHandler.acceptField(this.recipeClass.getField((String)entry.getKey()), this.recipeClass.getField((String)entry.getKey()).getType())) continue;
                this.recipeClass.getField((String)entry.getKey()).set(recipe, JSONSerializableDataHandler.read(this.recipeClass.getField((String)entry.getKey()).getType(), (JsonElement)entry.getValue()));
            }
            return (T)recipe;
        }
        catch (Exception e) {
            Titanium.LOGGER.catching((Throwable)e);
            throw new JsonParseException((Throwable)e);
        }
    }

    @Override
    public JsonObject write(T recipe) {
        JsonObject object = new JsonObject();
        try {
            for (Field field : this.recipeClass.getFields()) {
                if (!JSONSerializableDataHandler.acceptField(field, field.getType())) continue;
                object.add(field.getName(), JSONSerializableDataHandler.write(field.getType(), field.get(recipe)));
            }
        }
        catch (Exception e) {
            Titanium.LOGGER.catching((Throwable)e);
        }
        return object;
    }

    @ParametersAreNonnullByDefault
    public T read(ResourceLocation recipeId, PacketBuffer buffer) {
        try {
            SerializableRecipe recipe = (SerializableRecipe)this.recipeClass.getConstructor(ResourceLocation.class).newInstance(recipeId);
            for (Field field : this.recipeClass.getFields()) {
                if (!CompoundSerializableDataHandler.acceptField(field, field.getType())) continue;
                CompoundSerializableDataHandler.readField(field, field.getType(), buffer, recipe);
            }
            return (T)recipe;
        }
        catch (Exception e) {
            Titanium.LOGGER.error((Object)recipeId);
            Titanium.LOGGER.catching((Throwable)e);
            return null;
        }
    }

    @ParametersAreNonnullByDefault
    public void write(PacketBuffer buffer, T recipe) {
        try {
            for (Field field : this.recipeClass.getFields()) {
                if (!CompoundSerializableDataHandler.acceptField(field, field.getType())) continue;
                CompoundSerializableDataHandler.writeField(field, field.getType(), buffer, recipe);
            }
        }
        catch (Exception e) {
            Titanium.LOGGER.catching((Throwable)e);
        }
    }

    public IRecipeType<T> getRecipeType() {
        return this.recipeType;
    }

    private boolean fieldExists(String field) {
        for (Field recipeClassField : this.recipeClass.getFields()) {
            if (!recipeClassField.getName().equalsIgnoreCase(field)) continue;
            return true;
        }
        return false;
    }
}

