/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.util;

import java.util.LinkedList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.minecart.MinecartEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SPlayEntityEffectPacket;
import net.minecraft.network.play.server.SPlaySoundEventPacket;
import net.minecraft.network.play.server.SPlayerAbilitiesPacket;
import net.minecraft.network.play.server.SRespawnPacket;
import net.minecraft.network.play.server.SServerDifficultyPacket;
import net.minecraft.network.play.server.SSetPassengersPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerList;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeManager;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.IWorldInfo;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.hooks.BasicEventHooks;

public class TeleportationUtils {
    public static Entity teleportEntity(Entity entity, RegistryKey<World> dimension, double xCoord, double yCoord, double zCoord, float yaw, float pitch) {
        if (entity == null || entity.field_70170_p.field_72995_K) {
            return entity;
        }
        MinecraftServer server = entity.func_184102_h();
        RegistryKey sourceDim = entity.field_70170_p.func_234923_W_();
        if (!entity.func_184207_aI() && !entity.func_184218_aH()) {
            return TeleportationUtils.handleEntityTeleport(entity, server, (RegistryKey<World>)sourceDim, dimension, xCoord, yCoord, zCoord, yaw, pitch);
        }
        Entity rootEntity = entity.func_184208_bv();
        PassengerHelper passengerHelper = new PassengerHelper(rootEntity);
        PassengerHelper rider = passengerHelper.getPassenger(entity);
        if (rider == null) {
            return entity;
        }
        passengerHelper.teleport(server, (RegistryKey<World>)sourceDim, dimension, xCoord, yCoord, zCoord, yaw, pitch);
        passengerHelper.remountRiders();
        passengerHelper.updateClients();
        return rider.entity;
    }

    public static Entity teleportEntity(Entity entity, RegistryKey<World> dimension, double xCoord, double yCoord, double zCoord) {
        return TeleportationUtils.teleportEntity(entity, dimension, xCoord, yCoord, zCoord, entity.field_70177_z, entity.field_70125_A);
    }

    private static Entity handleEntityTeleport(Entity entity, MinecraftServer server, RegistryKey<World> sourceDim, RegistryKey<World> targetDim, double xCoord, double yCoord, double zCoord, float yaw, float pitch) {
        boolean interDimensional;
        if (entity == null || entity.field_70170_p.field_72995_K) {
            return entity;
        }
        boolean bl = interDimensional = sourceDim != targetDim;
        if (interDimensional && !ForgeHooks.onTravelToDimension((Entity)entity, targetDim)) {
            return entity;
        }
        if (interDimensional) {
            if (entity instanceof ServerPlayerEntity) {
                return TeleportationUtils.teleportPlayerInterdimentional((ServerPlayerEntity)entity, server, sourceDim, targetDim, xCoord, yCoord, zCoord, yaw, pitch);
            }
            return TeleportationUtils.teleportEntityInterdimentional(entity, server, sourceDim, targetDim, xCoord, yCoord, zCoord, yaw, pitch);
        }
        if (entity instanceof ServerPlayerEntity) {
            ServerPlayerEntity player = (ServerPlayerEntity)entity;
            player.field_71135_a.func_147364_a(xCoord, yCoord, zCoord, yaw, pitch);
            player.func_70034_d(yaw);
        } else {
            entity.func_70012_b(xCoord, yCoord, zCoord, yaw, pitch);
            entity.func_70034_d(yaw);
        }
        return entity;
    }

    private static Entity teleportEntityInterdimentional(Entity entity, MinecraftServer server, RegistryKey<World> sourceDim, RegistryKey<World> targetDim, double xCoord, double yCoord, double zCoord, float yaw, float pitch) {
        if (!entity.func_70089_S()) {
            return null;
        }
        ServerWorld sourceWorld = server.func_71218_a(sourceDim);
        ServerWorld targetWorld = server.func_71218_a(targetDim);
        if (entity.func_70089_S() && entity instanceof MinecartEntity) {
            entity.field_70128_L = true;
            entity.func_241206_a_(targetWorld);
            entity.field_70128_L = false;
        }
        entity.field_70170_p = targetWorld;
        sourceWorld.func_217467_h(entity);
        entity.field_70128_L = false;
        entity.func_70012_b(xCoord, yCoord, zCoord, yaw, pitch);
        sourceWorld.func_217479_a(entity);
        Entity newEntity = entity.func_200600_R().func_200721_a((World)targetWorld);
        if (newEntity != null) {
            newEntity.func_180432_n(entity);
            newEntity.func_70012_b(xCoord, yCoord, zCoord, yaw, pitch);
            boolean flag = newEntity.field_98038_p;
            newEntity.field_98038_p = true;
            targetWorld.func_217376_c(newEntity);
            newEntity.field_98038_p = flag;
            targetWorld.func_217479_a(newEntity);
        }
        entity.field_70128_L = true;
        sourceWorld.func_82742_i();
        targetWorld.func_82742_i();
        return newEntity;
    }

    private static PlayerEntity teleportPlayerInterdimentional(ServerPlayerEntity player, MinecraftServer server, RegistryKey<World> sourceDim, RegistryKey<World> destination, double xCoord, double yCoord, double zCoord, float yaw, float pitch) {
        ServerWorld sourceWorld = server.func_71218_a(sourceDim);
        ServerWorld destinationWorld = server.func_71218_a(destination);
        IWorldInfo sourceInfo = sourceWorld.func_72912_H();
        PlayerList playerList = server.func_184103_al();
        player.field_70170_p = destinationWorld;
        player.field_71135_a.func_147359_a((IPacket)new SRespawnPacket(destinationWorld.func_234922_V_(), destinationWorld.func_234923_W_(), BiomeManager.func_235200_a_((long)destinationWorld.func_72905_C()), player.field_71134_c.func_73081_b(), player.field_71134_c.func_241815_c_(), destinationWorld.func_234925_Z_(), destinationWorld.func_241109_A_(), true));
        player.field_71135_a.func_147359_a((IPacket)new SServerDifficultyPacket(sourceInfo.func_176130_y(), sourceInfo.func_176123_z()));
        playerList.func_187243_f(player);
        sourceWorld.removeEntity((Entity)player, true);
        player.revive();
        player.func_70012_b(xCoord, yCoord, zCoord, yaw, pitch);
        player.func_70029_a((World)destinationWorld);
        destinationWorld.func_217447_b(player);
        player.field_71135_a.func_147364_a(xCoord, yCoord, zCoord, yaw, pitch);
        player.field_71134_c.func_73080_a(destinationWorld);
        player.field_71135_a.func_147359_a((IPacket)new SPlayerAbilitiesPacket(player.field_71075_bZ));
        playerList.func_72354_b(player, destinationWorld);
        playerList.func_72385_f(player);
        player.func_70651_bq().forEach(effectInstance -> player.field_71135_a.func_147359_a((IPacket)new SPlayEntityEffectPacket(player.func_145782_y(), effectInstance)));
        player.field_71135_a.func_147359_a((IPacket)new SPlaySoundEventPacket(1032, BlockPos.field_177992_a, 0, false));
        BasicEventHooks.firePlayerChangedDimensionEvent((PlayerEntity)player, sourceDim, destination);
        return player;
    }

    public static Entity getHighestRidingEntity(Entity mount) {
        Entity entity = mount;
        while (entity.func_184188_bt().size() > 0) {
            entity = (Entity)entity.func_184188_bt().get(0);
        }
        return entity;
    }

    private static class PassengerHelper {
        public Entity entity;
        public LinkedList<PassengerHelper> passengers = new LinkedList();
        public double offsetX;
        public double offsetY;
        public double offsetZ;

        public PassengerHelper(Entity entity) {
            this.entity = entity;
            if (entity.func_184218_aH()) {
                this.offsetX = entity.func_226277_ct_() - entity.func_184187_bx().func_226277_ct_();
                this.offsetY = entity.func_226278_cu_() - entity.func_184187_bx().func_226278_cu_();
                this.offsetZ = entity.func_226281_cx_() - entity.func_184187_bx().func_226281_cx_();
            }
            for (Entity passenger : entity.func_184188_bt()) {
                this.passengers.add(new PassengerHelper(passenger));
            }
        }

        public void teleport(MinecraftServer server, RegistryKey<World> sourceDim, RegistryKey<World> targetDim, double xCoord, double yCoord, double zCoord, float yaw, float pitch) {
            this.entity.func_184226_ay();
            this.entity = TeleportationUtils.handleEntityTeleport(this.entity, server, (RegistryKey<World>)sourceDim, (RegistryKey<World>)targetDim, xCoord, yCoord, zCoord, yaw, pitch);
            for (PassengerHelper passenger : this.passengers) {
                passenger.teleport(server, sourceDim, targetDim, xCoord, yCoord, zCoord, yaw, pitch);
            }
        }

        public void remountRiders() {
            if (this.entity.func_184218_aH()) {
                this.entity.func_70012_b(this.entity.func_226277_ct_() + this.offsetX, this.entity.func_226278_cu_() + this.offsetY, this.entity.func_226281_cx_() + this.offsetZ, this.entity.field_70177_z, this.entity.field_70125_A);
            }
            for (PassengerHelper passenger : this.passengers) {
                passenger.entity.func_184205_a(this.entity, true);
                passenger.remountRiders();
            }
        }

        public void updateClients() {
            if (this.entity instanceof ServerPlayerEntity) {
                this.updateClient((ServerPlayerEntity)this.entity);
            }
            for (PassengerHelper passenger : this.passengers) {
                passenger.updateClients();
            }
        }

        private void updateClient(ServerPlayerEntity playerMP) {
            if (this.entity.func_184207_aI()) {
                playerMP.field_71135_a.func_147359_a((IPacket)new SSetPassengersPacket(this.entity));
            }
            for (PassengerHelper passenger : this.passengers) {
                passenger.updateClients();
            }
        }

        public PassengerHelper getPassenger(Entity passenger) {
            if (this.entity == passenger) {
                return this;
            }
            for (PassengerHelper rider : this.passengers) {
                PassengerHelper re = rider.getPassenger(passenger);
                if (re == null) continue;
                return re;
            }
            return null;
        }
    }
}

